/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.stats.mysql;

import com.oceanbase.tools.dbbrowser.model.DBSession;
import com.oceanbase.tools.dbbrowser.stats.mysql.MySQLNoLessThan5700StatsAccessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class DorisStatsAccessor
extends MySQLNoLessThan5700StatsAccessor {
    private static final String QUERY_SESSION_FROM_PROCESSLIST = "show full processlist";

    public DorisStatsAccessor(@NonNull JdbcOperations jdbcOperations) {
        super(jdbcOperations);
        if (jdbcOperations == null) {
            throw new NullPointerException("jdbcOperations is marked non-null but is null");
        }
    }

    @Override
    public List<DBSession> listAllSessions() {
        return this.jdbcOperations.query(QUERY_SESSION_FROM_PROCESSLIST, (RowMapper)new DorisDBSessionMapper());
    }

    @Override
    public DBSession currentSession() {
        String connectionId = (String)this.jdbcOperations.queryForObject("select connection_id()", (rs, rowNum) -> rs.getString(1));
        List sessions = this.listAllSessions().stream().filter(s -> Objects.equals(connectionId, s.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sessions)) {
            return DBSession.unknown();
        }
        if (sessions.size() != 1) {
            throw new IllegalStateException("Failed to locate the session by id, " + connectionId);
        }
        return (DBSession)sessions.get(0);
    }

    private static class DorisDBSessionMapper
    implements RowMapper<DBSession> {
        private DorisDBSessionMapper() {
        }

        public DBSession mapRow(ResultSet rs, int rowNum) throws SQLException {
            DBSession session = new DBSession();
            session.setId(rs.getString("Id"));
            session.setUsername(rs.getString("User"));
            session.setHost(rs.getString("Host"));
            session.setDatabaseName(rs.getString("Db"));
            session.setCommand(rs.getString("Command"));
            session.setExecuteTime(rs.getInt("Time"));
            session.setState(rs.getString("State"));
            session.setTransState(DBSession.DBTransState.UNKNOWN);
            session.setProxyHost(session.getHost());
            return session;
        }
    }
}

