/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.util;

import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javax.validation.constraints.NotEmpty;
import lombok.NonNull;

public abstract class SqlBuilder
implements Appendable,
CharSequence {
    private static final String LIST_DELIMITER = ",";
    private static final String WHITE_SPACE = " ";
    private static final String LINE_BREAKER = "\n";
    private static final String NAME_SEPARATOR = ".";
    private final StringBuilder sb = new StringBuilder();

    @Override
    public SqlBuilder append(CharSequence csq) {
        this.sb.append(csq);
        return this;
    }

    @Override
    public SqlBuilder append(CharSequence csq, int start, int end) {
        this.sb.append(csq, start, end);
        return this;
    }

    @Override
    public SqlBuilder append(char c) {
        this.sb.append(c);
        return this;
    }

    public SqlBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public SqlBuilder identifierIf(String identifier, boolean expression) {
        if (expression) {
            return this.identifier(identifier);
        }
        return this.append(identifier);
    }

    public SqlBuilder identifier(String schemaName, String objectName) {
        this.schemaPrefixIfNotBlank(schemaName);
        return this.identifier(objectName);
    }

    public SqlBuilder schemaPrefixIfNotBlank(String schemaName) {
        if (StringUtils.isBlank((CharSequence)schemaName)) {
            return this;
        }
        return this.identifier(schemaName).append(NAME_SEPARATOR);
    }

    public abstract SqlBuilder identifier(String var1);

    public abstract SqlBuilder value(String var1);

    public abstract SqlBuilder defaultValue(String var1);

    public SqlBuilder values(@NonNull List<String> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.appendList(values, this::value);
    }

    public SqlBuilder identifiersIf(List<String> identifiers, boolean expression) throws IOException {
        if (expression) {
            return this.identifiers(identifiers);
        }
        return this.list(identifiers);
    }

    public SqlBuilder identifiers(@NotEmpty List<String> identifiers) {
        return this.appendList(identifiers, this::identifier);
    }

    public SqlBuilder likeValueIfNotBlank(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return this;
        }
        return this.columnValueContains(null, value);
    }

    public SqlBuilder columnValueContains(String columnName, @NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (StringUtils.isNotBlank((CharSequence)columnName)) {
            this.identifier(columnName);
        }
        this.append(" LIKE ").value("%" + StringUtils.escapeLike(value) + "%");
        return this;
    }

    public SqlBuilder list(@NotEmpty List<String> list) {
        return this.appendList(list, this::append);
    }

    public SqlBuilder space() {
        return this.append(WHITE_SPACE);
    }

    public SqlBuilder line() {
        return this.append(LINE_BREAKER);
    }

    private SqlBuilder appendList(List<String> list, Consumer<String> consumer) {
        int size = list.size();
        int pos = 0;
        for (String value : list) {
            consumer.accept(value);
            if (++pos >= size) continue;
            this.append(LIST_DELIMITER);
        }
        return this;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    public String substring(int start, int end) {
        return this.sb.substring(start, end);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }
}

