/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.util;

import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SqlUtils {
    private static final String ALL_CURRENT_TIMESTAMP_EXPRESSIONS_STR = "NOW(),UTC_TIMESTAMP,UTC_TIMESTAMP(),LOCALTIME, LOCALTIME(),LOCALTIMESTAMP,LOCALTIMESTAMP(),CURRENT_TIMESTAMP,CURRENT_TIMESTAMP()";
    private static final Set<String> ALL_CURRENT_TIMESTAMP_EXPRESSIONS = SqlUtils.newHashSet("NOW(),UTC_TIMESTAMP,UTC_TIMESTAMP(),LOCALTIME, LOCALTIME(),LOCALTIMESTAMP,LOCALTIMESTAMP(),CURRENT_TIMESTAMP,CURRENT_TIMESTAMP()".split(","));

    public static String quoteMysqlDefaultValue(String value) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (SqlUtils.isCurrentTimestampExpression(value)) {
            return value;
        }
        return StringUtils.quoteMysqlValue(value);
    }

    public static boolean isCurrentTimestampExpression(String express) {
        if (StringUtils.isBlank((CharSequence)express)) {
            return false;
        }
        return ALL_CURRENT_TIMESTAMP_EXPRESSIONS.contains(express.toUpperCase());
    }

    @SafeVarargs
    private static <E> HashSet<E> newHashSet(E ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }
}

