/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.editor.DBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.model.DBColumnGroupElement;
import com.oceanbase.tools.dbbrowser.model.DBConstraintType;
import com.oceanbase.tools.dbbrowser.model.DBIndexType;
import com.oceanbase.tools.dbbrowser.model.DBTable;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.util.DBObjectEditorUtils;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public abstract class DBTableEditor
implements DBObjectEditor<DBTable> {
    protected DBObjectEditor<DBTableIndex> indexEditor;
    protected DBObjectEditor<DBTableColumn> columnEditor;
    protected DBObjectEditor<DBTableConstraint> constraintEditor;
    protected DBObjectEditor<DBTablePartition> partitionEditor;

    public DBTableEditor(DBObjectEditor<DBTableIndex> indexEditor, DBObjectEditor<DBTableColumn> columnEditor, DBObjectEditor<DBTableConstraint> constraintEditor, DBObjectEditor<DBTablePartition> partitionEditor) {
        this.indexEditor = indexEditor;
        this.columnEditor = columnEditor;
        this.constraintEditor = constraintEditor;
        this.partitionEditor = partitionEditor;
    }

    @Override
    public boolean editable() {
        return true;
    }

    @Override
    public String generateCreateObjectDDL(@NotNull DBTable table) {
        this.fillSchemaNameAndTableName(table);
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("CREATE TABLE ").append(this.getFullyQualifiedTableName(table)).append(" (").line();
        boolean isFirstSentence = true;
        for (DBTableColumn column : table.getColumns()) {
            if (!isFirstSentence) {
                sqlBuilder.append(",").line();
            }
            isFirstSentence = false;
            sqlBuilder.append(this.columnEditor.generateCreateDefinitionDDL(column));
        }
        if (this.createIndexWhenCreatingTable()) {
            for (DBTableIndex index : this.excludePrimaryKeyIndex(table.getIndexes(), table.getConstraints())) {
                if (!isFirstSentence) {
                    sqlBuilder.append(",").line();
                }
                isFirstSentence = false;
                sqlBuilder.append(this.indexEditor.generateCreateDefinitionDDL(index));
            }
        }
        for (DBTableConstraint constraint : this.excludeUniqueConstraint(table.getIndexes(), table.getConstraints())) {
            if (!isFirstSentence) {
                sqlBuilder.append(",").line();
            }
            isFirstSentence = false;
            sqlBuilder.append(this.constraintEditor.generateCreateDefinitionDDL(constraint));
        }
        sqlBuilder.line().append(") ");
        this.appendTableOptions(table, sqlBuilder);
        if (Objects.nonNull(table.getPartition())) {
            sqlBuilder.append(this.partitionEditor.generateCreateDefinitionDDL(table.getPartition()));
        }
        if (CollectionUtils.isNotEmpty(table.getColumnGroups())) {
            sqlBuilder.append(" WITH COLUMN GROUP(").append(table.getColumnGroups().stream().map(DBColumnGroupElement::toString).collect(Collectors.joining(","))).append(")");
        }
        sqlBuilder.append(";\n");
        this.appendTableComment(table, sqlBuilder);
        this.appendColumnComment(table, sqlBuilder);
        return sqlBuilder.toString();
    }

    protected abstract void appendColumnComment(DBTable var1, SqlBuilder var2);

    protected abstract void appendTableComment(DBTable var1, SqlBuilder var2);

    protected abstract boolean createIndexWhenCreatingTable();

    protected abstract void appendTableOptions(DBTable var1, SqlBuilder var2);

    @Override
    public String generateCreateDefinitionDDL(@NotNull DBTable table) {
        return this.generateCreateObjectDDL(table);
    }

    @Override
    public String generateDropObjectDDL(@NotNull DBTable table) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("DROP TABLE ").append(this.getFullyQualifiedTableName(table));
        return sqlBuilder.toString();
    }

    @Override
    public String generateUpdateObjectDDL(@NotNull DBTable oldTable, @NotNull DBTable newTable) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (!StringUtils.equals((CharSequence)oldTable.getName(), (CharSequence)newTable.getName())) {
            sqlBuilder.append(this.generateRenameObjectDDL(oldTable, newTable));
            sqlBuilder.append(";\n");
        }
        this.generateUpdateTableOptionDDL(oldTable, newTable, sqlBuilder);
        this.fillSchemaNameAndTableName(oldTable, newTable);
        sqlBuilder.append(this.columnEditor.generateUpdateObjectListDDL(oldTable.getColumns(), newTable.getColumns()));
        sqlBuilder.append(this.indexEditor.generateUpdateObjectListDDL(oldTable.getIndexes(), newTable.getIndexes()));
        sqlBuilder.append(this.constraintEditor.generateUpdateObjectListDDL(oldTable.getConstraints(), newTable.getConstraints()));
        sqlBuilder.append(this.partitionEditor.generateUpdateObjectDDL(oldTable.getPartition(), newTable.getPartition()));
        sqlBuilder.append(this.generateUpdateColumnGroupDDL(oldTable, newTable));
        return sqlBuilder.toString();
    }

    @Override
    public String generateUpdateObjectListDDL(Collection<DBTable> oldTables, Collection<DBTable> newTables) {
        throw new NotImplementedException();
    }

    public String generateUpdateObjectDDLWithoutRenaming(@NotNull DBTable oldTable, @NotNull DBTable newTable) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        this.generateUpdateTableOptionDDL(oldTable, newTable, sqlBuilder);
        this.fillSchemaNameAndTableName(oldTable, newTable);
        DBObjectEditorUtils.generateShadowTableColumnListUpdateDDL(oldTable.getColumns(), newTable.getColumns(), this.columnEditor, sqlBuilder);
        DBObjectEditorUtils.generateShadowIndexListUpdateDDL(this.excludePrimaryKeyIndex(oldTable.getIndexes(), oldTable.getConstraints()), this.excludePrimaryKeyIndex(newTable.getIndexes(), newTable.getConstraints()), this.indexEditor, sqlBuilder);
        DBObjectEditorUtils.generateShadowTableConstraintListUpdateDDL(this.excludeUniqueConstraint(oldTable.getIndexes(), oldTable.getConstraints()), this.excludeUniqueConstraint(newTable.getIndexes(), newTable.getConstraints()), this.constraintEditor, sqlBuilder);
        sqlBuilder.append(this.generateUpdateColumnGroupDDL(oldTable, newTable));
        DBTablePartitionEditor editor = (DBTablePartitionEditor)this.partitionEditor;
        sqlBuilder.append(editor.generateShadowTableUpdateObjectDDL(oldTable.getPartition(), newTable.getPartition()));
        return sqlBuilder.toString();
    }

    public abstract void generateUpdateTableOptionDDL(DBTable var1, DBTable var2, SqlBuilder var3);

    protected abstract SqlBuilder sqlBuilder();

    protected String getFullyQualifiedTableName(@NotNull DBTable table) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (StringUtils.isNotEmpty((CharSequence)table.getSchemaName())) {
            sqlBuilder.identifier(table.getSchemaName()).append(".");
        }
        sqlBuilder.identifier(table.getName());
        return sqlBuilder.toString();
    }

    public List<DBTableConstraint> excludeUniqueConstraint(List<DBTableIndex> indexes, List<DBTableConstraint> constraints) {
        if (CollectionUtils.isEmpty(indexes) || CollectionUtils.isEmpty(constraints)) {
            return constraints;
        }
        Set uniqueIndexNames = indexes.stream().filter(index -> index.getType() == DBIndexType.UNIQUE).map(DBTableIndex::getName).collect(Collectors.toSet());
        return constraints.stream().filter(constraint -> !uniqueIndexNames.contains(constraint.getName()) || constraint.getType() != DBConstraintType.UNIQUE_KEY).collect(Collectors.toList());
    }

    public List<DBTableIndex> excludePrimaryKeyIndex(List<DBTableIndex> indexes, List<DBTableConstraint> constraints) {
        if (CollectionUtils.isEmpty(indexes) || CollectionUtils.isEmpty(constraints)) {
            return indexes;
        }
        Optional<String> primaryKeyNameOpt = constraints.stream().filter(constraint -> constraint.getType() == DBConstraintType.PRIMARY_KEY).findFirst().map(DBTableConstraint::getName);
        return indexes.stream().filter(index -> !StringUtils.equals((CharSequence)index.getName(), (CharSequence)primaryKeyNameOpt.orElse("")) || index.getType() != DBIndexType.UNIQUE).collect(Collectors.toList());
    }

    private void fillSchemaNameAndTableName(DBTable oldTable, DBTable newTable) {
        this.fillSchemaNameAndTableName(oldTable);
        this.fillSchemaNameAndTableName(newTable);
    }

    private void fillSchemaNameAndTableName(DBTable table) {
        this.fillColumnSchemaNameAndTableName(table.getColumns(), table.getSchemaName(), table.getName());
        this.fillIndexSchemaNameAndTableName(table.getIndexes(), table.getSchemaName(), table.getName());
        this.fillConstraintSchemaNameAndTableName(table.getConstraints(), table.getSchemaName(), table.getName());
        this.fillPartitionSchemaNameAndTableName(table.getPartition(), table.getSchemaName(), table.getName());
    }

    private void fillColumnSchemaNameAndTableName(List<DBTableColumn> columns, String schemaName, String tableName) {
        if (CollectionUtils.isNotEmpty(columns)) {
            columns.forEach(column -> {
                column.setSchemaName(schemaName);
                column.setTableName(tableName);
            });
        }
    }

    private void fillIndexSchemaNameAndTableName(List<DBTableIndex> indexes, String schemaName, String tableName) {
        if (CollectionUtils.isNotEmpty(indexes)) {
            indexes.forEach(index -> {
                index.setSchemaName(schemaName);
                index.setTableName(tableName);
            });
        }
    }

    private void fillConstraintSchemaNameAndTableName(List<DBTableConstraint> constraints, String schemaName, String tableName) {
        if (CollectionUtils.isNotEmpty(constraints)) {
            constraints.forEach(constraint -> {
                constraint.setSchemaName(schemaName);
                constraint.setTableName(tableName);
            });
        }
    }

    private void fillPartitionSchemaNameAndTableName(DBTablePartition constraint, String schemaName, String tableName) {
        if (Objects.nonNull(constraint)) {
            constraint.setSchemaName(schemaName);
            constraint.setTableName(tableName);
        }
    }

    public String generateUpdateColumnGroupDDL(DBTable oldTable, DBTable newTable) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        HashSet<DBColumnGroupElement> oldColumnGroups = new HashSet<DBColumnGroupElement>();
        if (oldTable.getColumnGroups() != null) {
            oldColumnGroups.addAll(oldTable.getColumnGroups());
        }
        HashSet<DBColumnGroupElement> newColumnGroups = new HashSet<DBColumnGroupElement>();
        if (newTable.getColumnGroups() != null) {
            newColumnGroups.addAll(newTable.getColumnGroups());
        }
        ArrayList<DBColumnGroupElement> columnsToBeDropped = new ArrayList<DBColumnGroupElement>();
        ArrayList<DBColumnGroupElement> columnsToBeCreated = new ArrayList<DBColumnGroupElement>();
        for (DBColumnGroupElement columnGroup : oldColumnGroups) {
            if (newColumnGroups.contains(columnGroup)) continue;
            columnsToBeDropped.add(columnGroup);
        }
        for (DBColumnGroupElement columnGroup : newColumnGroups) {
            if (oldColumnGroups.contains(columnGroup)) continue;
            columnsToBeCreated.add(columnGroup);
        }
        if (!columnsToBeDropped.isEmpty()) {
            sqlBuilder.append(this.generateDropColumnGroupDDL(columnsToBeDropped, oldTable));
        }
        if (!columnsToBeCreated.isEmpty()) {
            sqlBuilder.append(this.generateCreateColumnGroupDDL(columnsToBeCreated, newTable));
        }
        return sqlBuilder.toString();
    }

    private String generateDropColumnGroupDDL(List<DBColumnGroupElement> columnGroups, DBTable table) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(table)).append(" DROP COLUMN GROUP(").append(columnGroups.stream().map(DBColumnGroupElement::toString).collect(Collectors.joining(","))).append(");\n");
        return sqlBuilder.toString();
    }

    private String generateCreateColumnGroupDDL(List<DBColumnGroupElement> columnGroups, DBTable table) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(table)).append(" ADD COLUMN GROUP(").append(columnGroups.stream().map(DBColumnGroupElement::toString).collect(Collectors.joining(","))).append(");\n");
        return sqlBuilder.toString();
    }

    public DBObjectEditor<DBTableIndex> getIndexEditor() {
        return this.indexEditor;
    }

    public void setIndexEditor(DBObjectEditor<DBTableIndex> indexEditor) {
        this.indexEditor = indexEditor;
    }

    public DBObjectEditor<DBTableColumn> getColumnEditor() {
        return this.columnEditor;
    }

    public void setColumnEditor(DBObjectEditor<DBTableColumn> columnEditor) {
        this.columnEditor = columnEditor;
    }

    public DBObjectEditor<DBTableConstraint> getConstraintEditor() {
        return this.constraintEditor;
    }

    public void setConstraintEditor(DBObjectEditor<DBTableConstraint> constraintEditor) {
        this.constraintEditor = constraintEditor;
    }

    public DBObjectEditor<DBTablePartition> getPartitionEditor() {
        return this.partitionEditor;
    }

    public void setPartitionEditor(DBObjectEditor<DBTablePartition> partitionEditor) {
        this.partitionEditor = partitionEditor;
    }
}

