/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.mysql;

import com.oceanbase.tools.dbbrowser.editor.DBTableColumnEditor;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.datatype.DataTypeUtil;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class MySQLColumnEditor
extends DBTableColumnEditor {
    @Override
    protected SqlBuilder sqlBuilder() {
        return new MySQLSqlBuilder();
    }

    @Override
    protected boolean appendColumnKeyWord() {
        return true;
    }

    @Override
    protected List<DBTableColumnEditor.DBColumnModifier> getSupportColumnModifiers() {
        return Arrays.asList(new DBTableColumnEditor.DataTypeModifier(), new CharsetModifier(), new CollationModifier(), new DefaultOptionModifier(), new ExtraInfoModifier(), new CommentModifier(), new DBTableColumnEditor.NullNotNullModifier());
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBTableColumn oldColumn, @NotNull DBTableColumn newColumn) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(oldColumn)).append(" CHANGE COLUMN ").identifier(oldColumn.getName()).space().append(this.generateCreateDefinitionForUpdateDDL(oldColumn, newColumn));
        return sqlBuilder.toString();
    }

    @Override
    protected void generateColumnComment(DBTableColumn column, SqlBuilder sqlBuilder) {
    }

    protected class DefaultOptionModifier
    implements DBTableColumnEditor.DBColumnModifier {
        protected DefaultOptionModifier() {
        }

        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            String defaultValue = column.getDefaultValue();
            if ((Objects.isNull(column.getVirtual()) || !column.getVirtual().booleanValue()) && StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                sqlBuilder.append(" DEFAULT " + defaultValue);
            }
        }
    }

    protected static class CommentModifier
    implements DBTableColumnEditor.DBColumnModifier {
        protected CommentModifier() {
        }

        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            if (StringUtils.isNotBlank((CharSequence)column.getComment())) {
                sqlBuilder.append(" COMMENT ").value(column.getComment());
            }
        }
    }

    protected static class ExtraInfoModifier
    implements DBTableColumnEditor.DBColumnModifier {
        protected ExtraInfoModifier() {
        }

        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            if (Objects.nonNull(column.getVirtual()) && column.getVirtual().booleanValue()) {
                if (StringUtils.isEmpty((CharSequence)column.getGenExpression())) {
                    column.setGenExpression("");
                }
                sqlBuilder.append(" GENERATED ALWAYS AS (").append(column.getGenExpression()).append(")");
                if (Objects.nonNull(column.getStored()) && column.getStored().booleanValue()) {
                    sqlBuilder.append(" STORED ");
                } else {
                    sqlBuilder.append(" VIRTUAL ");
                }
            }
            if (Objects.nonNull(column.getAutoIncrement())) {
                sqlBuilder.append(column.getAutoIncrement() != false ? " AUTO_INCREMENT " : "");
            }
        }
    }

    protected static class CollationModifier
    implements DBTableColumnEditor.DBColumnModifier {
        protected CollationModifier() {
        }

        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            if (DataTypeUtil.isStringType(column.getTypeName()) && StringUtils.isNotBlank((CharSequence)column.getCollationName())) {
                sqlBuilder.append(" COLLATE ").append(column.getCollationName());
            }
        }
    }

    protected static class CharsetModifier
    implements DBTableColumnEditor.DBColumnModifier {
        protected CharsetModifier() {
        }

        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            if (DataTypeUtil.isStringType(column.getTypeName()) && StringUtils.isNotBlank((CharSequence)column.getCharsetName())) {
                sqlBuilder.append(" CHARACTER SET ").append(column.getCharsetName());
            }
        }
    }
}

