/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model;

import com.oceanbase.tools.dbbrowser.model.DBBasicPLObject;
import com.oceanbase.tools.dbbrowser.model.DBObject;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBRoutineCharacteristic;
import java.sql.Timestamp;
import lombok.NonNull;

public class DBFunction
extends DBBasicPLObject
implements DBObject {
    private String packageName;
    private String funName;
    private String ddl;
    private String definer;
    private String status;
    private Timestamp createTime;
    private Timestamp modifyTime;
    private String returnType;
    private String returnValue;
    private String errorMessage;
    private boolean returnExtendedType;
    private DBRoutineCharacteristic characteristic;

    public static DBFunction of(@NonNull String funName, @NonNull String returnType) {
        if (funName == null) {
            throw new NullPointerException("funName is marked non-null but is null");
        }
        if (returnType == null) {
            throw new NullPointerException("returnType is marked non-null but is null");
        }
        DBFunction function = new DBFunction();
        function.funName = funName;
        function.returnType = returnType;
        return function;
    }

    @Override
    public String name() {
        return this.funName;
    }

    @Override
    public DBObjectType type() {
        return DBObjectType.FUNCTION;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getFunName() {
        return this.funName;
    }

    public String getDdl() {
        return this.ddl;
    }

    public String getDefiner() {
        return this.definer;
    }

    public String getStatus() {
        return this.status;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public Timestamp getModifyTime() {
        return this.modifyTime;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isReturnExtendedType() {
        return this.returnExtendedType;
    }

    public DBRoutineCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setFunName(String funName) {
        this.funName = funName;
    }

    public void setDdl(String ddl) {
        this.ddl = ddl;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Timestamp modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setReturnValue(String returnValue) {
        this.returnValue = returnValue;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setReturnExtendedType(boolean returnExtendedType) {
        this.returnExtendedType = returnExtendedType;
    }

    public void setCharacteristic(DBRoutineCharacteristic characteristic) {
        this.characteristic = characteristic;
    }

    @Override
    public String toString() {
        return "DBFunction(packageName=" + this.getPackageName() + ", funName=" + this.getFunName() + ", ddl=" + this.getDdl() + ", definer=" + this.getDefiner() + ", status=" + this.getStatus() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", returnType=" + this.getReturnType() + ", returnValue=" + this.getReturnValue() + ", errorMessage=" + this.getErrorMessage() + ", returnExtendedType=" + this.isReturnExtendedType() + ", characteristic=" + this.getCharacteristic() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBFunction)) {
            return false;
        }
        DBFunction other = (DBFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$funName = this.getFunName();
        String other$funName = other.getFunName();
        if (this$funName == null ? other$funName != null : !this$funName.equals(other$funName)) {
            return false;
        }
        String this$ddl = this.getDdl();
        String other$ddl = other.getDdl();
        if (this$ddl == null ? other$ddl != null : !this$ddl.equals(other$ddl)) {
            return false;
        }
        String this$definer = this.getDefiner();
        String other$definer = other.getDefiner();
        if (this$definer == null ? other$definer != null : !this$definer.equals(other$definer)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Timestamp this$createTime = this.getCreateTime();
        Timestamp other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Timestamp this$modifyTime = this.getModifyTime();
        Timestamp other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        String this$returnType = this.getReturnType();
        String other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        String this$returnValue = this.getReturnValue();
        String other$returnValue = other.getReturnValue();
        if (this$returnValue == null ? other$returnValue != null : !this$returnValue.equals(other$returnValue)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        if (this.isReturnExtendedType() != other.isReturnExtendedType()) {
            return false;
        }
        DBRoutineCharacteristic this$characteristic = this.getCharacteristic();
        DBRoutineCharacteristic other$characteristic = other.getCharacteristic();
        return !(this$characteristic == null ? other$characteristic != null : !((Object)this$characteristic).equals(other$characteristic));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DBFunction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $funName = this.getFunName();
        result = result * 59 + ($funName == null ? 43 : $funName.hashCode());
        String $ddl = this.getDdl();
        result = result * 59 + ($ddl == null ? 43 : $ddl.hashCode());
        String $definer = this.getDefiner();
        result = result * 59 + ($definer == null ? 43 : $definer.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Timestamp $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Timestamp $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        String $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        String $returnValue = this.getReturnValue();
        result = result * 59 + ($returnValue == null ? 43 : $returnValue.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        result = result * 59 + (this.isReturnExtendedType() ? 79 : 97);
        DBRoutineCharacteristic $characteristic = this.getCharacteristic();
        result = result * 59 + ($characteristic == null ? 43 : ((Object)$characteristic).hashCode());
        return result;
    }
}

