/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser;

import java.util.Objects;
import lombok.NonNull;

class CacheElement<T> {
    private final T value;
    private final Exception exception;
    private final StackTraceElement[] traceElements;

    public CacheElement(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.exception = null;
        this.value = value;
        this.traceElements = null;
    }

    public CacheElement(@NonNull Exception exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        this.value = null;
        this.exception = exception;
        this.traceElements = this.getRealStackTraceElements(exception);
    }

    public synchronized T get() {
        if (this.exception != null) {
            Exception target = this.setStackTraceElements(this.exception);
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new RuntimeException(target);
        }
        return this.value;
    }

    private StackTraceElement[] getRealStackTraceElements(Exception e) {
        int i;
        StackTraceElement elt = Thread.currentThread().getStackTrace()[3];
        for (i = 0; i < e.getStackTrace().length; ++i) {
            StackTraceElement item = e.getStackTrace()[i];
            if (!Objects.equals(item.getClassName(), elt.getClassName()) || !Objects.equals(item.getMethodName(), elt.getMethodName())) continue;
            ++i;
            break;
        }
        StackTraceElement[] target = new StackTraceElement[i];
        System.arraycopy(e.getStackTrace(), 0, target, 0, i);
        return target;
    }

    private Exception setStackTraceElements(Exception e) {
        StackTraceElement[] elts = Thread.currentThread().getStackTrace();
        int length = this.traceElements.length;
        StackTraceElement[] target = new StackTraceElement[length + elts.length - 4];
        System.arraycopy(this.traceElements, 0, target, 0, length);
        System.arraycopy(elts, 4, target, length, elts.length - 4);
        e.setStackTrace(target);
        return e;
    }
}

