/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser;

import com.oceanbase.tools.dbbrowser.parser.PLParser;
import com.oceanbase.tools.dbbrowser.parser.SqlParser;
import com.oceanbase.tools.dbbrowser.parser.constant.GeneralSqlType;
import com.oceanbase.tools.dbbrowser.parser.constant.SqlType;
import com.oceanbase.tools.dbbrowser.parser.result.BasicResult;
import com.oceanbase.tools.sqlparser.SyntaxErrorException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserUtil {
    private static final Logger log = LoggerFactory.getLogger(ParserUtil.class);
    private static final int DEFAULT_PREFIX_SIZE = 200;

    public static GeneralSqlType getGeneralSqlType(BasicResult result) {
        if (Objects.isNull((Object)result.getSqlType())) {
            return GeneralSqlType.OTHER;
        }
        switch (result.getSqlType()) {
            case INSERT: 
            case UPDATE: 
            case DELETE: 
            case SORT: 
            case REPLACE: {
                return GeneralSqlType.DML;
            }
            case SELECT: 
            case SHOW: 
            case EXPLAIN: {
                return GeneralSqlType.DQL;
            }
            case CREATE: 
            case DROP: 
            case TRUNCATE: 
            case ALTER: 
            case COMMENT_ON: {
                return GeneralSqlType.DDL;
            }
        }
        return GeneralSqlType.OTHER;
    }

    public static boolean isSelectType(SqlType type) {
        return SqlType.SELECT == type;
    }

    public static BasicResult parseMysqlType(String sql) {
        return ParserUtil.parseMysqlType(sql, 0L);
    }

    public static BasicResult parseMysqlType(String sql, long timeoutMillis) {
        Boolean isPLSqlSyntaxError;
        Boolean isSqlSyntaxError;
        BasicResult result;
        block7: {
            block6: {
                result = null;
                isSqlSyntaxError = false;
                isPLSqlSyntaxError = false;
                try {
                    result = SqlParser.parseMysql(sql, timeoutMillis);
                    result.setSyntaxError(false);
                    if (Objects.nonNull((Object)result.getSqlType())) {
                        return result;
                    }
                }
                catch (Exception e) {
                    log.debug("Parse mysql type by SqlParser failed, sql={}, errorMessage={}", (Object)sql, (Object)ParserUtil.prefix(e.getMessage()));
                    if (!(e instanceof SyntaxErrorException)) break block6;
                    isSqlSyntaxError = true;
                }
            }
            try {
                result = PLParser.parseObMysql(sql, timeoutMillis);
            }
            catch (Exception e) {
                log.debug("Parse mysql type by PLParser failed, sql={}, errorMessage={}", (Object)sql, (Object)ParserUtil.prefix(e.getMessage()));
                if (!(e instanceof SyntaxErrorException)) break block7;
                isPLSqlSyntaxError = true;
            }
        }
        if (Objects.nonNull(result) && Objects.nonNull((Object)result.getSqlType())) {
            result.setSyntaxError(isSqlSyntaxError != false && isPLSqlSyntaxError != false);
            return result;
        }
        BasicResult basicResult = new BasicResult(SqlType.UNKNOWN);
        basicResult.setSyntaxError(isSqlSyntaxError != false && isPLSqlSyntaxError != false);
        return basicResult;
    }

    public static BasicResult parseOracleType(String sql) {
        return ParserUtil.parseOracleType(sql, 0L);
    }

    public static BasicResult parseOracleType(String sql, long timeoutMillis) {
        Boolean isPLSqlSyntaxError;
        Boolean isSqlSyntaxError;
        BasicResult result;
        block7: {
            block6: {
                result = null;
                isSqlSyntaxError = false;
                isPLSqlSyntaxError = false;
                try {
                    result = SqlParser.parseOracle(sql, timeoutMillis);
                    result.setSyntaxError(false);
                    if (Objects.nonNull((Object)result.getSqlType())) {
                        return result;
                    }
                }
                catch (Exception e) {
                    log.debug("Parse oracle type by SqlParser failed, sql={}, errorMessage={}", (Object)sql, (Object)ParserUtil.prefix(e.getMessage()));
                    if (!(e instanceof SyntaxErrorException)) break block6;
                    isSqlSyntaxError = true;
                }
            }
            try {
                result = PLParser.parseObOracle(sql, timeoutMillis);
            }
            catch (Exception e) {
                log.debug("Parse oracle type by PLParser failed, sql={}, errorMessage={}", (Object)sql, (Object)ParserUtil.prefix(e.getMessage()));
                if (!(e instanceof SyntaxErrorException)) break block7;
                isPLSqlSyntaxError = true;
            }
        }
        if (Objects.nonNull(result) && Objects.nonNull((Object)result.getSqlType())) {
            result.setSyntaxError(isSqlSyntaxError != false && isPLSqlSyntaxError != false);
            return result;
        }
        BasicResult basicResult = new BasicResult(SqlType.UNKNOWN);
        basicResult.setSyntaxError(isSqlSyntaxError != false && isPLSqlSyntaxError != false);
        return basicResult;
    }

    private static String prefix(String content) {
        if (Objects.isNull(content)) {
            return null;
        }
        return StringUtils.substring((String)content, (int)0, (int)200);
    }
}

