/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser.listener;

import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBPLParam;
import com.oceanbase.tools.dbbrowser.model.DBPLParamMode;
import com.oceanbase.tools.dbbrowser.model.DBPLType;
import com.oceanbase.tools.dbbrowser.model.DBPLVariable;
import com.oceanbase.tools.dbbrowser.parser.constant.SqlType;
import com.oceanbase.tools.dbbrowser.parser.listener.BasicParserListener;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import com.oceanbase.tools.sqlparser.obmysql.PLParser;
import com.oceanbase.tools.sqlparser.obmysql.PLParserBaseListener;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class MysqlModePLParserListener
extends PLParserBaseListener
implements BasicParserListener {
    private List<DBPLParam> paramList = new ArrayList<DBPLParam>();
    private List<DBPLVariable> varibaleList = new ArrayList<DBPLVariable>();
    private List<DBPLType> typeList = new ArrayList<DBPLType>();
    private String returnType;
    private String plName;
    private String plType;
    private SqlType sqlType;
    private DBObjectType dbObjectType;
    private List<String> dbObjectNameList = new ArrayList<String>();

    public boolean isEmpty() {
        return this.paramList.isEmpty() && this.varibaleList.isEmpty() && this.typeList.isEmpty() && StringUtils.isEmpty((CharSequence)this.returnType) && StringUtils.isEmpty((CharSequence)this.plName) && StringUtils.isEmpty((CharSequence)this.plType);
    }

    public void enterSp_name(PLParser.Sp_nameContext ctx) {
        this.plName = ctx.getText();
        List children = ctx.getParent().children;
        for (int i = 0; i < children.size(); ++i) {
            if (!((ParseTree)children.get(i)).getText().equalsIgnoreCase(this.plName)) continue;
            this.plType = ((ParseTree)children.get(i - 1)).getText();
            break;
        }
    }

    public void enterCreate_procedure_stmt(PLParser.Create_procedure_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.PROCEDURE;
        this.dbObjectNameList.add(ctx.sp_name().getText());
        for (int j = 0; j < ctx.getChildCount(); ++j) {
            if (!(ctx.getChild(j) instanceof PLParser.Sp_param_listContext)) continue;
            PLParser.Sp_param_listContext paramlist = (PLParser.Sp_param_listContext)ctx.getChild(j);
            if (paramlist == null) break;
            int count = paramlist.getChildCount();
            int paramCount = 0;
            for (int i = 0; i < count; ++i) {
                if (!(paramlist.getChild(i) instanceof PLParser.Sp_paramContext)) continue;
                PLParser.Sp_paramContext paramContext = (PLParser.Sp_paramContext)paramlist.getChild(i);
                DBPLParam plParam = new DBPLParam();
                String paramName = paramContext.ident().getText();
                plParam.setParamName(StringUtils.unquoteMySqlIdentifier(paramName));
                plParam.setSeqNum(++paramCount);
                plParam.setDataType(paramContext.param_type().getText());
                if (paramContext.IN() != null) {
                    plParam.setParamMode(DBPLParamMode.IN);
                } else if (paramContext.OUT() != null) {
                    plParam.setParamMode(DBPLParamMode.OUT);
                } else if (paramContext.INOUT() != null) {
                    plParam.setParamMode(DBPLParamMode.INOUT);
                }
                this.paramList.add(plParam);
            }
            break;
        }
    }

    public void enterDrop_procedure_stmt(PLParser.Drop_procedure_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.PROCEDURE;
        this.dbObjectNameList.add(ctx.sp_name().getText());
    }

    public void enterCreate_function_stmt(PLParser.Create_function_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.FUNCTION;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (!ctx.getChild(i).getText().equalsIgnoreCase("returns")) continue;
            this.returnType = ctx.getChild(i + 1).getText();
            break;
        }
        for (int j = 0; j < ctx.getChildCount(); ++j) {
            if (!(ctx.getChild(j) instanceof PLParser.Sp_fparam_listContext)) continue;
            PLParser.Sp_fparam_listContext paramlist = (PLParser.Sp_fparam_listContext)ctx.getChild(j);
            int count = paramlist.getChildCount();
            int paramCount = 0;
            for (int i = 0; i < count; ++i) {
                if (!(paramlist.getChild(i) instanceof PLParser.Sp_fparamContext)) continue;
                PLParser.Sp_fparamContext paramContext = (PLParser.Sp_fparamContext)paramlist.getChild(i);
                DBPLParam plParam = new DBPLParam();
                String paramName = paramContext.ident().getText();
                plParam.setParamName(StringUtils.unquoteMySqlIdentifier(paramName));
                plParam.setSeqNum(++paramCount);
                plParam.setDataType(paramContext.param_type().getText());
                plParam.setParamMode(DBPLParamMode.IN);
                this.paramList.add(plParam);
            }
            break;
        }
    }

    public void enterSp_decl(PLParser.Sp_declContext ctx) {
        String var = ctx.getChild(1).getText();
        String type = ctx.getChild(2).getText();
        DBPLVariable varibale = new DBPLVariable();
        varibale.setVarName(var);
        varibale.setVarType(type);
        this.varibaleList.add(varibale);
    }

    public void enterCall_sp_stmt(PLParser.Call_sp_stmtContext ctx) {
        this.sqlType = SqlType.CALL;
        this.dbObjectType = DBObjectType.PROCEDURE;
    }

    public List<DBPLParam> getParamList() {
        return this.paramList;
    }

    public List<DBPLVariable> getVaribaleList() {
        return this.varibaleList;
    }

    public List<DBPLType> getTypeList() {
        return this.typeList;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getPlName() {
        return this.plName;
    }

    public String getPlType() {
        return this.plType;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Override
    public DBObjectType getDbObjectType() {
        return this.dbObjectType;
    }

    @Override
    public List<String> getDbObjectNameList() {
        return this.dbObjectNameList;
    }
}

