/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser.listener;

import com.oceanbase.tools.dbbrowser.model.DBColumnGroupElement;
import com.oceanbase.tools.dbbrowser.model.DBConstraintType;
import com.oceanbase.tools.dbbrowser.model.DBIndex;
import com.oceanbase.tools.dbbrowser.model.DBIndexRangeType;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.parser.constant.SqlType;
import com.oceanbase.tools.dbbrowser.parser.listener.BasicParserListener;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLTableElementFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseListener;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineForeignConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineIndex;
import com.oceanbase.tools.sqlparser.statement.createtable.TableElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class MysqlModeSqlParserListener
extends OBParserBaseListener
implements BasicParserListener {
    private boolean selectStmt;
    private boolean withForUpdate;
    private boolean limitClause;
    private SqlType sqlType;
    private DBObjectType dbObjectType;
    private boolean setStmt = false;
    private List<String> dbObjectNameList = new ArrayList<String>();
    private List<DBIndex> indexes = new ArrayList<DBIndex>();
    private List<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
    private List<DBTableConstraint> foreignConstraint = new ArrayList<DBTableConstraint>();

    private void setSqlType(SqlType newType) {
        if (Objects.isNull((Object)this.sqlType) || SqlType.OTHERS == this.sqlType) {
            this.sqlType = newType;
        }
    }

    private void setDbObjectType(@NonNull DBObjectType objectType) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (this.dbObjectType == null) {
            this.dbObjectType = objectType;
        } else if (!this.dbObjectType.equals((Object)objectType)) {
            this.dbObjectType = DBObjectType.OTHERS;
        }
    }

    public void enterSelect_stmt(OBParser.Select_stmtContext ctx) {
        this.setSqlType(SqlType.SELECT);
        if (ctx.getParent() instanceof OBParser.StmtContext) {
            this.selectStmt = true;
        }
    }

    public void enterOpt_for_update_wait(OBParser.Opt_for_update_waitContext ctx) {
        this.withForUpdate = true;
    }

    public void enterLimit_clause(OBParser.Limit_clauseContext ctx) {
        this.limitClause = true;
    }

    public void enterSelect_clause_set_with_order_and_limit(OBParser.Select_clause_set_with_order_and_limitContext ctx) {
    }

    public void enterNo_table_select_with_order_and_limit(OBParser.No_table_select_with_order_and_limitContext ctx) {
    }

    public void enterSimple_select_with_order_and_limit(OBParser.Simple_select_with_order_and_limitContext ctx) {
    }

    public void enterSelect_with_parens_with_order_and_limit(OBParser.Select_with_parens_with_order_and_limitContext ctx) {
    }

    public void enterDelete_stmt(OBParser.Delete_stmtContext ctx) {
        this.setSqlType(SqlType.DELETE);
    }

    public void enterInsert_stmt(OBParser.Insert_stmtContext ctx) {
        this.setSqlType(SqlType.INSERT);
    }

    public void enterVariable_set_stmt(OBParser.Variable_set_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
        this.setStmt = true;
    }

    public void exitVariable_set_stmt(OBParser.Variable_set_stmtContext ctx) {
        this.setStmt = false;
    }

    public void enterVar_and_val(OBParser.Var_and_valContext ctx) {
        if (!this.setStmt) {
            return;
        }
        ParseTree parseTree = ctx.getChild(0);
        if (!(parseTree instanceof TerminalNode)) {
            return;
        }
        Token variableToken = ((TerminalNode)parseTree).getSymbol();
        if (variableToken.getType() == 1183) {
            this.setDbObjectType(DBObjectType.USER_VARIABLE);
        } else if (variableToken.getType() == 1182) {
            this.setDbObjectType(DBObjectType.SYSTEM_VARIABLE);
        }
    }

    public void enterSys_var_and_val(OBParser.Sys_var_and_valContext ctx) {
        if (!this.setStmt) {
            return;
        }
        this.setDbObjectType(DBObjectType.SYSTEM_VARIABLE);
    }

    public void enterScope_or_scope_alias(OBParser.Scope_or_scope_aliasContext ctx) {
        if (!this.setStmt) {
            return;
        }
        ParseTree parseTree = ctx.getChild(0);
        if (!(parseTree instanceof TerminalNode)) {
            return;
        }
        Token scopeToken = ((TerminalNode)parseTree).getSymbol();
        if (scopeToken.getType() == 655 || scopeToken.getType() == 355) {
            this.setDbObjectType(DBObjectType.GLOBAL_VARIABLE);
        } else if (scopeToken.getType() == 1070 || scopeToken.getType() == 356) {
            this.sqlType = SqlType.SET_SESSION;
            this.setDbObjectType(DBObjectType.SESSION_VARIABLE);
        }
    }

    public void enterSet_password_stmt(OBParser.Set_password_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
    }

    public void enterSet_names_stmt(OBParser.Set_names_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
    }

    public void enterSet_charset_stmt(OBParser.Set_charset_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
    }

    public void enterCommit_stmt(OBParser.Commit_stmtContext ctx) {
        this.setSqlType(SqlType.COMMIT);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterRollback_stmt(OBParser.Rollback_stmtContext ctx) {
        this.setSqlType(SqlType.ROLLBACK);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterSet_transaction_stmt(OBParser.Set_transaction_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
    }

    public void enterUpdate_stmt(OBParser.Update_stmtContext ctx) {
        this.setSqlType(SqlType.UPDATE);
    }

    public void enterExplain_stmt(OBParser.Explain_stmtContext ctx) {
        if (ctx.explain_or_desc().EXPLAIN() != null) {
            this.setSqlType(SqlType.EXPLAIN);
        } else {
            this.setSqlType(SqlType.DESC);
        }
    }

    public void enterUse_database_stmt(OBParser.Use_database_stmtContext ctx) {
        this.setSqlType(SqlType.USE_DB);
    }

    public void enterHelp_stmt(OBParser.Help_stmtContext ctx) {
        this.setSqlType(SqlType.HELP);
    }

    public void enterShow_stmt(OBParser.Show_stmtContext ctx) {
        this.setSqlType(SqlType.SHOW);
    }

    public void enterDrop_database_stmt(OBParser.Drop_database_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.DATABASE;
        this.dbObjectNameList.add(ctx.database_factor().getText());
    }

    public void enterDrop_table_stmt(OBParser.Drop_table_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.TABLE;
        for (OBParser.Relation_factorContext relation_factorContext : ctx.table_list().relation_factor()) {
            this.dbObjectNameList.add(relation_factorContext.getText());
        }
    }

    public void enterDrop_view_stmt(OBParser.Drop_view_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.VIEW;
        for (OBParser.Relation_factorContext relation_factorContext : ctx.table_list().relation_factor()) {
            this.dbObjectNameList.add(relation_factorContext.getText());
        }
    }

    public void enterDrop_function_stmt(OBParser.Drop_function_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.FUNCTION;
        this.dbObjectNameList.add(ctx.relation_factor().getText());
    }

    public void enterDrop_procedure_stmt(OBParser.Drop_procedure_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.PROCEDURE;
        this.dbObjectNameList.add(ctx.relation_factor().getText());
    }

    public void enterDrop_trigger_stmt(OBParser.Drop_trigger_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.TRIGGER;
        this.dbObjectNameList.add(ctx.relation_factor().getText());
    }

    public void enterDrop_outline_stmt(OBParser.Drop_outline_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(ctx.relation_factor().getText());
    }

    public void enterDrop_user_stmt(OBParser.Drop_user_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        for (OBParser.User_with_host_nameContext user_with_host_nameContext : ctx.user_list().user_with_host_name()) {
            this.dbObjectNameList.add(user_with_host_nameContext.user().getText());
        }
    }

    public void enterDrop_index_stmt(OBParser.Drop_index_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(ctx.relation_name().getText());
    }

    public void enterDrop_tenant_stmt(OBParser.Drop_tenant_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(ctx.relation_name().getText());
    }

    public void enterDrop_resource_stmt(OBParser.Drop_resource_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(ctx.relation_name().getText());
    }

    public void enterDrop_tablegroup_stmt(OBParser.Drop_tablegroup_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(ctx.relation_name().getText());
    }

    public void enterDrop_tablespace_stmt(OBParser.Drop_tablespace_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(ctx.tablespace().getText());
    }

    public void enterCreate_database_stmt(OBParser.Create_database_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.DATABASE;
        this.dbObjectNameList.add(ctx.database_factor().getText());
    }

    public void enterCreate_table_stmt(OBParser.Create_table_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.TABLE;
        this.dbObjectNameList.add(ctx.relation_factor().getText());
        for (OBParser.Table_elementContext element : ctx.table_element_list().table_element()) {
            if (!Objects.nonNull(element.column_definition())) continue;
            this.columns.add(ColumnDefinition.builder().name(this.handleObjectName(element.column_definition().column_definition_ref().column_name().getText())).isStored(Objects.nonNull(element.column_definition().STORED())).build());
        }
    }

    public void enterCreate_view_stmt(OBParser.Create_view_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.VIEW;
        this.dbObjectNameList.add(ctx.view_name().getText());
    }

    public void enterCreate_function_stmt(OBParser.Create_function_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.FUNCTION;
        this.dbObjectNameList.add(ctx.NAME_OB().getText());
    }

    public void enterTruncate_table_stmt(OBParser.Truncate_table_stmtContext ctx) {
        this.setSqlType(SqlType.TRUNCATE);
        this.dbObjectType = DBObjectType.TABLE;
    }

    public void enterAlter_database_stmt(OBParser.Alter_database_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.DATABASE;
    }

    public void enterAlter_outline_stmt(OBParser.Alter_outline_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_table_stmt(OBParser.Alter_table_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.TABLE;
        this.dbObjectNameList.add(ctx.relation_factor().getText());
    }

    public void enterAlter_system_stmt(OBParser.Alter_system_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_tablespace_stmt(OBParser.Alter_tablespace_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_tenant_stmt(OBParser.Alter_tenant_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_resource_stmt(OBParser.Alter_resource_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_tablegroup_stmt(OBParser.Alter_tablegroup_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_cluster_stmt(OBParser.Alter_cluster_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterEveryRule(ParserRuleContext ctx) {
        if (Objects.isNull((Object)this.sqlType)) {
            this.setSqlType(SqlType.OTHERS);
        }
    }

    public void enterTable_element(OBParser.Table_elementContext ctx) {
        MySQLTableElementFactory factory = new MySQLTableElementFactory(ctx);
        TableElement elt = (TableElement)factory.generate();
        if (elt instanceof OutOfLineIndex) {
            OutOfLineIndex outOfLineIndex = (OutOfLineIndex)elt;
            DBIndex index = new DBIndex();
            index.setName(this.handleObjectName(outOfLineIndex.getIndexName()));
            index.setRange(DBIndexRangeType.GLOBAL);
            if (outOfLineIndex.getIndexOptions() != null && outOfLineIndex.getIndexOptions().getGlobal() != null && !outOfLineIndex.getIndexOptions().getGlobal().booleanValue()) {
                index.setRange(DBIndexRangeType.LOCAL);
            }
            if (outOfLineIndex.getColumnGroupElements() != null) {
                index.setColumnGroups(outOfLineIndex.getColumnGroupElements().stream().map(DBColumnGroupElement::ofColumnGroupElement).collect(Collectors.toList()));
            }
            this.indexes.add(index);
        } else if (elt instanceof OutOfLineConstraint) {
            OutOfLineConstraint outOfLineConstraint = (OutOfLineConstraint)elt;
            if (outOfLineConstraint.isUniqueKey()) {
                DBIndex index = new DBIndex();
                index.setName(this.handleObjectName(outOfLineConstraint.getIndexName()));
                index.setRange(DBIndexRangeType.GLOBAL);
                if (outOfLineConstraint.getState() != null && outOfLineConstraint.getState().getIndexOptions() != null && outOfLineConstraint.getState().getIndexOptions().getGlobal() != null && !outOfLineConstraint.getState().getIndexOptions().getGlobal().booleanValue()) {
                    index.setRange(DBIndexRangeType.LOCAL);
                }
                if (outOfLineConstraint.getColumnGroupElements() != null) {
                    index.setColumnGroups(outOfLineConstraint.getColumnGroupElements().stream().map(DBColumnGroupElement::ofColumnGroupElement).collect(Collectors.toList()));
                }
                this.indexes.add(index);
            } else if (elt instanceof OutOfLineForeignConstraint) {
                OutOfLineForeignConstraint foreign = (OutOfLineForeignConstraint)elt;
                DBTableConstraint constraint = new DBTableConstraint();
                constraint.setType(DBConstraintType.FOREIGN_KEY);
                constraint.setReferenceTableName(this.handleObjectName(foreign.getReference().getRelation()));
                constraint.setReferenceSchemaName(this.handleObjectName(foreign.getReference().getSchema()));
                this.foreignConstraint.add(constraint);
            }
        }
    }

    private String handleObjectName(String name) {
        return StringUtils.unquoteMySqlIdentifier(name);
    }

    public boolean isSelectStmt() {
        return this.selectStmt;
    }

    public boolean isWithForUpdate() {
        return this.withForUpdate;
    }

    public boolean isLimitClause() {
        return this.limitClause;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Override
    public DBObjectType getDbObjectType() {
        return this.dbObjectType;
    }

    public boolean isSetStmt() {
        return this.setStmt;
    }

    @Override
    public List<String> getDbObjectNameList() {
        return this.dbObjectNameList;
    }

    public List<DBIndex> getIndexes() {
        return this.indexes;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public List<DBTableConstraint> getForeignConstraint() {
        return this.foreignConstraint;
    }

    public static class ColumnDefinition {
        private String name;
        private Boolean isStored;

        ColumnDefinition(String name, Boolean isStored) {
            this.name = name;
            this.isStored = isStored;
        }

        public static ColumnDefinitionBuilder builder() {
            return new ColumnDefinitionBuilder();
        }

        public String getName() {
            return this.name;
        }

        public Boolean getIsStored() {
            return this.isStored;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIsStored(Boolean isStored) {
            this.isStored = isStored;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnDefinition)) {
                return false;
            }
            ColumnDefinition other = (ColumnDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Boolean this$isStored = this.getIsStored();
            Boolean other$isStored = other.getIsStored();
            return !(this$isStored == null ? other$isStored != null : !((Object)this$isStored).equals(other$isStored));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColumnDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Boolean $isStored = this.getIsStored();
            result = result * 59 + ($isStored == null ? 43 : ((Object)$isStored).hashCode());
            return result;
        }

        public String toString() {
            return "MysqlModeSqlParserListener.ColumnDefinition(name=" + this.getName() + ", isStored=" + this.getIsStored() + ")";
        }

        public static class ColumnDefinitionBuilder {
            private String name;
            private Boolean isStored;

            ColumnDefinitionBuilder() {
            }

            public ColumnDefinitionBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ColumnDefinitionBuilder isStored(Boolean isStored) {
                this.isStored = isStored;
                return this;
            }

            public ColumnDefinition build() {
                return new ColumnDefinition(this.name, this.isStored);
            }

            public String toString() {
                return "MysqlModeSqlParserListener.ColumnDefinition.ColumnDefinitionBuilder(name=" + this.name + ", isStored=" + this.isStored + ")";
            }
        }
    }
}

