/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser.listener;

import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBPLParam;
import com.oceanbase.tools.dbbrowser.model.DBPLParamMode;
import com.oceanbase.tools.dbbrowser.model.DBPLType;
import com.oceanbase.tools.dbbrowser.model.DBPLVariable;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.parser.constant.PLObjectType;
import com.oceanbase.tools.dbbrowser.parser.constant.SqlType;
import com.oceanbase.tools.dbbrowser.parser.listener.BasicParserListener;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import com.oceanbase.tools.sqlparser.oboracle.PLParser;
import com.oceanbase.tools.sqlparser.oboracle.PLParserBaseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleModePLParserListener
extends PLParserBaseListener
implements BasicParserListener {
    private List<DBPLVariable> varibaleList = new ArrayList<DBPLVariable>();
    private List<DBPLType> typeList = new ArrayList<DBPLType>();
    private String returnType;
    private List<DBProcedure> procedureList = new ArrayList<DBProcedure>();
    private List<DBFunction> functionList = new ArrayList<DBFunction>();
    private List<DBPLType> cursorList = new ArrayList<DBPLType>();
    private String plName;
    private String plType;
    private String isOrAs;
    private SqlType sqlType;
    private DBObjectType dbObjectType;
    private List<String> dbObjectNameList = new ArrayList<String>();

    public boolean isEmpty() {
        return this.varibaleList.isEmpty() && this.typeList.isEmpty() && this.procedureList.isEmpty() && this.functionList.isEmpty() && this.cursorList.isEmpty() && StringUtils.isEmpty((CharSequence)this.returnType) && StringUtils.isEmpty((CharSequence)this.plName) && StringUtils.isEmpty((CharSequence)this.plType);
    }

    public void enterAnonymous_stmt(PLParser.Anonymous_stmtContext ctx) {
        this.plType = DBObjectType.ANONYMOUS_BLOCK.getName();
        this.sqlType = SqlType.OTHERS;
    }

    public void enterPl_schema_name(PLParser.Pl_schema_nameContext ctx) {
        if (this.plName == null) {
            String plName = ctx.getText();
            this.plName = this.handleObjectName(plName);
            List children = ctx.getParent().children;
            for (int i = 1; i < children.size(); ++i) {
                if (!((ParseTree)children.get(i)).getText().equalsIgnoreCase(plName)) continue;
                this.plType = ((ParseTree)children.get(i - 1)).getText();
                if (!"body".equalsIgnoreCase(this.plType)) break;
                this.plType = DBObjectType.PACKAGE_BODY.getName();
                break;
            }
        }
    }

    public void enterPackage_block(PLParser.Package_blockContext ctx) {
        PLParser.Is_or_asContext isOrAs = ctx.is_or_as();
        if (isOrAs != null) {
            this.isOrAs = isOrAs.getText();
        }
    }

    public void enterPlsql_procedure_source(PLParser.Plsql_procedure_sourceContext ctx) {
        for (int j = 0; j < ctx.getChildCount(); ++j) {
            if (!(ctx.getChild(j) instanceof PLParser.Sp_param_listContext)) continue;
            ArrayList<DBPLParam> plParamList = new ArrayList<DBPLParam>();
            PLParser.Sp_param_listContext paramlist = (PLParser.Sp_param_listContext)ctx.getChild(j);
            if (paramlist != null) {
                int count = paramlist.getChildCount();
                int paramCount = 0;
                for (int i = 0; i < count; ++i) {
                    if (!(paramlist.getChild(i) instanceof PLParser.Sp_paramContext)) continue;
                    PLParser.Sp_paramContext paramContext = (PLParser.Sp_paramContext)paramlist.getChild(i);
                    DBPLParam plParam = new DBPLParam();
                    String paramName = paramContext.param_name().getText();
                    plParam.setParamName(StringUtils.unquoteOracleIdentifier(paramName));
                    plParam.setSeqNum(++paramCount);
                    plParam.setDataType(paramContext.pl_outer_data_type().getText());
                    PLParser.Default_optContext defaultExpr = paramContext.default_opt();
                    if (defaultExpr != null) {
                        PLParser.Default_exprContext boolExprContext = (PLParser.Default_exprContext)defaultExpr.getChild(1);
                        String defValue = boolExprContext.getText().replace("<EOF>", "");
                        plParam.setDefaultValue(defValue);
                    }
                    int cnt = paramContext.getChildCount();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int k = 1; k < cnt && !(paramContext.getChild(k) instanceof PLParser.Pl_outer_data_typeContext); ++k) {
                        stringBuilder.append(paramContext.getChild(k).getText()).append(" ");
                    }
                    String modeStr = stringBuilder.toString().trim();
                    DBPLParamMode mode = StringUtils.isBlank((CharSequence)modeStr) ? DBPLParamMode.IN : DBPLParamMode.getEnum(modeStr);
                    plParam.setParamMode(mode);
                    plParamList.add(plParam);
                }
            }
            String proName = ctx.pl_schema_name().getText();
            String proNameWithoutQuotation = this.handleObjectName(proName);
            DBProcedure dbProcedure = new DBProcedure();
            dbProcedure.setProName(this.handleUpperCase(proName, proNameWithoutQuotation));
            dbProcedure.setParams(plParamList);
            this.procedureList.add(dbProcedure);
            break;
        }
    }

    public void enterPlsql_function_source(PLParser.Plsql_function_sourceContext ctx) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (!ctx.getChild(i).getText().equalsIgnoreCase("return")) continue;
            this.returnType = ctx.getChild(i + 1).getText();
        }
        for (int j = 0; j < ctx.getChildCount(); ++j) {
            if (!(ctx.getChild(j) instanceof PLParser.Sp_param_listContext)) continue;
            PLParser.Sp_param_listContext paramlist = (PLParser.Sp_param_listContext)ctx.getChild(j);
            ArrayList<DBPLParam> plParamList = new ArrayList<DBPLParam>();
            if (paramlist != null) {
                int count = paramlist.getChildCount();
                int paramCount = 0;
                for (int i = 0; i < count; ++i) {
                    if (!(paramlist.getChild(i) instanceof PLParser.Sp_paramContext)) continue;
                    PLParser.Sp_paramContext paramContext = (PLParser.Sp_paramContext)paramlist.getChild(i);
                    DBPLParam plParam = new DBPLParam();
                    String paramName = paramContext.param_name().getText();
                    plParam.setParamName(StringUtils.unquoteOracleIdentifier(paramName));
                    plParam.setSeqNum(++paramCount);
                    plParam.setDataType(paramContext.pl_outer_data_type().getText());
                    PLParser.Default_optContext defaultExpr = paramContext.default_opt();
                    if (defaultExpr != null) {
                        PLParser.Default_exprContext boolExprContext = (PLParser.Default_exprContext)defaultExpr.getChild(1);
                        String defValue = boolExprContext.getText().replace("<EOF>", "");
                        plParam.setDefaultValue(defValue);
                    }
                    int cnt = paramContext.getChildCount();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int k = 1; k < cnt && !(paramContext.getChild(k) instanceof PLParser.Pl_outer_data_typeContext); ++k) {
                        stringBuilder.append(paramContext.getChild(k).getText()).append(" ");
                    }
                    String modeStr = stringBuilder.toString().trim();
                    DBPLParamMode mode = StringUtils.isBlank((CharSequence)modeStr) ? DBPLParamMode.IN : DBPLParamMode.getEnum(modeStr);
                    plParam.setParamMode(mode);
                    plParamList.add(plParam);
                }
            }
            String funName = ctx.pl_schema_name(0).getText();
            String funNameWithoutQuotation = this.handleObjectName(funName);
            DBFunction dbFunction = new DBFunction();
            dbFunction.setFunName(this.handleUpperCase(funName, funNameWithoutQuotation));
            dbFunction.setParams(plParamList);
            dbFunction.setReturnType(ctx.pl_outer_data_type().getText());
            this.functionList.add(dbFunction);
            break;
        }
    }

    public void enterVar_decl(PLParser.Var_declContext ctx) {
        DBPLVariable variable = this.generatePLVariable(ctx);
        this.varibaleList.add(variable);
    }

    private DBPLVariable generatePLVariable(PLParser.Var_declContext ctx) {
        String var = ctx.var_common_name().getText();
        String type = ctx.pl_inner_data_type().getText();
        DBPLVariable variable = new DBPLVariable();
        variable.setVarName(this.handleObjectName(var));
        variable.setVarType(type);
        return variable;
    }

    public void enterFunc_decl(PLParser.Func_declContext ctx) {
        ArrayList<DBPLParam> plParamList = new ArrayList<DBPLParam>();
        PLParser.Sp_param_listContext paramlist = ctx.sp_param_list();
        if (paramlist != null) {
            int count = paramlist.getChildCount();
            int paramCount = 0;
            for (int i = 0; i < count; ++i) {
                if (!(paramlist.getChild(i) instanceof PLParser.Sp_paramContext)) continue;
                PLParser.Sp_paramContext paramContext = (PLParser.Sp_paramContext)paramlist.getChild(i);
                DBPLParam plParam = new DBPLParam();
                String paramName = paramContext.param_name().getText();
                plParam.setParamName(StringUtils.unquoteOracleIdentifier(paramName));
                plParam.setSeqNum(++paramCount);
                plParam.setDataType(paramContext.pl_outer_data_type().getText());
                int cnt = paramContext.getChildCount();
                StringBuilder stringBuilder = new StringBuilder();
                for (int k = 1; k < cnt && !(paramContext.getChild(k) instanceof PLParser.Pl_outer_data_typeContext); ++k) {
                    stringBuilder.append(paramContext.getChild(k).getText()).append(" ");
                }
                String modeStr = stringBuilder.toString().trim();
                DBPLParamMode mode = StringUtils.isBlank((CharSequence)modeStr) ? DBPLParamMode.IN : DBPLParamMode.getEnum(modeStr);
                plParam.setParamMode(mode);
                plParamList.add(plParam);
            }
        }
        String funName = ctx.func_name().getText();
        String funNameWithoutQuotation = this.handleObjectName(funName);
        DBFunction dbFunction = new DBFunction();
        dbFunction.setFunName(this.handleUpperCase(funName, funNameWithoutQuotation));
        dbFunction.setParams(plParamList);
        dbFunction.setReturnType(ctx.pl_outer_data_type().getText());
        dbFunction.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.functionList.add(dbFunction);
    }

    public void enterProc_decl(PLParser.Proc_declContext ctx) {
        ArrayList<DBPLParam> plParamList = new ArrayList<DBPLParam>();
        PLParser.Sp_param_listContext paramlist = ctx.sp_param_list();
        if (paramlist != null) {
            int count = paramlist.getChildCount();
            int paramCount = 0;
            for (int i = 0; i < count; ++i) {
                if (!(paramlist.getChild(i) instanceof PLParser.Sp_paramContext)) continue;
                PLParser.Sp_paramContext paramContext = (PLParser.Sp_paramContext)paramlist.getChild(i);
                DBPLParam plParam = new DBPLParam();
                String paramName = paramContext.param_name().getText();
                plParam.setParamName(StringUtils.unquoteOracleIdentifier(paramName));
                plParam.setSeqNum(++paramCount);
                plParam.setDataType(paramContext.pl_outer_data_type().getText());
                int cnt = paramContext.getChildCount();
                StringBuilder stringBuilder = new StringBuilder();
                for (int k = 1; k < cnt && !(paramContext.getChild(k) instanceof PLParser.Pl_outer_data_typeContext); ++k) {
                    stringBuilder.append(paramContext.getChild(k).getText()).append(" ");
                }
                String modeStr = stringBuilder.toString().trim();
                DBPLParamMode mode = StringUtils.isBlank((CharSequence)modeStr) ? DBPLParamMode.IN : DBPLParamMode.getEnum(modeStr);
                plParam.setParamMode(mode);
                plParamList.add(plParam);
            }
        }
        String proName = ctx.proc_name().getText();
        String proNameWithoutQuotation = this.handleObjectName(proName);
        DBProcedure dbProcedure = new DBProcedure();
        dbProcedure.setProName(this.handleUpperCase(proName, proNameWithoutQuotation));
        dbProcedure.setParams(plParamList);
        dbProcedure.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.procedureList.add(dbProcedure);
    }

    public void enterCursor_decl(PLParser.Cursor_declContext ctx) {
        DBPLType cursor = new DBPLType();
        cursor.setTypeName(ctx.cursor_name().getText());
        cursor.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.cursorList.add(cursor);
    }

    public void enterRef_cursor_type_def(PLParser.Ref_cursor_type_defContext ctx) {
        String typeVar = ctx.type_name().identifier().getText();
        String typeName = PLObjectType.CURSOR_TYPE.name();
        DBPLType plType = new DBPLType();
        plType.setTypeVariable(this.handleObjectName(typeVar));
        plType.setTypeName(typeName);
        this.typeList.add(plType);
    }

    public void enterRecord_type_def(PLParser.Record_type_defContext ctx) {
        String typeVar = ctx.type_name().identifier().getText();
        String typeName = PLObjectType.RECORD_TYPE.name();
        DBPLType plType = new DBPLType();
        plType.setTypeVariable(this.handleObjectName(typeVar));
        plType.setTypeName(typeName);
        this.typeList.add(plType);
    }

    public void enterObject_type_def(PLParser.Object_type_defContext ctx) {
        for (PLParser.Attr_specContext attr_specContext : ctx.attr_and_element_spec().attr_list().attr_spec()) {
            String varName = attr_specContext.common_identifier().getText();
            String type = attr_specContext.pl_inner_data_type().getText();
            DBPLVariable variable = new DBPLVariable();
            variable.setVarName(this.handleObjectName(varName));
            variable.setVarType(type);
            this.varibaleList.add(variable);
        }
    }

    private String handleObjectName(String name) {
        return StringUtils.unquoteOracleIdentifier(name);
    }

    private String handleUpperCase(String originalName, String name) {
        if (originalName.equals(name)) {
            return name.toUpperCase();
        }
        return name;
    }

    public void enterDrop_procedure_stmt(PLParser.Drop_procedure_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.PROCEDURE;
        for (PLParser.IdentifierContext identifierContext : ctx.pl_schema_name().identifier()) {
            this.dbObjectNameList.add(this.handleObjectName(identifierContext.getText()));
        }
    }

    public void enterCreate_procedure_stmt(PLParser.Create_procedure_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.PROCEDURE;
        List identifierContexts = ctx.plsql_procedure_source().pl_schema_name().identifier();
        for (PLParser.IdentifierContext identifierContext : identifierContexts) {
            this.dbObjectNameList.add(this.handleUpperCaseObjectName(identifierContext.getText()));
        }
    }

    public void enterCreate_package_stmt(PLParser.Create_package_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.PACKAGE;
        List identifierContexts = ctx.package_block().pl_schema_name().identifier();
        for (PLParser.IdentifierContext identifierContext : identifierContexts) {
            this.dbObjectNameList.add(this.handleUpperCaseObjectName(identifierContext.getText()));
        }
    }

    public void enterCreate_package_body_stmt(PLParser.Create_package_body_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.PACKAGE_BODY;
        List identifierContexts = ctx.package_body_block().pl_schema_name().identifier();
        for (PLParser.IdentifierContext identifierContext : identifierContexts) {
            this.dbObjectNameList.add(this.handleUpperCaseObjectName(identifierContext.getText()));
        }
    }

    public void enterCreate_function_stmt(PLParser.Create_function_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.FUNCTION;
        for (PLParser.Pl_schema_nameContext pl_schema_nameContext : ctx.plsql_function_source().pl_schema_name()) {
            for (PLParser.IdentifierContext identifierContext : pl_schema_nameContext.identifier()) {
                this.dbObjectNameList.add(this.handleUpperCaseObjectName(identifierContext.getText()));
            }
        }
    }

    public void enterDrop_function_stmt(PLParser.Drop_function_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.FUNCTION;
        this.dbObjectNameList.add(this.handleObjectName(ctx.pl_schema_name().getText()));
    }

    public void enterDrop_trigger_stmt(PLParser.Drop_trigger_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.TRIGGER;
        this.dbObjectNameList.add(this.handleObjectName(ctx.pl_schema_name().getText()));
    }

    public void enterCreate_trigger_stmt(PLParser.Create_trigger_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.TRIGGER;
        for (PLParser.IdentifierContext identifierContext : ctx.plsql_trigger_source().pl_schema_name().identifier()) {
            this.dbObjectNameList.add(this.handleUpperCaseObjectName(identifierContext.getText()));
        }
    }

    public void enterCreate_type_stmt(PLParser.Create_type_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.TYPE;
        this.dbObjectNameList.add(this.handleObjectName(ctx.plsql_type_spec_source().pl_schema_name().getText()));
    }

    public void enterDrop_type_stmt(PLParser.Drop_type_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.TYPE;
        this.dbObjectNameList.add(this.handleObjectName(ctx.pl_schema_name(0).getText()));
    }

    public void enterDrop_package_stmt(PLParser.Drop_package_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.PACKAGE;
        this.dbObjectNameList.add(this.handleObjectName(ctx.pl_schema_name().getText()));
    }

    private String handleUpperCaseObjectName(String objectName) {
        String proNameWithoutQuotation = this.handleObjectName(objectName);
        return this.handleUpperCase(objectName, proNameWithoutQuotation);
    }

    public void enterAlter_procedure_stmt(PLParser.Alter_procedure_stmtContext ctx) {
        this.sqlType = SqlType.ALTER;
        this.dbObjectType = DBObjectType.PROCEDURE;
        List identifierContexts = ctx.pl_schema_name().identifier();
        for (PLParser.IdentifierContext identifierContext : identifierContexts) {
            this.dbObjectNameList.add(this.handleUpperCaseObjectName(identifierContext.getText()));
        }
    }

    public void enterAlter_function_stmt(PLParser.Alter_function_stmtContext ctx) {
        this.sqlType = SqlType.ALTER;
        this.dbObjectType = DBObjectType.FUNCTION;
        List identifierContexts = ctx.pl_schema_name().identifier();
        for (PLParser.IdentifierContext identifierContext : identifierContexts) {
            this.dbObjectNameList.add(this.handleUpperCaseObjectName(identifierContext.getText()));
        }
    }

    public void enterAlter_package_stmt(PLParser.Alter_package_stmtContext ctx) {
        this.sqlType = SqlType.ALTER;
        this.dbObjectType = Objects.nonNull(ctx.alter_package_clause().BODY()) ? DBObjectType.PACKAGE_BODY : DBObjectType.PACKAGE;
        List identifierContexts = ctx.pl_schema_name().identifier();
        for (PLParser.IdentifierContext identifierContext : identifierContexts) {
            this.dbObjectNameList.add(this.handleUpperCaseObjectName(identifierContext.getText()));
        }
    }

    public void enterCall_spec(PLParser.Call_specContext ctx) {
        this.sqlType = SqlType.CALL;
        this.dbObjectType = DBObjectType.PROCEDURE;
    }

    private String getDdl(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        CharStream stream = start.getTokenSource().getInputStream();
        return stream.getText(Interval.of((int)start.getStartIndex(), (int)stop.getStopIndex()));
    }

    public List<DBPLVariable> getVaribaleList() {
        return this.varibaleList;
    }

    public List<DBPLType> getTypeList() {
        return this.typeList;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public List<DBProcedure> getProcedureList() {
        return this.procedureList;
    }

    public List<DBFunction> getFunctionList() {
        return this.functionList;
    }

    public List<DBPLType> getCursorList() {
        return this.cursorList;
    }

    public String getPlName() {
        return this.plName;
    }

    public String getPlType() {
        return this.plType;
    }

    public String getIsOrAs() {
        return this.isOrAs;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Override
    public DBObjectType getDbObjectType() {
        return this.dbObjectType;
    }

    @Override
    public List<String> getDbObjectNameList() {
        return this.dbObjectNameList;
    }
}

