/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser.listener;

import com.oceanbase.tools.dbbrowser.model.DBColumnGroupElement;
import com.oceanbase.tools.dbbrowser.model.DBConstraintType;
import com.oceanbase.tools.dbbrowser.model.DBIndex;
import com.oceanbase.tools.dbbrowser.model.DBIndexRangeType;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.parser.constant.SqlType;
import com.oceanbase.tools.dbbrowser.parser.listener.BasicParserListener;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleColumnGroupElementFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class OracleModeSqlParserListener
extends OBParserBaseListener
implements BasicParserListener {
    private boolean selectStmt;
    private boolean withForUpdate;
    private boolean fetchNext;
    private boolean whereClause;
    private boolean setStmt = false;
    private SqlType sqlType;
    private DBObjectType dbObjectType;
    private List<String> dbObjectNameList = new ArrayList<String>();
    private List<DBIndex> indexes = new ArrayList<DBIndex>();
    private List<DBTableConstraint> foreignConstraint = new ArrayList<DBTableConstraint>();

    private void setSqlType(SqlType newType) {
        if (Objects.isNull((Object)this.sqlType) || SqlType.OTHERS == this.sqlType) {
            this.sqlType = newType;
        }
    }

    private void setDbObjectType(@NonNull DBObjectType objectType) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (this.dbObjectType == null) {
            this.dbObjectType = objectType;
        } else if (!this.dbObjectType.equals((Object)objectType)) {
            this.dbObjectType = DBObjectType.OTHERS;
        }
    }

    public void enterSelect_stmt(OBParser.Select_stmtContext ctx) {
        this.setSqlType(SqlType.SELECT);
        if (ctx.getParent() instanceof OBParser.StmtContext) {
            this.selectStmt = true;
        }
    }

    public void enterFor_update(OBParser.For_updateContext ctx) {
        this.withForUpdate = true;
    }

    public void enterFetch_next_clause(OBParser.Fetch_next_clauseContext ctx) {
        this.fetchNext = true;
    }

    public void enterSimple_select(OBParser.Simple_selectContext ctx) {
        if (Objects.nonNull(ctx.WHERE())) {
            this.whereClause = true;
        }
    }

    public void enterSelect_with_hierarchical_query(OBParser.Select_with_hierarchical_queryContext ctx) {
        if (Objects.nonNull(ctx.WHERE())) {
            this.whereClause = true;
        }
    }

    public void enterDrop_package_stmt(OBParser.Drop_package_stmtContext ctx) {
        this.dbObjectType = Objects.nonNull(ctx.BODY()) ? DBObjectType.PACKAGE_BODY : DBObjectType.PACKAGE;
        this.sqlType = SqlType.DROP;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterDrop_procedure_stmt(OBParser.Drop_procedure_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.PROCEDURE;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterDrop_function_stmt(OBParser.Drop_function_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.FUNCTION;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterDrop_trigger_stmt(OBParser.Drop_trigger_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.TRIGGER;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterDrop_type_stmt(OBParser.Drop_type_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.TYPE;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterDelete_stmt(OBParser.Delete_stmtContext ctx) {
        this.setSqlType(SqlType.DELETE);
    }

    public void enterInsert_stmt(OBParser.Insert_stmtContext ctx) {
        this.setSqlType(SqlType.INSERT);
    }

    public void enterVariable_set_stmt(OBParser.Variable_set_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
        this.setStmt = true;
    }

    public void exitVariable_set_stmt(OBParser.Variable_set_stmtContext ctx) {
        this.setStmt = false;
    }

    public void enterVar_and_val(OBParser.Var_and_valContext ctx) {
        if (!this.setStmt) {
            return;
        }
        ParseTree parseTree = ctx.getChild(0);
        if (!(parseTree instanceof TerminalNode)) {
            return;
        }
        Token variableToken = ((TerminalNode)parseTree).getSymbol();
        if (variableToken.getType() == 1296) {
            this.setDbObjectType(DBObjectType.USER_VARIABLE);
        } else if (variableToken.getType() == 1295) {
            this.setDbObjectType(DBObjectType.SYSTEM_VARIABLE);
        }
    }

    public void enterSys_var_and_val(OBParser.Sys_var_and_valContext ctx) {
        if (!this.setStmt) {
            return;
        }
        this.setDbObjectType(DBObjectType.SYSTEM_VARIABLE);
    }

    public void enterScope_or_scope_alias(OBParser.Scope_or_scope_aliasContext ctx) {
        if (!this.setStmt) {
            return;
        }
        ParseTree parseTree = ctx.getChild(0);
        if (!(parseTree instanceof TerminalNode)) {
            return;
        }
        Token scopeToken = ((TerminalNode)parseTree).getSymbol();
        if (scopeToken.getType() == 717 || scopeToken.getType() == 389) {
            this.setDbObjectType(DBObjectType.GLOBAL_VARIABLE);
        } else if (scopeToken.getType() == 175 || scopeToken.getType() == 390) {
            this.sqlType = SqlType.SET_SESSION;
            this.setDbObjectType(DBObjectType.SESSION_VARIABLE);
        }
    }

    public void enterSet_password_stmt(OBParser.Set_password_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
    }

    public void enterSet_names_stmt(OBParser.Set_names_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
    }

    public void enterSet_charset_stmt(OBParser.Set_charset_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
    }

    public void enterSet_transaction_stmt(OBParser.Set_transaction_stmtContext ctx) {
        this.setSqlType(SqlType.SET);
    }

    public void enterUpdate_stmt(OBParser.Update_stmtContext ctx) {
        this.setSqlType(SqlType.UPDATE);
    }

    public void enterExplain_stmt(OBParser.Explain_stmtContext ctx) {
        if (ctx.explain_or_desc().EXPLAIN() != null) {
            this.setSqlType(SqlType.EXPLAIN);
        } else {
            this.setSqlType(SqlType.DESC);
        }
    }

    public void enterHelp_stmt(OBParser.Help_stmtContext ctx) {
        this.setSqlType(SqlType.HELP);
    }

    public void enterShow_stmt(OBParser.Show_stmtContext ctx) {
        this.setSqlType(SqlType.SHOW);
    }

    public void enterDrop_table_stmt(OBParser.Drop_table_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.TABLE;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterDrop_view_stmt(OBParser.Drop_view_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.VIEW;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterDrop_outline_stmt(OBParser.Drop_outline_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterDrop_user_stmt(OBParser.Drop_user_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        for (OBParser.User_with_host_nameContext user_with_host_nameContext : ctx.user_list().user_with_host_name()) {
            this.dbObjectNameList.add(this.handleObjectName(user_with_host_nameContext.user().getText()));
        }
    }

    public void enterDrop_index_stmt(OBParser.Drop_index_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        for (OBParser.Relation_nameContext relation_nameContext : ctx.relation_name()) {
            this.dbObjectNameList.add(this.handleObjectName(relation_nameContext.getText()));
        }
    }

    public void enterDrop_tenant_stmt(OBParser.Drop_tenant_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_name().getText()));
    }

    public void enterDrop_resource_stmt(OBParser.Drop_resource_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_name().getText()));
    }

    public void enterDrop_tablegroup_stmt(OBParser.Drop_tablegroup_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_name().getText()));
    }

    public void enterDrop_synonym_stmt(OBParser.Drop_synonym_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.SYNONYM;
        this.dbObjectNameList.add(this.handleObjectName(ctx.synonym_name().getText()));
    }

    public void enterDrop_tablespace_stmt(OBParser.Drop_tablespace_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(this.handleObjectName(ctx.tablespace().getText()));
    }

    public void enterDrop_sequence_stmt(OBParser.Drop_sequence_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.SEQUENCE;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterDrop_dblink_stmt(OBParser.Drop_dblink_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(this.handleObjectName(ctx.dblink().getText()));
    }

    public void enterDrop_role_stmt(OBParser.Drop_role_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(this.handleObjectName(ctx.role().getText()));
    }

    public void enterDrop_profile_stmt(OBParser.Drop_profile_stmtContext ctx) {
        this.sqlType = SqlType.DROP;
        this.dbObjectType = DBObjectType.OTHERS;
        this.dbObjectNameList.add(this.handleObjectName(ctx.profile_name().getText()));
    }

    public void enterCreate_table_stmt(OBParser.Create_table_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.TABLE;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterCreate_view_stmt(OBParser.Create_view_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.VIEW;
        this.dbObjectNameList.add(this.handleObjectName(ctx.view_name().getText()));
    }

    public void enterCreate_sequence_stmt(OBParser.Create_sequence_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.SEQUENCE;
        this.dbObjectNameList.add(this.handleObjectName(ctx.relation_factor().getText()));
    }

    public void enterCreate_user_stmt(OBParser.Create_user_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.USER;
    }

    public void enterCreate_index_stmt(OBParser.Create_index_stmtContext ctx) {
        this.sqlType = SqlType.CREATE;
        this.dbObjectType = DBObjectType.INDEX;
        DBIndex index = new DBIndex();
        if (Objects.nonNull(ctx.normal_relation_factor().database_factor())) {
            index.setDatabaseName(this.handleObjectName(ctx.normal_relation_factor().database_factor().getText()));
        }
        if (Objects.nonNull(ctx.normal_relation_factor().relation_name())) {
            index.setName(this.handleObjectName(ctx.normal_relation_factor().relation_name().getText()));
        }
        index.setRange(DBIndexRangeType.GLOBAL);
        if (Objects.nonNull(ctx.opt_index_options())) {
            for (OBParser.Index_optionContext index_optionContext : ctx.opt_index_options().index_option()) {
                if (!Objects.nonNull(index_optionContext.LOCAL())) continue;
                index.setRange(DBIndexRangeType.LOCAL);
                break;
            }
        }
        if (Objects.nonNull(ctx.with_column_group())) {
            List<DBColumnGroupElement> columnGroups = ctx.with_column_group().column_group_list().column_group_element().stream().map(c -> DBColumnGroupElement.ofColumnGroupElement(new OracleColumnGroupElementFactory(c).generate())).collect(Collectors.toList());
            index.setColumnGroups(columnGroups);
        }
        this.indexes.add(index);
    }

    public void enterTruncate_table_stmt(OBParser.Truncate_table_stmtContext ctx) {
        this.setSqlType(SqlType.TRUNCATE);
        this.dbObjectType = DBObjectType.TABLE;
    }

    public void enterOut_of_line_constraint(OBParser.Out_of_line_constraintContext ctx) {
        OBParser.Column_name_listContext column_name_listContext;
        OBParser.Relation_nameContext relation_nameContext;
        OBParser.References_clauseContext references_clauseContext = ctx.references_clause();
        if (references_clauseContext == null) {
            return;
        }
        OBParser.Normal_relation_factorContext normal_relation_factorContext = references_clauseContext.normal_relation_factor();
        OBParser.Database_factorContext database_factorContext = normal_relation_factorContext.database_factor();
        DBTableConstraint constraint = new DBTableConstraint();
        constraint.setType(DBConstraintType.FOREIGN_KEY);
        if (database_factorContext != null) {
            constraint.setReferenceSchemaName(this.handleObjectName(database_factorContext.getText()));
        }
        if ((relation_nameContext = normal_relation_factorContext.relation_name()) != null) {
            constraint.setReferenceTableName(this.handleObjectName(relation_nameContext.getText()));
        }
        if ((column_name_listContext = references_clauseContext.column_name_list()) != null) {
            List column_nameContexts = column_name_listContext.column_name();
            constraint.setReferenceColumnNames(column_nameContexts.stream().map(c -> this.handleObjectName(c.getText())).collect(Collectors.toList()));
        }
        this.foreignConstraint.add(constraint);
    }

    public void enterAlter_database_stmt(OBParser.Alter_database_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.DATABASE;
    }

    public void enterAlter_outline_stmt(OBParser.Alter_outline_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_table_stmt(OBParser.Alter_table_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.TABLE;
    }

    public void enterAlter_index_stmt(OBParser.Alter_index_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_system_stmt(OBParser.Alter_system_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_user_stmt(OBParser.Alter_user_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_user_profile_stmt(OBParser.Alter_user_profile_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_tenant_stmt(OBParser.Alter_tenant_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_resource_stmt(OBParser.Alter_resource_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_tablegroup_stmt(OBParser.Alter_tablegroup_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_keystore_stmt(OBParser.Alter_keystore_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_sequence_stmt(OBParser.Alter_sequence_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.SEQUENCE;
    }

    public void enterAlter_session_stmt(OBParser.Alter_session_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER_SESSION);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterAlter_profile_stmt(OBParser.Alter_profile_stmtContext ctx) {
        this.setSqlType(SqlType.ALTER);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterEveryRule(ParserRuleContext ctx) {
        if (Objects.isNull((Object)this.sqlType)) {
            this.setSqlType(SqlType.OTHERS);
        }
    }

    private String handleObjectName(String name) {
        return StringUtils.unquoteOracleIdentifier(name);
    }

    public void enterCreate_synonym_stmt(OBParser.Create_synonym_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.SYNONYM;
    }

    public void enterCreate_outline_stmt(OBParser.Create_outline_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCreate_tenant_stmt(OBParser.Create_tenant_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCreate_resource_stmt(OBParser.Create_resource_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCreate_tablegroup_stmt(OBParser.Create_tablegroup_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCreate_tablespace_stmt(OBParser.Create_tablespace_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCreate_keystore_stmt(OBParser.Create_keystore_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCreate_savepoint_stmt(OBParser.Create_savepoint_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCreate_dblink_stmt(OBParser.Create_dblink_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCreate_role_stmt(OBParser.Create_role_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCreate_profile_stmt(OBParser.Create_profile_stmtContext ctx) {
        this.setSqlType(SqlType.CREATE);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCommit_stmt(OBParser.Commit_stmtContext ctx) {
        this.setSqlType(SqlType.COMMIT);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterRollback_stmt(OBParser.Rollback_stmtContext ctx) {
        this.setSqlType(SqlType.ROLLBACK);
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterSet_comment_stmt(OBParser.Set_comment_stmtContext ctx) {
        this.setSqlType(SqlType.COMMENT_ON);
        if (ctx.TABLE() != null) {
            this.dbObjectType = DBObjectType.TABLE;
            return;
        }
        if (ctx.COLUMN() != null) {
            this.dbObjectType = DBObjectType.COLUMN;
            return;
        }
        this.dbObjectType = DBObjectType.OTHERS;
    }

    public void enterCall_stmt(OBParser.Call_stmtContext ctx) {
        this.setSqlType(SqlType.CALL);
        this.dbObjectType = DBObjectType.PROCEDURE;
    }

    public boolean isSelectStmt() {
        return this.selectStmt;
    }

    public boolean isWithForUpdate() {
        return this.withForUpdate;
    }

    public boolean isFetchNext() {
        return this.fetchNext;
    }

    public boolean isWhereClause() {
        return this.whereClause;
    }

    public boolean isSetStmt() {
        return this.setStmt;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Override
    public DBObjectType getDbObjectType() {
        return this.dbObjectType;
    }

    @Override
    public List<String> getDbObjectNameList() {
        return this.dbObjectNameList;
    }

    public List<DBIndex> getIndexes() {
        return this.indexes;
    }

    public List<DBTableConstraint> getForeignConstraint() {
        return this.foreignConstraint;
    }
}

