/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.mysql;

import com.oceanbase.tools.dbbrowser.model.DBColumnTypeDisplay;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMapper;
import com.oceanbase.tools.dbbrowser.schema.mysql.OBMySQLBetween2277And3XSchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public abstract class BaseOBMySQLLessThan2277SchemaAccessor
extends OBMySQLBetween2277And3XSchemaAccessor {
    public BaseOBMySQLLessThan2277SchemaAccessor(JdbcOperations jdbcOperations, DBSchemaAccessorSqlMapper sqlMapper) {
        super(jdbcOperations);
        this.sqlMapper = sqlMapper;
    }

    protected RowMapper listTableRowMapper() {
        return (rs, romNum) -> {
            DBColumnTypeDisplay columnTypeDisplay;
            DBTableColumn tableColumn = new DBTableColumn();
            tableColumn.setSchemaName(rs.getString("TABLE_SCHEMA"));
            tableColumn.setTableName(rs.getString("TABLE_NAME"));
            tableColumn.setName(rs.getString("COLUMN_NAME"));
            tableColumn.setTypeName(rs.getString("DATA_TYPE"));
            String fullTypeName = rs.getString("COLUMN_TYPE");
            tableColumn.setFullTypeName(fullTypeName);
            if (StringUtils.isNotBlank((CharSequence)tableColumn.getTypeName()) && (this.isTypeEnum(tableColumn.getTypeName()) || this.isTypeSet(tableColumn.getTypeName()))) {
                tableColumn.setEnumValues(DBSchemaAccessorUtil.parseEnumValues(fullTypeName));
            }
            if ((columnTypeDisplay = DBColumnTypeDisplay.fromName(tableColumn.getTypeName())).displayScale()) {
                tableColumn.setScale(rs.getInt("NUMERIC_SCALE"));
            }
            if (columnTypeDisplay.displayPrecision()) {
                if (Objects.nonNull(rs.getObject("NUMERIC_SCALE"))) {
                    tableColumn.setPrecision(rs.getLong("NUMERIC_PRECISION"));
                } else if (Objects.nonNull(rs.getObject("DATETIME_PRECISION"))) {
                    tableColumn.setPrecision(rs.getLong("DATETIME_PRECISION"));
                } else {
                    tableColumn.setPrecision(rs.getLong("CHARACTER_MAXIMUM_LENGTH"));
                }
            }
            tableColumn.setExtraInfo(rs.getString("EXTRA"));
            Long maxLength = rs.getLong("CHARACTER_MAXIMUM_LENGTH");
            if (Objects.isNull(maxLength)) {
                tableColumn.setMaxLength(rs.getLong("NUMERIC_PRECISION"));
            } else {
                tableColumn.setMaxLength(maxLength);
            }
            tableColumn.setCharsetName(rs.getString("CHARACTER_SET_NAME"));
            tableColumn.setCollationName(rs.getString("COLLATION_NAME"));
            tableColumn.setComment(rs.getString("COLUMN_COMMENT"));
            tableColumn.fillDefaultValue(rs.getString("COLUMN_DEFAULT"));
            tableColumn.setNullable("YES".equalsIgnoreCase(rs.getString("IS_NULLABLE")));
            tableColumn.setVirtual(StringUtils.isNotEmpty((CharSequence)tableColumn.getGenExpression()));
            tableColumn.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
            String keyTypeName = rs.getString("COLUMN_KEY");
            if (StringUtils.isNotBlank((CharSequence)keyTypeName)) {
                tableColumn.setKeyType(DBTableColumn.KeyType.valueOf(keyTypeName));
            }
            tableColumn.setTypeModifiers(new ArrayList<String>());
            tableColumn.setZerofill(false);
            tableColumn.setUnsigned(false);
            String[] stringArray = fullTypeName.toLowerCase().split("\\s+");
            int n = stringArray.length;
            block8: for (int i = 0; i < n; ++i) {
                String modifier;
                switch (modifier = stringArray[i]) {
                    case "zerofill": {
                        tableColumn.setZerofill(true);
                        tableColumn.getTypeModifiers().add("zerofill");
                        continue block8;
                    }
                    case "unsigned": {
                        tableColumn.setUnsigned(true);
                        tableColumn.getTypeModifiers().add("unsigned");
                    }
                }
            }
            if (Objects.nonNull(tableColumn.getExtraInfo())) {
                tableColumn.setAutoIncrement(tableColumn.getExtraInfo().equalsIgnoreCase("auto_increment"));
                tableColumn.setOnUpdateCurrentTimestamp(tableColumn.getExtraInfo().equalsIgnoreCase("on update current_timestamp"));
                tableColumn.setStored(tableColumn.getExtraInfo().equalsIgnoreCase("stored generated"));
            }
            return tableColumn;
        };
    }

    @Override
    protected String getListTableColumnsSql(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select TABLE_NAME, TABLE_SCHEMA, ORDINAL_POSITION, COLUMN_NAME, DATA_TYPE, COLUMN_TYPE, NUMERIC_SCALE, NUMERIC_PRECISION, DATETIME_PRECISION, CHARACTER_MAXIMUM_LENGTH, EXTRA, CHARACTER_SET_NAME, COLLATION_NAME, COLUMN_COMMENT, COLUMN_DEFAULT, IS_NULLABLE, COLUMN_KEY from information_schema.columns where TABLE_SCHEMA = ");
        sb.value(schemaName);
        sb.append(" ORDER BY TABLE_NAME, ORDINAL_POSITION");
        return sb.toString();
    }
}

