/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.mysql;

import com.oceanbase.tools.dbbrowser.model.DBColumnGroupElement;
import com.oceanbase.tools.dbbrowser.model.DBColumnTypeDisplay;
import com.oceanbase.tools.dbbrowser.model.DBConstraintType;
import com.oceanbase.tools.dbbrowser.model.DBDatabase;
import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBIndexAlgorithm;
import com.oceanbase.tools.dbbrowser.model.DBIndexType;
import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBPLObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBPackage;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.model.DBSequence;
import com.oceanbase.tools.dbbrowser.model.DBSynonym;
import com.oceanbase.tools.dbbrowser.model.DBSynonymType;
import com.oceanbase.tools.dbbrowser.model.DBTable;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.model.DBTableSubpartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTrigger;
import com.oceanbase.tools.dbbrowser.model.DBType;
import com.oceanbase.tools.dbbrowser.model.DBVariable;
import com.oceanbase.tools.dbbrowser.model.DBView;
import com.oceanbase.tools.dbbrowser.parser.PLParser;
import com.oceanbase.tools.dbbrowser.parser.SqlParser;
import com.oceanbase.tools.dbbrowser.parser.result.ParseMysqlPLResult;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMapper;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMappers;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import com.oceanbase.tools.sqlparser.statement.Statement;
import com.oceanbase.tools.sqlparser.statement.createtable.CreateTable;
import com.oceanbase.tools.sqlparser.statement.createtable.TableOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class MySQLNoLessThan5700SchemaAccessor
implements DBSchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(MySQLNoLessThan5700SchemaAccessor.class);
    protected JdbcOperations jdbcOperations;
    protected DBSchemaAccessorSqlMapper sqlMapper;
    private static final Set<String> SPECIAL_TYPE_NAMES = new HashSet<String>();

    public MySQLNoLessThan5700SchemaAccessor(@org.springframework.lang.NonNull JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
        this.sqlMapper = DBSchemaAccessorSqlMappers.get("schema/sql/mysql/mysql_5_7_x.yaml");
    }

    @Override
    public List<String> showDatabases() {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SHOW DATABASES");
        return this.jdbcOperations.queryForList(sb.toString(), String.class);
    }

    @Override
    public DBDatabase getDatabase(String schemaName) {
        DBDatabase database = new DBDatabase();
        database.setId(schemaName);
        database.setName(schemaName);
        String sql = "SELECT DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME FROM information_schema.schemata WHERE SCHEMA_NAME ='" + schemaName + "'";
        this.jdbcOperations.query(sql, rs -> {
            database.setCharset(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
            database.setCollation(rs.getString("DEFAULT_COLLATION_NAME"));
        });
        return database;
    }

    @Override
    public List<DBDatabase> listDatabases() {
        Set grantedDatabases = this.showDatabases().stream().collect(Collectors.toSet());
        String sql = "SELECT SCHEMA_NAME, DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME FROM information_schema.schemata;";
        List allDatabases = this.jdbcOperations.query(sql, (rs, num) -> {
            DBDatabase database = new DBDatabase();
            database.setId(rs.getString("SCHEMA_NAME"));
            database.setName(rs.getString("SCHEMA_NAME"));
            database.setCharset(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
            database.setCollation(rs.getString("DEFAULT_COLLATION_NAME"));
            return database;
        });
        return allDatabases.stream().filter(db -> grantedDatabases.contains(db.getName())).collect(Collectors.toList());
    }

    @Override
    public void switchDatabase(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("use ");
        sb.identifier(schemaName);
        this.jdbcOperations.execute(sb.toString());
    }

    @Override
    public List<DBObjectIdentity> listUsers() {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SELECT DISTINCT user FROM mysql.user");
        return this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> {
            DBObjectIdentity dbUser = new DBObjectIdentity();
            dbUser.setName(rs.getString(1));
            dbUser.setType(DBObjectType.USER);
            return dbUser;
        });
    }

    @Override
    public List<String> showTables(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SHOW FULL TABLES ");
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            sb.append("FROM ");
            sb.identifier(schemaName);
        }
        ArrayList<String> tableNames = new ArrayList();
        sb.append(" WHERE table_type='BASE TABLE'");
        try {
            tableNames = this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> rs.getString(1));
        }
        catch (BadSqlGrammarException e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Unknown database")) {
                return Collections.emptyList();
            }
            throw e;
        }
        return tableNames;
    }

    @Override
    public List<String> showTablesLike(String schemaName, String tableNameLike) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SELECT table_name FROM information_schema.tables WHERE table_type='BASE TABLE'");
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            sb.append(" AND table_schema=");
            sb.value(schemaName);
        }
        if (StringUtils.isNotBlank((CharSequence)tableNameLike)) {
            sb.append(" AND table_name LIKE ");
            sb.value(tableNameLike);
        }
        sb.append(" ORDER BY table_name");
        return this.jdbcOperations.queryForList(sb.toString(), String.class);
    }

    @Override
    public List<DBObjectIdentity> listTables(String schemaName, String tableNameLike) {
        return this.listBaseTables(schemaName, tableNameLike);
    }

    @Override
    public List<String> showExternalTables(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<String> showExternalTablesLike(String schemaName, String tableNameLike) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBObjectIdentity> listExternalTables(String schemaName, String tableNameLike) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public boolean isExternalTable(String schemaName, String tableName) {
        return false;
    }

    @Override
    public boolean syncExternalTableFiles(String schemaName, String tableName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    protected List<DBObjectIdentity> listBaseTables(String schemaName, String tableNameLike) throws DataAccessException {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select table_schema as schema_name, 'TABLE' as type, table_name as name ");
        sb.append("from information_schema.tables where table_type = 'BASE TABLE'");
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            sb.append(" AND table_schema=");
            sb.value(schemaName);
        }
        if (StringUtils.isNotBlank((CharSequence)tableNameLike)) {
            sb.append(" AND table_name LIKE ");
            sb.value(tableNameLike);
        }
        sb.append(" ORDER BY schema_name, table_name");
        return this.jdbcOperations.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(DBObjectIdentity.class));
    }

    @Override
    public List<DBObjectIdentity> listViews(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("show full tables from ");
        sb.identifier(schemaName);
        sb.append(" where Table_type like '%VIEW%'");
        return this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> DBObjectIdentity.of(schemaName, DBObjectType.VIEW, rs.getString(1)));
    }

    @Override
    public List<DBObjectIdentity> listAllViews(String viewNameLike) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select TABLE_SCHEMA as schema_name,TABLE_NAME as name, 'VIEW' as type from information_schema.views where TABLE_NAME LIKE ").value('%' + viewNameLike + '%').append(" order by name asc;");
        return this.jdbcOperations.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(DBObjectIdentity.class));
    }

    @Override
    public List<DBObjectIdentity> listAllUserViews() {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SELECT table_schema as schema_name, 'VIEW' as type, table_name as name ");
        sb.append(" FROM information_schema.tables where table_type = 'VIEW'");
        sb.append(" ORDER BY schema_name, name");
        return this.jdbcOperations.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(DBObjectIdentity.class));
    }

    @Override
    public List<DBObjectIdentity> listAllSystemViews() {
        ArrayList<DBObjectIdentity> results = new ArrayList<DBObjectIdentity>();
        String sql = "show full tables from `information_schema` where Table_type='SYSTEM VIEW'";
        try {
            List informationSchemaViews = this.jdbcOperations.query(sql, (rs, rowNum) -> rs.getString(1));
            informationSchemaViews.forEach(name -> results.add(DBObjectIdentity.of("information_schema", DBObjectType.VIEW, name)));
        }
        catch (Exception ex) {
            log.info("List tables for 'information_schema' failed, reason={}", (Object)ex.getMessage());
        }
        return results;
    }

    @Override
    public List<String> showSystemViews(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SHOW FULL TABLES ");
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            sb.append(" FROM ");
            sb.identifier(schemaName);
        }
        sb.append(" WHERE Table_type = 'SYSTEM VIEW'");
        try {
            return this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> rs.getString(1));
        }
        catch (BadSqlGrammarException ex) {
            if (StringUtils.containsIgnoreCase((CharSequence)ex.getMessage(), (CharSequence)"Unknown database")) {
                return Collections.emptyList();
            }
            throw ex;
        }
    }

    @Override
    public List<DBVariable> showVariables() {
        String sql = "show variables";
        return this.jdbcOperations.query(sql, (rs, rowNum) -> {
            DBVariable variable = new DBVariable();
            variable.setName(rs.getString(1));
            variable.setValue(rs.getString(2));
            return variable;
        });
    }

    @Override
    public List<DBVariable> showSessionVariables() {
        String sql = "show session variables";
        return this.jdbcOperations.query(sql, (rs, rowNum) -> {
            DBVariable variable = new DBVariable();
            variable.setName(rs.getString(1));
            variable.setValue(rs.getString(2));
            return variable;
        });
    }

    @Override
    public List<DBVariable> showGlobalVariables() {
        String sql = "show global variables";
        return this.jdbcOperations.query(sql, (rs, rowNum) -> {
            DBVariable variable = new DBVariable();
            variable.setName(rs.getString(1));
            variable.setValue(rs.getString(2));
            return variable;
        });
    }

    @Override
    public List<String> showCharset() {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("show character set");
        return this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> rs.getString(1));
    }

    @Override
    public List<String> showCollation() {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("show collation");
        return this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> rs.getString(1));
    }

    @Override
    public List<DBPLObjectIdentity> listFunctions(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select ROUTINE_NAME as name, ROUTINE_SCHEMA as schema_name, ROUTINE_TYPE as type from `information_schema`.`routines` where ROUTINE_SCHEMA=");
        sb.value(schemaName);
        sb.append(" and ROUTINE_TYPE = 'FUNCTION' order by name asc;");
        return this.jdbcOperations.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(DBPLObjectIdentity.class));
    }

    @Override
    public List<DBPLObjectIdentity> listProcedures(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select ROUTINE_NAME as name, ROUTINE_SCHEMA as schema_name, ROUTINE_TYPE as type from `information_schema`.`routines` where ROUTINE_SCHEMA=");
        sb.value(schemaName);
        sb.append(" and ROUTINE_TYPE = 'PROCEDURE' order by name asc;");
        return this.jdbcOperations.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(DBPLObjectIdentity.class));
    }

    @Override
    public List<DBPLObjectIdentity> listPackages(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBPLObjectIdentity> listPackageBodies(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBPLObjectIdentity> listTriggers(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBPLObjectIdentity> listTypes(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBObjectIdentity> listSequences(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBObjectIdentity> listSynonyms(String schemaName, DBSynonymType synonymType) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public Map<String, List<DBTableColumn>> listTableColumns(String schemaName, List<String> tableNames) {
        List<DBTableColumn> tableColumns = DBSchemaAccessorUtil.partitionFind(tableNames, 2000, names -> {
            String querySql = this.filterByValues(this.getListTableColumnsSql(schemaName), "TABLE_NAME", (List<String>)names);
            return this.jdbcOperations.query(querySql, this.listTableRowMapper());
        });
        this.correctColumnPrecisionIfNeed(tableColumns);
        return tableColumns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    protected void correctColumnPrecisionIfNeed(List<DBTableColumn> tableColumns) {
        if (CollectionUtils.isNotEmpty(tableColumns)) {
            tableColumns.forEach(this::fillPrecisionAndScale);
        }
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicTableColumns(String schemaName) {
        String sql = this.sqlMapper.getSql("list-basic-schema-table-columns");
        List tableColumns = this.jdbcOperations.query(sql, new Object[]{schemaName, schemaName}, this.listBasicTableColumnRowMapper());
        return tableColumns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    @Override
    public List<DBTableColumn> listBasicTableColumns(String schemaName, String tableName) {
        String sql = this.sqlMapper.getSql("list-basic-table-columns");
        return this.jdbcOperations.query(sql, new Object[]{schemaName, tableName}, this.listBasicTableColumnRowMapper());
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicViewColumns(String schemaName) {
        String sql = this.sqlMapper.getSql("list-basic-schema-view-columns");
        List tableColumns = this.jdbcOperations.query(sql, new Object[]{schemaName, schemaName}, this.listBasicTableColumnRowMapper());
        return tableColumns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    @Override
    public List<DBTableColumn> listBasicViewColumns(String schemaName, String viewName) {
        String sql = this.sqlMapper.getSql("list-basic-view-columns");
        return this.jdbcOperations.query(sql, new Object[]{schemaName, viewName}, this.listBasicTableColumnRowMapper());
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicExternalTableColumns(String schemaName) {
        throw new UnsupportedOperationException("not support yet");
    }

    @Override
    public List<DBTableColumn> listBasicExternalTableColumns(String schemaName, String externalTableName) {
        throw new UnsupportedOperationException("not support yet");
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicColumnsInfo(String schemaName) {
        String sql = this.sqlMapper.getSql("list-basic-schema-columns-info");
        List tableColumns = this.jdbcOperations.query(sql, new Object[]{schemaName}, this.listBasicTableColumnIdentityRowMapper());
        return tableColumns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    protected String getListTableColumnsSql(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select TABLE_NAME, TABLE_SCHEMA, ORDINAL_POSITION, COLUMN_NAME, DATA_TYPE, COLUMN_TYPE, NUMERIC_SCALE, NUMERIC_PRECISION, DATETIME_PRECISION, CHARACTER_MAXIMUM_LENGTH, EXTRA, CHARACTER_SET_NAME, COLLATION_NAME, COLUMN_COMMENT, COLUMN_DEFAULT, IS_NULLABLE, GENERATION_EXPRESSION, COLUMN_KEY from information_schema.columns where TABLE_SCHEMA = ");
        sb.value(schemaName);
        sb.append(" ORDER BY TABLE_NAME, ORDINAL_POSITION");
        return sb.toString();
    }

    protected RowMapper<DBTableColumn> listTableRowMapper() {
        return (rs, romNum) -> {
            DBColumnTypeDisplay columnTypeDisplay;
            DBTableColumn tableColumn = new DBTableColumn();
            tableColumn.setSchemaName(rs.getString("TABLE_SCHEMA"));
            tableColumn.setTableName(rs.getString("TABLE_NAME"));
            tableColumn.setName(rs.getString("COLUMN_NAME"));
            tableColumn.setTypeName(rs.getString("DATA_TYPE"));
            String fullTypeName = rs.getString("COLUMN_TYPE");
            tableColumn.setFullTypeName(fullTypeName);
            if (StringUtils.isNotBlank((CharSequence)tableColumn.getTypeName()) && (this.isTypeEnum(tableColumn.getTypeName()) || this.isTypeSet(tableColumn.getTypeName()))) {
                tableColumn.setEnumValues(DBSchemaAccessorUtil.parseEnumValues(fullTypeName));
            }
            if ((columnTypeDisplay = DBColumnTypeDisplay.fromName(tableColumn.getTypeName())).displayScale()) {
                tableColumn.setScale(rs.getInt("NUMERIC_SCALE"));
            }
            if (columnTypeDisplay.displayPrecision()) {
                if (Objects.nonNull(rs.getObject("NUMERIC_SCALE")) || Objects.nonNull(rs.getObject("NUMERIC_PRECISION"))) {
                    tableColumn.setPrecision(rs.getLong("NUMERIC_PRECISION"));
                } else if (Objects.nonNull(rs.getObject("DATETIME_PRECISION"))) {
                    tableColumn.setPrecision(rs.getLong("DATETIME_PRECISION"));
                } else {
                    tableColumn.setPrecision(rs.getLong("CHARACTER_MAXIMUM_LENGTH"));
                }
            }
            tableColumn.setExtraInfo(rs.getString("EXTRA"));
            Long maxLength = rs.getLong("CHARACTER_MAXIMUM_LENGTH");
            if (Objects.isNull(maxLength)) {
                tableColumn.setMaxLength(rs.getLong("NUMERIC_PRECISION"));
            } else {
                tableColumn.setMaxLength(maxLength);
            }
            tableColumn.setCharsetName(rs.getString("CHARACTER_SET_NAME"));
            tableColumn.setCollationName(rs.getString("COLLATION_NAME"));
            tableColumn.setComment(rs.getString("COLUMN_COMMENT"));
            tableColumn.fillDefaultValue(rs.getString("COLUMN_DEFAULT"));
            tableColumn.setNullable("YES".equalsIgnoreCase(rs.getString("IS_NULLABLE")));
            if (this.supportGeneratedColumn()) {
                tableColumn.setGenExpression(rs.getString("GENERATION_EXPRESSION"));
            }
            tableColumn.setVirtual(StringUtils.isNotEmpty((CharSequence)tableColumn.getGenExpression()));
            tableColumn.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
            String keyTypeName = rs.getString("COLUMN_KEY");
            if (StringUtils.isNotBlank((CharSequence)keyTypeName)) {
                tableColumn.setKeyType(DBTableColumn.KeyType.valueOf(keyTypeName));
            }
            tableColumn.setTypeModifiers(new ArrayList<String>());
            tableColumn.setZerofill(false);
            tableColumn.setUnsigned(false);
            String[] stringArray = fullTypeName.toLowerCase().split("\\s+");
            int n = stringArray.length;
            block8: for (int i = 0; i < n; ++i) {
                String modifier;
                switch (modifier = stringArray[i]) {
                    case "zerofill": {
                        tableColumn.setZerofill(true);
                        tableColumn.getTypeModifiers().add("zerofill");
                        continue block8;
                    }
                    case "unsigned": {
                        tableColumn.setUnsigned(true);
                        tableColumn.getTypeModifiers().add("unsigned");
                    }
                }
            }
            if (Objects.nonNull(tableColumn.getExtraInfo())) {
                tableColumn.setAutoIncrement(tableColumn.getExtraInfo().equalsIgnoreCase("auto_increment"));
                tableColumn.setOnUpdateCurrentTimestamp(tableColumn.getExtraInfo().equalsIgnoreCase("on update current_timestamp"));
                tableColumn.setStored(tableColumn.getExtraInfo().equalsIgnoreCase("stored generated"));
            }
            return tableColumn;
        };
    }

    protected void fillPrecisionAndScale(DBTableColumn column) {
        String typeName = column.getTypeName();
        if (SPECIAL_TYPE_NAMES.contains(Objects.isNull(typeName) ? null : typeName.toLowerCase())) {
            String precisionAndScale = DBSchemaAccessorUtil.parsePrecisionAndScale(column.getFullTypeName());
            if (StringUtils.isBlank((CharSequence)precisionAndScale)) {
                return;
            }
            DBColumnTypeDisplay display = DBColumnTypeDisplay.fromName(typeName);
            if (precisionAndScale.contains(",")) {
                String[] seg = precisionAndScale.split(",");
                if (seg.length == 2) {
                    if (display.displayPrecision()) {
                        column.setPrecision(Long.parseLong(seg[0]));
                    }
                    if (display.displayScale()) {
                        column.setScale(Integer.parseInt(seg[1]));
                    }
                }
            } else if (display.displayPrecision()) {
                column.setPrecision(Long.parseLong(precisionAndScale));
            }
        }
    }

    protected boolean supportGeneratedColumn() {
        return true;
    }

    protected RowMapper<DBTableColumn> listBasicTableColumnRowMapper() {
        return (rs, romNum) -> {
            DBTableColumn tableColumn = new DBTableColumn();
            tableColumn.setSchemaName(rs.getString("TABLE_SCHEMA"));
            tableColumn.setTableName(rs.getString("TABLE_NAME"));
            tableColumn.setName(rs.getString("COLUMN_NAME"));
            tableColumn.setTypeName(rs.getString("DATA_TYPE"));
            tableColumn.setComment(rs.getString("COLUMN_COMMENT"));
            return tableColumn;
        };
    }

    protected RowMapper<DBTableColumn> listBasicTableColumnIdentityRowMapper() {
        return (rs, romNum) -> {
            DBTableColumn tableColumn = new DBTableColumn();
            tableColumn.setSchemaName(rs.getString("TABLE_SCHEMA"));
            tableColumn.setTableName(rs.getString("TABLE_NAME"));
            tableColumn.setName(rs.getString("COLUMN_NAME"));
            return tableColumn;
        };
    }

    protected boolean isTypeEnum(String typeName) {
        return typeName.equalsIgnoreCase("enum");
    }

    protected boolean isTypeSet(String typeName) {
        return typeName.equalsIgnoreCase("set");
    }

    @Override
    public Map<String, List<DBTableIndex>> listTableIndexes(String schemaName) {
        String sql = this.sqlMapper.getSql("list-schema-index");
        LinkedHashMap fullIndexName2Index = new LinkedHashMap();
        this.jdbcOperations.query(sql, new Object[]{schemaName}, (rs, num) -> {
            String tableName = rs.getString("TABLE_NAME");
            String indexName = rs.getString("INDEX_NAME");
            if (!fullIndexName2Index.containsKey(tableName + indexName)) {
                DBTableIndex index = new DBTableIndex();
                index.setSchemaName(rs.getString("TABLE_SCHEMA"));
                index.setTableName(rs.getString("TABLE_NAME"));
                index.setName(indexName);
                index.setOrdinalPosition(rs.getInt("SEQ_IN_INDEX"));
                index.setPrimary(indexName.equalsIgnoreCase("PRIMARY"));
                index.setCardinality(rs.getLong("CARDINALITY"));
                index.setComment(rs.getString("INDEX_COMMENT"));
                index.setAdditionalInfo(rs.getString("COMMENT"));
                index.setNonUnique(rs.getInt("NON_UNIQUE") != 0);
                if (this.isIndexDistinguishesVisibility()) {
                    String visible = rs.getString("IS_VISIBLE");
                    if (Objects.nonNull(visible)) {
                        index.setVisible(visible.equalsIgnoreCase("YES"));
                    }
                } else {
                    index.setVisible(true);
                }
                index.setCollation(rs.getString("COLLATION"));
                index.setAlgorithm(DBIndexAlgorithm.fromString(rs.getString("INDEX_TYPE")));
                if (index.getAlgorithm() == DBIndexAlgorithm.FULLTEXT) {
                    index.setType(DBIndexType.FULLTEXT);
                } else if (index.getAlgorithm() == DBIndexAlgorithm.RTREE || index.getAlgorithm() == DBIndexAlgorithm.SPATIAL) {
                    index.setType(DBIndexType.SPATIAL);
                } else if (index.isNonUnique()) {
                    index.setType(DBIndexType.NORMAL);
                } else {
                    index.setType(DBIndexType.UNIQUE);
                }
                ArrayList<String> columnNames = new ArrayList<String>();
                columnNames.add(rs.getString("COLUMN_NAME"));
                index.setColumnNames(columnNames);
                index.setGlobal(true);
                fullIndexName2Index.put(tableName + indexName, index);
            } else {
                ((DBTableIndex)fullIndexName2Index.get(tableName + indexName)).getColumnNames().add(rs.getString("Column_name"));
            }
            return null;
        });
        Map<String, List<DBTableIndex>> tableName2Indexes = fullIndexName2Index.values().stream().collect(Collectors.groupingBy(DBTableIndex::getTableName));
        for (List<DBTableIndex> columns : tableName2Indexes.values()) {
            columns.stream().sorted(Comparator.comparing(DBTableIndex::getOrdinalPosition)).collect(Collectors.toList());
        }
        return tableName2Indexes;
    }

    protected boolean isIndexDistinguishesVisibility() {
        return false;
    }

    @Override
    public Map<String, List<DBTableConstraint>> listTableConstraints(String schemaName) {
        MySQLSqlBuilder sqlBuilder = new MySQLSqlBuilder();
        String sql = sqlBuilder.append("select t1.CONSTRAINT_NAME, t1.CONSTRAINT_SCHEMA, t1.TABLE_NAME, t1.COLUMN_NAME, t1.ORDINAL_POSITION, t1.REFERENCED_TABLE_SCHEMA, t1.REFERENCED_TABLE_NAME, t1.REFERENCED_COLUMN_NAME, t2.CONSTRAINT_TYPE from ").append("information_schema.key_column_usage").append(" t1 left join ").append("information_schema.table_constraints").append(" t2 on t1.table_name=t2.table_name and t1.table_schema=t2.table_schema and t1.constraint_name=t2.constraint_name").append(" where t1.table_schema=").value(schemaName).append(" order by t1.CONSTRAINT_NAME, t1.ORDINAL_POSITION asc;").toString();
        LinkedHashMap fullConstraintName2Constraint = new LinkedHashMap();
        this.jdbcOperations.query(sql, (rs, num) -> {
            String constraintName = rs.getString("CONSTRAINT_NAME");
            String tableName = rs.getString("TABLE_NAME");
            if (!fullConstraintName2Constraint.containsKey(tableName + constraintName)) {
                DBTableConstraint constraint = new DBTableConstraint();
                constraint.setName(constraintName);
                ArrayList<String> columnNames = new ArrayList<String>();
                columnNames.add(rs.getString("COLUMN_NAME"));
                constraint.setColumnNames(columnNames);
                constraint.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
                constraint.setOwner(rs.getString("CONSTRAINT_SCHEMA"));
                constraint.setSchemaName(schemaName);
                constraint.setTableName(tableName);
                constraint.setReferenceSchemaName(rs.getString("REFERENCED_TABLE_SCHEMA"));
                constraint.setReferenceTableName(rs.getString("REFERENCED_TABLE_NAME"));
                constraint.setType(DBConstraintType.fromValue(rs.getString("CONSTRAINT_TYPE")));
                ArrayList<String> referencedColumnNames = new ArrayList<String>();
                referencedColumnNames.add(rs.getString("REFERENCED_COLUMN_NAME"));
                constraint.setReferenceColumnNames(referencedColumnNames);
                fullConstraintName2Constraint.put(tableName + constraintName, constraint);
            } else {
                ((DBTableConstraint)fullConstraintName2Constraint.get(tableName + constraintName)).getColumnNames().add(rs.getString("COLUMN_NAME"));
                ((DBTableConstraint)fullConstraintName2Constraint.get(tableName + constraintName)).getReferenceColumnNames().add(rs.getString("REFERENCED_COLUMN_NAME"));
            }
            return constraintName;
        });
        for (DBTableConstraint constraint : fullConstraintName2Constraint.values()) {
            if (Objects.nonNull(constraint.getReferenceColumnNames())) {
                constraint.setReferenceColumnNames(constraint.getReferenceColumnNames().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()));
            }
            if (!Objects.nonNull(constraint.getColumnNames())) continue;
            constraint.setColumnNames(constraint.getColumnNames().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }
        return fullConstraintName2Constraint.values().stream().collect(Collectors.groupingBy(DBTableConstraint::getTableName));
    }

    @Override
    public Map<String, DBTable.DBTableOptions> listTableOptions(String schemaName) {
        String collationAndCharsetQuery = "select COLLATION_NAME, CHARACTER_SET_NAME from information_schema.collation_character_set_applicability";
        HashMap collation2Charset = new HashMap();
        this.jdbcOperations.query(collationAndCharsetQuery, rs -> {
            String collationName = rs.getString("COLLATION_NAME");
            String charsetName = rs.getString("CHARACTER_SET_NAME");
            collation2Charset.putIfAbsent(collationName, charsetName);
        });
        LinkedHashMap<String, DBTable.DBTableOptions> tableName2TableOptions = new LinkedHashMap<String, DBTable.DBTableOptions>();
        String sql = new MySQLSqlBuilder().append("select `TABLE_NAME`, `CREATE_TIME`, `UPDATE_TIME`, `AUTO_INCREMENT`, `TABLE_COLLATION`, `TABLE_COMMENT` from `information_schema`.`tables` where table_schema=").value(schemaName).toString();
        this.jdbcOperations.query(sql, t -> {
            String tableName = t.getString("TABLE_NAME");
            DBTable.DBTableOptions options = new DBTable.DBTableOptions();
            tableName2TableOptions.putIfAbsent(tableName, options);
            options.setCreateTime(t.getTimestamp("CREATE_TIME"));
            options.setUpdateTime(t.getTimestamp("UPDATE_TIME"));
            options.setAutoIncrementInitialValue(t.getLong("AUTO_INCREMENT"));
            options.setComment(t.getString("TABLE_COMMENT"));
            options.setCollationName(t.getString("TABLE_COLLATION"));
            if (collation2Charset.containsKey(options.getCollationName())) {
                options.setCharsetName((String)collation2Charset.get(options.getCollationName()));
            }
        });
        return tableName2TableOptions;
    }

    @Override
    public List<DBTableSubpartitionDefinition> listSubpartitions(String schemaName, String tableName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public Boolean isLowerCaseTableName() {
        AtomicBoolean isLowerCaseTableName = new AtomicBoolean(true);
        try {
            this.jdbcOperations.query("show variables like 'lower_case_table_names'", t -> isLowerCaseTableName.set(t.getInt("Value") != 0));
        }
        catch (Exception ex) {
            log.warn("get variable lower_case_table_names failed, will use default value, reason=", (Throwable)ex);
        }
        return isLowerCaseTableName.get();
    }

    @Override
    public List<DBTableColumn> listTableColumns(String schemaName, String tableName) {
        String sql = this.sqlMapper.getSql("list-table-columns");
        List tableColumns = this.jdbcOperations.query(sql, new Object[]{schemaName, tableName}, this.listTableRowMapper());
        this.correctColumnPrecisionIfNeed(tableColumns);
        return tableColumns;
    }

    @Override
    public List<DBObjectIdentity> listPartitionTables(String partitionMethod) {
        String sql = String.format("select distinct t1.table_name as name,t1.table_schema as schema_name, 'TABLE' as type from information_schema.tables t1 join information_schema.partitions t2 on t1.table_name = t2.table_name and t1.table_schema = t2.table_schema where t2.partition_method = '%s'", partitionMethod);
        return this.jdbcOperations.query(sql, (RowMapper)new BeanPropertyRowMapper(DBObjectIdentity.class));
    }

    @Override
    public List<DBTableConstraint> listTableConstraints(String schemaName, String tableName) {
        String sql = this.sqlMapper.getSql("list-table-constraints");
        LinkedHashMap name2Constraint = new LinkedHashMap();
        this.jdbcOperations.query(sql, new Object[]{schemaName, tableName}, (rs, num) -> {
            String constraintName = rs.getString("CONSTRAINT_NAME");
            if (!name2Constraint.containsKey(constraintName)) {
                DBTableConstraint constraint = new DBTableConstraint();
                constraint.setName(constraintName);
                ArrayList<String> columnNames = new ArrayList<String>();
                columnNames.add(rs.getString("COLUMN_NAME"));
                constraint.setColumnNames(columnNames);
                constraint.setOrdinalPosition(num);
                constraint.setOwner(rs.getString("CONSTRAINT_SCHEMA"));
                constraint.setSchemaName(schemaName);
                constraint.setTableName(tableName);
                constraint.setReferenceSchemaName(rs.getString("REFERENCED_TABLE_SCHEMA"));
                constraint.setReferenceTableName(rs.getString("REFERENCED_TABLE_NAME"));
                constraint.setType(DBConstraintType.fromValue(rs.getString("CONSTRAINT_TYPE")));
                ArrayList<String> referencedColumnNames = new ArrayList<String>();
                referencedColumnNames.add(rs.getString("REFERENCED_COLUMN_NAME"));
                constraint.setReferenceColumnNames(referencedColumnNames);
                name2Constraint.put(constraintName, constraint);
            } else {
                ((DBTableConstraint)name2Constraint.get(constraintName)).getColumnNames().add(rs.getString("COLUMN_NAME"));
                ((DBTableConstraint)name2Constraint.get(constraintName)).getReferenceColumnNames().add(rs.getString("REFERENCED_COLUMN_NAME"));
            }
            return constraintName;
        });
        for (DBTableConstraint constraint : name2Constraint.values()) {
            if (Objects.nonNull(constraint.getReferenceColumnNames())) {
                constraint.setReferenceColumnNames(constraint.getReferenceColumnNames().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()));
            }
            if (!Objects.nonNull(constraint.getColumnNames())) continue;
            constraint.setColumnNames(constraint.getColumnNames().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }
        return new ArrayList<DBTableConstraint>(name2Constraint.values());
    }

    @Override
    public DBTablePartition getPartition(String schemaName, String tableName) {
        String sql = this.sqlMapper.getSql("get-partition");
        List queryResult = this.jdbcOperations.query(sql, new Object[]{schemaName, tableName}, (rs, rowNum) -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("SUB_NUM", rs.getInt("SUB_NUM"));
            result.put("PARTITION_EXPRESSION", rs.getString("PARTITION_EXPRESSION"));
            result.put("PARTITION_NAME", rs.getString("PARTITION_NAME"));
            result.put("PARTITION_ORDINAL_POSITION", rs.getInt("PARTITION_ORDINAL_POSITION"));
            result.put("PARTITION_METHOD", rs.getString("PARTITION_METHOD"));
            result.put("PARTITION_DESCRIPTION", rs.getString("PARTITION_DESCRIPTION"));
            result.put("SUBPARTITION_NAME", rs.getString("SUBPARTITION_NAME"));
            result.put("SUBPARTITION_METHOD", rs.getString("SUBPARTITION_METHOD"));
            result.put("SUBPARTITION_EXPRESSION", rs.getString("SUBPARTITION_EXPRESSION"));
            return result;
        });
        return this.getFromResultSet(queryResult, schemaName, tableName);
    }

    @Override
    public Map<String, DBTablePartition> listTablePartitions(@org.springframework.lang.NonNull String schemaName, List<String> tableNames) {
        List queryResult = DBSchemaAccessorUtil.partitionFind(tableNames, 2000, names -> {
            String sql = this.filterByValues(this.sqlMapper.getSql("list-partitions"), "TABLE_NAME", (List<String>)names);
            return this.jdbcOperations.query(sql, new Object[]{schemaName}, (rs, rowNum) -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("TABLE_NAME", rs.getString("TABLE_NAME"));
                result.put("PARTITION_EXPRESSION", rs.getString("PARTITION_EXPRESSION"));
                result.put("PARTITION_NAME", rs.getString("PARTITION_NAME"));
                result.put("PARTITION_ORDINAL_POSITION", rs.getInt("PARTITION_ORDINAL_POSITION"));
                result.put("PARTITION_METHOD", rs.getString("PARTITION_METHOD"));
                result.put("PARTITION_DESCRIPTION", rs.getString("PARTITION_DESCRIPTION"));
                result.put("SUBPARTITION_NAME", rs.getString("SUBPARTITION_NAME"));
                result.put("SUBPARTITION_METHOD", rs.getString("SUBPARTITION_METHOD"));
                result.put("SUBPARTITION_EXPRESSION", rs.getString("SUBPARTITION_EXPRESSION"));
                return result;
            });
        });
        Map<String, List<Map>> tableName2Res = queryResult.stream().collect(Collectors.groupingBy(m -> (String)m.get("TABLE_NAME")));
        return tableName2Res.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Map partiName2Res = ((List)e.getValue()).stream().collect(Collectors.groupingBy(m -> (String)m.get("PARTITION_NAME"), LinkedHashMap::new, Collectors.toList()));
            List<Map<String, Object>> group = partiName2Res.keySet().stream().map(partiName -> {
                List rows = (List)partiName2Res.get(partiName);
                Map row = (Map)rows.get(0);
                row.put("SUB_NUM", rows.size() == 1 ? 0 : rows.size());
                return row;
            }).collect(Collectors.toList());
            return this.getFromResultSet(group, schemaName, (String)e.getKey());
        }));
    }

    @Override
    public List<DBTablePartition> listTableRangePartitionInfo(String tenantName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    protected String filterByValues(String target, String colName, List<String> candidates) {
        if (CollectionUtils.isEmpty(candidates)) {
            return target;
        }
        String tables = candidates.stream().map(s -> new MySQLSqlBuilder().value((String)s).toString()).collect(Collectors.joining(","));
        MySQLSqlBuilder sqlBuilder = new MySQLSqlBuilder();
        return sqlBuilder.append("select * from (").append(target).append(") dbbrowser").append(" WHERE dbbrowser.").identifier(colName).append(" in (").append(tables).append(")").toString();
    }

    private DBTablePartition getFromResultSet(List<Map<String, Object>> rows, String schemaName, String tableName) {
        DBTablePartition partition = new DBTablePartition();
        DBTablePartition subPartition = new DBTablePartition();
        partition.setSubpartition(subPartition);
        partition.setSchemaName(schemaName);
        partition.setTableName(tableName);
        subPartition.setSchemaName(schemaName);
        DBTablePartitionOption partitionOption = new DBTablePartitionOption();
        partitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        partition.setPartitionOption(partitionOption);
        DBTablePartitionOption subPartitionOption = new DBTablePartitionOption();
        subPartitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        subPartition.setPartitionOption(subPartitionOption);
        ArrayList<DBTablePartitionDefinition> partitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        partition.setPartitionDefinitions(partitionDefinitions);
        ArrayList<DBTablePartitionDefinition> subPartitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        subPartition.setPartitionDefinitions(subPartitionDefinitions);
        HashSet<String> partitionNames = new HashSet<String>();
        for (Map<String, Object> row : rows) {
            String partitionName;
            partitionOption.setType(DBTablePartitionType.fromValue((String)row.get("PARTITION_METHOD")));
            String expression = (String)row.get("PARTITION_EXPRESSION");
            if (StringUtils.isNotEmpty((CharSequence)expression)) {
                if (partitionOption.getType().supportExpression()) {
                    partitionOption.setExpression(expression);
                } else {
                    partitionOption.setColumnNames(Arrays.asList(expression.split(",")));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(partitionName = (String)row.get("PARTITION_NAME"))) && !partitionNames.contains(partitionName)) {
                partitionNames.add(partitionName);
                DBTablePartitionDefinition partitionDefinition = new DBTablePartitionDefinition();
                partitionDefinition.setName(partitionName);
                partitionDefinition.setOrdinalPosition((Integer)row.get("PARTITION_ORDINAL_POSITION"));
                partitionDefinition.setType(DBTablePartitionType.fromValue((String)row.get("PARTITION_METHOD")));
                String description = (String)row.get("PARTITION_DESCRIPTION");
                partitionDefinition.fillValues(description);
                partitionDefinitions.add(partitionDefinition);
            }
            String subPartitionName = (String)row.get("SUBPARTITION_NAME");
            DBTablePartitionType subPartitionType = DBTablePartitionType.fromValue((String)row.get("SUBPARTITION_METHOD"));
            String subPartExpression = (String)row.get("SUBPARTITION_EXPRESSION");
            if (!StringUtils.isNotEmpty((CharSequence)subPartitionName)) continue;
            if (subPartitionType == DBTablePartitionType.HASH || subPartitionType == DBTablePartitionType.KEY) {
                partition.setSubpartitionTemplated(true);
                subPartitionOption.setType(subPartitionType);
                subPartitionOption.setPartitionsNum((Integer)row.get("SUB_NUM"));
                if (!StringUtils.isNotEmpty((CharSequence)subPartExpression)) continue;
                if (subPartitionType.supportExpression()) {
                    subPartitionOption.setExpression(subPartExpression);
                    continue;
                }
                subPartitionOption.setColumnNames(Arrays.asList(subPartExpression.split(",")));
                continue;
            }
            partition.setWarning("Only support HASH/KEY subpartition currently, please check comparing ddl");
        }
        partitionOption.setPartitionsNum(partitionNames.size());
        if (partitionOption.getType() == DBTablePartitionType.HASH && partitionOption.getPartitionsNum() == 0) {
            partitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
            partition.setPartitionDefinitions(Collections.emptyList());
        }
        return partition;
    }

    @Override
    public List<DBTableIndex> listTableIndexes(String schemaName, String tableName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("show index from ");
        sb.identifier(tableName);
        sb.append(" from ");
        sb.identifier(schemaName);
        LinkedHashMap indexName2Index = new LinkedHashMap();
        this.jdbcOperations.query(sb.toString(), (rs, num) -> {
            String indexName = rs.getString("Key_name");
            if (!indexName2Index.containsKey(indexName)) {
                DBTableIndex index = new DBTableIndex();
                index.setTableName(rs.getString("Table"));
                index.setSchemaName(schemaName);
                index.setName(indexName);
                index.setOrdinalPosition(num);
                index.setPrimary(indexName.equalsIgnoreCase("PRIMARY"));
                index.setCardinality(rs.getLong("Cardinality"));
                index.setComment(rs.getString("Index_comment"));
                index.setAdditionalInfo(rs.getString("Comment"));
                index.setNonUnique(rs.getInt("Non_unique") != 0);
                if (this.isIndexDistinguishesVisibility()) {
                    String visible = rs.getString("Visible");
                    if (Objects.nonNull(visible)) {
                        index.setVisible(visible.equalsIgnoreCase("YES"));
                    }
                } else {
                    index.setVisible(true);
                }
                index.setCollation(rs.getString("Collation"));
                index.setAlgorithm(DBIndexAlgorithm.fromString(rs.getString("Index_type")));
                if (index.getAlgorithm() == DBIndexAlgorithm.FULLTEXT) {
                    index.setType(DBIndexType.FULLTEXT);
                } else if (index.getAlgorithm() == DBIndexAlgorithm.RTREE || index.getAlgorithm() == DBIndexAlgorithm.SPATIAL) {
                    index.setType(DBIndexType.SPATIAL);
                } else if (index.isNonUnique()) {
                    index.setType(DBIndexType.NORMAL);
                } else {
                    index.setType(DBIndexType.UNIQUE);
                }
                ArrayList<String> columnNames = new ArrayList<String>();
                columnNames.add(rs.getString("Column_name"));
                index.setColumnNames(columnNames);
                index.setGlobal(true);
                this.handleIndexAvailability(index, rs.getString("Comment"));
                indexName2Index.put(indexName, index);
            } else {
                ((DBTableIndex)indexName2Index.get(indexName)).getColumnNames().add(rs.getString("Column_name"));
            }
            return null;
        });
        return new ArrayList<DBTableIndex>(indexName2Index.values());
    }

    protected void handleIndexAvailability(DBTableIndex index, String availability) {
        if (StringUtils.isBlank((CharSequence)availability)) {
            index.setAvailable(true);
        } else if ("disabled".equals(availability)) {
            index.setAvailable(false);
        }
    }

    @Override
    public String getTableDDL(String schemaName, String tableName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SHOW CREATE TABLE ");
        sb.identifier(schemaName);
        sb.append(".");
        sb.identifier(tableName);
        AtomicReference ddl = new AtomicReference();
        this.jdbcOperations.query(sb.toString(), rs -> ddl.set(rs.getString(2)));
        return (String)ddl.get();
    }

    @Override
    public DBTable.DBTableOptions getTableOptions(String schemaName, String tableName) {
        return this.getTableOptions(schemaName, tableName, this.getTableDDL(schemaName, tableName));
    }

    @Override
    public DBTable.DBTableOptions getTableOptions(String schemaName, String tableName, @NonNull String ddl) {
        if (ddl == null) {
            throw new NullPointerException("ddl is marked non-null but is null");
        }
        DBTable.DBTableOptions dbTableOptions = new DBTable.DBTableOptions();
        this.obtainOptionsByQuery(schemaName, tableName, dbTableOptions);
        try {
            this.obtainOptionsByParser(dbTableOptions, ddl);
        }
        catch (Exception e) {
            log.warn("Failed to get table options by parse table ddl, message={}", (Object)e.getMessage());
        }
        return dbTableOptions;
    }

    @Override
    public List<DBColumnGroupElement> listTableColumnGroups(String schemaName, String tableName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private void obtainOptionsByQuery(String schemaName, String tableName, DBTable.DBTableOptions dbTableOptions) {
        String sql = this.sqlMapper.getSql("get-table-option");
        this.jdbcOperations.query(sql, new Object[]{schemaName, tableName}, t -> {
            dbTableOptions.setCreateTime(t.getTimestamp("CREATE_TIME"));
            dbTableOptions.setUpdateTime(t.getTimestamp("UPDATE_TIME"));
            dbTableOptions.setAutoIncrementInitialValue(t.getLong("AUTO_INCREMENT"));
            dbTableOptions.setCollationName(t.getString("TABLE_COLLATION"));
            dbTableOptions.setComment(t.getString("TABLE_COMMENT"));
        });
    }

    private void obtainOptionsByParser(DBTable.DBTableOptions dbTableOptions, String ddl) {
        CreateTable stmt;
        TableOptions options;
        Statement statement = SqlParser.parseMysqlStatement(ddl);
        if (statement instanceof CreateTable && Objects.nonNull(options = (stmt = (CreateTable)statement).getTableOptions())) {
            dbTableOptions.setCharsetName(options.getCharset());
            dbTableOptions.setRowFormat(options.getRowFormat());
            dbTableOptions.setCompressionOption(options.getCompression());
            dbTableOptions.setReplicaNum(options.getReplicaNum());
            dbTableOptions.setBlockSize(options.getBlockSize());
            dbTableOptions.setUseBloomFilter(options.getUseBloomFilter());
            dbTableOptions.setTabletSize(Objects.nonNull(options.getTabletSize()) ? Long.valueOf(options.getTabletSize().longValue()) : null);
        }
    }

    @Override
    public DBView getView(String schemaName, String viewName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select * from information_schema.views where table_schema=");
        sb.value(schemaName);
        sb.append(" and table_name=");
        sb.value(viewName);
        DBView view = new DBView();
        view.setViewName(viewName);
        view.setSchemaName(schemaName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            view.setCheckOption(rs.getString(5));
            view.setUpdatable("YES".equalsIgnoreCase(rs.getString(6)));
            view.setDefiner(rs.getString(7));
        });
        MySQLSqlBuilder getDDL = new MySQLSqlBuilder();
        getDDL.append("show create table ");
        getDDL.identifier(schemaName);
        getDDL.append(".");
        getDDL.identifier(viewName);
        this.jdbcOperations.query(getDDL.toString(), rs -> view.setDdl(rs.getString(2)));
        return this.fillColumnInfoByDesc(view);
    }

    protected DBView fillColumnInfoByDesc(DBView view) {
        try {
            MySQLSqlBuilder sb = new MySQLSqlBuilder();
            sb.append("desc ");
            if (StringUtils.isNotBlank((CharSequence)view.getSchemaName())) {
                sb.identifier(view.getSchemaName()).append(".");
            }
            sb.identifier(view.getViewName());
            List columns = this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> {
                DBTableColumn column = new DBTableColumn();
                column.setName(rs.getString(1));
                column.setTypeName(rs.getString(2));
                column.setNullable("YES".equalsIgnoreCase(rs.getString(3)));
                column.setDefaultValue(rs.getString(5));
                column.setOrdinalPosition(rowNum);
                column.setTableName(view.getViewName());
                return column;
            });
            view.setColumns(columns);
        }
        catch (Exception e) {
            log.warn("fail to get view column info, message={}", (Object)e.getMessage());
        }
        return view;
    }

    @Override
    public DBFunction getFunction(String schemaName, String functionName) {
        MySQLSqlBuilder sql1 = new MySQLSqlBuilder();
        sql1.append("select DEFINER, CREATED, LAST_ALTERED, ROUTINE_DEFINITION from `information_schema`.`routines` where ROUTINE_SCHEMA=").value(schemaName).append(" and ROUTINE_TYPE = 'FUNCTION' and ROUTINE_NAME=").value(functionName);
        MySQLSqlBuilder queryForParameters = new MySQLSqlBuilder();
        queryForParameters.append("select PARAMETER_MODE, PARAMETER_NAME, DTD_IDENTIFIER from `information_schema`.`parameters` where SPECIFIC_SCHEMA=").value(schemaName).append(" and SPECIFIC_NAME=").value(functionName).append(" and ROUTINE_TYPE='FUNCTION'");
        MySQLSqlBuilder parameters = new MySQLSqlBuilder();
        DBFunction function = new DBFunction();
        function.setFunName(functionName);
        this.jdbcOperations.query(queryForParameters.toString(), rs -> {
            if ("NULL".equals(rs.getString("PARAMETER_MODE")) || Objects.isNull(rs.getString("PARAMETER_MODE"))) {
                function.setReturnType(rs.getString("DTD_IDENTIFIER"));
            } else {
                parameters.identifier(rs.getString("PARAMETER_NAME")).space().append(rs.getString("DTD_IDENTIFIER")).append(",");
            }
        });
        this.jdbcOperations.query(sql1.toString(), rs -> {
            function.setDefiner(rs.getString("DEFINER"));
            function.setCreateTime(Timestamp.valueOf(rs.getString("CREATED")));
            function.setModifyTime(Timestamp.valueOf(rs.getString("LAST_ALTERED")));
            function.setDdl(String.format("create function %s (%s) returns %s %s;", StringUtils.quoteMysqlIdentifier(function.getFunName()), StringUtils.substring((String)parameters.toString(), (int)0, (int)(parameters.length() - 1)), function.getReturnType(), rs.getString("ROUTINE_DEFINITION")));
        });
        return this.parseFunctionDDL(function);
    }

    protected String convertBlobToString(Blob data, String collation) {
        Charset charset = null;
        try {
            charset = Charset.forName(collation.split("_")[0]);
        }
        catch (UnsupportedCharsetException exception) {
            log.warn("Unsupported Charset, message={}", (Object)exception.getMessage());
        }
        StringWriter writer = new StringWriter();
        try (InputStreamReader reader = new InputStreamReader(data.getBinaryStream(), charset == null ? StandardCharsets.UTF_8 : charset);
             BufferedReader br = new BufferedReader(reader);){
            String content;
            while ((content = br.readLine()) != null) {
                writer.write(content + "\n");
            }
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException("Could not convert BLOB to string, message={}", e);
        }
        return writer.toString().substring(0, writer.toString().length() - 1);
    }

    protected DBFunction parseFunctionDDL(DBFunction function) {
        try {
            ParseMysqlPLResult result = PLParser.parseObMysql(function.getDdl());
            function.setVariables(result.getVaribaleList());
            function.setParams(result.getParamList());
        }
        catch (Exception e) {
            log.warn("Failed to parse function ddl={}, errorMessage={}", (Object)function.getDdl(), (Object)e.getMessage());
            function.setParseErrorMessage(e.getMessage());
        }
        return function;
    }

    @Override
    public DBProcedure getProcedure(String schemaName, String procedureName) {
        MySQLSqlBuilder sql1 = new MySQLSqlBuilder();
        sql1.append("select DEFINER, CREATED, LAST_ALTERED, ROUTINE_DEFINITION from `information_schema`.`routines` where ROUTINE_SCHEMA=").value(schemaName).append(" and ROUTINE_TYPE = 'PROCEDURE' and ROUTINE_NAME=").value(procedureName);
        DBProcedure procedure = new DBProcedure();
        procedure.setProName(procedureName);
        MySQLSqlBuilder getDDL = new MySQLSqlBuilder();
        getDDL.append("show create procedure ");
        if (schemaName == null) {
            getDDL.identifier(procedureName);
        } else {
            getDDL.identifier(schemaName);
            getDDL.append(".");
            getDDL.identifier(procedureName);
        }
        this.jdbcOperations.query(getDDL.toString(), rs -> procedure.setDdl(rs.getString("Create Procedure")));
        this.jdbcOperations.query(sql1.toString(), rs -> {
            procedure.setDefiner(rs.getString("DEFINER"));
            procedure.setCreateTime(Timestamp.valueOf(rs.getString("CREATED")));
            procedure.setModifyTime(Timestamp.valueOf(rs.getString("LAST_ALTERED")));
        });
        return this.parseProcedureDDL(procedure);
    }

    protected DBProcedure parseProcedureDDL(DBProcedure procedure) {
        Validate.notBlank((CharSequence)procedure.getDdl(), (String)"procedure.ddl", (Object[])new Object[0]);
        try {
            ParseMysqlPLResult result = PLParser.parseObMysql(procedure.getDdl());
            procedure.setParams(result.getParamList());
            procedure.setVariables(result.getVaribaleList());
            procedure.setTypes(result.getTypeList());
        }
        catch (Exception e) {
            log.warn("Failed to parse, ddl={}, errorMessage={}", (Object)procedure.getDdl(), (Object)e.getMessage());
            procedure.setParseErrorMessage(e.getMessage());
            return procedure;
        }
        return procedure;
    }

    @Override
    public DBPackage getPackage(String schemaName, String packageName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBTrigger getTrigger(String schemaName, String packageName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBType getType(String schemaName, String typeName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBSequence getSequence(String schemaName, String sequenceName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBSynonym getSynonym(String schemaName, String synonymName, DBSynonymType synonymType) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public Map<String, DBTable> getTables(@org.springframework.lang.NonNull String schemaName, List<String> tableNames) {
        HashMap<String, DBTable> returnVal = new HashMap<String, DBTable>();
        tableNames = this.showTables(schemaName);
        if (tableNames.isEmpty()) {
            return returnVal;
        }
        Map<String, List<DBTableColumn>> tableName2Columns = this.listTableColumns(schemaName, Collections.emptyList());
        Map<String, List<DBTableIndex>> tableName2Indexes = this.listTableIndexes(schemaName);
        Map<String, List<DBTableConstraint>> tableName2Constraints = this.listTableConstraints(schemaName);
        Map<String, DBTable.DBTableOptions> tableName2Options = this.listTableOptions(schemaName);
        for (String tableName : tableNames) {
            if (!tableName2Columns.containsKey(tableName)) continue;
            DBTable table = new DBTable();
            table.setSchemaName(schemaName);
            table.setOwner(schemaName);
            table.setName(tableName);
            table.setColumns(tableName2Columns.getOrDefault(tableName, new ArrayList()));
            table.setIndexes(tableName2Indexes.getOrDefault(tableName, new ArrayList()));
            table.setConstraints(tableName2Constraints.getOrDefault(tableName, new ArrayList()));
            table.setTableOptions(tableName2Options.getOrDefault(tableName, new DBTable.DBTableOptions()));
            table.setPartition(this.getPartition(schemaName, tableName));
            table.setDDL(this.getTableDDL(schemaName, tableName));
            returnVal.put(tableName, table);
        }
        return returnVal;
    }

    static {
        SPECIAL_TYPE_NAMES.add("bit");
        SPECIAL_TYPE_NAMES.add("int");
        SPECIAL_TYPE_NAMES.add("tinyint");
        SPECIAL_TYPE_NAMES.add("smallint");
        SPECIAL_TYPE_NAMES.add("mediumint");
        SPECIAL_TYPE_NAMES.add("bigint");
        SPECIAL_TYPE_NAMES.add("float");
        SPECIAL_TYPE_NAMES.add("double");
    }
}

