/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.template.mysql;

import com.oceanbase.tools.dbbrowser.model.DBPLParam;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.model.DBRoutineDataNature;
import com.oceanbase.tools.dbbrowser.template.mysql.BaseMySQLPLTemplate;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class MySQLProcedureTemplate
extends BaseMySQLPLTemplate<DBProcedure> {
    @Override
    public String generateCreateObjectTemplate(DBProcedure dbObject) {
        Validate.notBlank((CharSequence)dbObject.getProName(), (String)"Procedure name can not be blank", (Object[])new Object[0]);
        MySQLSqlBuilder sqlBuilder = new MySQLSqlBuilder();
        sqlBuilder.append("create procedure ").identifier(dbObject.getProName()).append("(");
        List<DBPLParam> paramList = dbObject.getParams();
        if (CollectionUtils.isNotEmpty(paramList)) {
            sqlBuilder.append(paramList.stream().map(p -> "\n\t" + this.generateInOutString(p.getParamMode()) + " " + StringUtils.quoteMysqlIdentifier(p.getParamName()) + " " + p.getDataType()).collect(Collectors.joining(",")));
        }
        sqlBuilder.append(")").line();
        if (Objects.nonNull(dbObject.getCharacteristic())) {
            if (Objects.nonNull(dbObject.getCharacteristic().getComment())) {
                sqlBuilder.space().append("COMMENT ").value(dbObject.getCharacteristic().getComment()).line();
            }
            if (Objects.nonNull(dbObject.getCharacteristic().getDeterministic()) && dbObject.getCharacteristic().getDeterministic().booleanValue()) {
                sqlBuilder.space().append("DETERMINISTIC").line();
            }
            if (Objects.nonNull((Object)dbObject.getCharacteristic().getDataNature())) {
                switch (dbObject.getCharacteristic().getDataNature()) {
                    case CONTAINS_SQL: {
                        sqlBuilder.space().append(DBRoutineDataNature.CONTAINS_SQL.getValue()).line();
                        break;
                    }
                    case NO_SQL: {
                        sqlBuilder.space().append(DBRoutineDataNature.NO_SQL.getValue()).line();
                        break;
                    }
                    case READS_SQL: {
                        sqlBuilder.space().append(DBRoutineDataNature.READS_SQL.getValue()).line();
                        break;
                    }
                    case MODIFIES_SQL: {
                        sqlBuilder.space().append(DBRoutineDataNature.MODIFIES_SQL.getValue()).line();
                    }
                }
            }
            if (Objects.nonNull((Object)dbObject.getCharacteristic().getSqlSecurity())) {
                sqlBuilder.space().append("SQL SECURITY ").append((Object)dbObject.getCharacteristic().getSqlSecurity()).line();
            }
        }
        sqlBuilder.append("begin").append("\n\t-- Enter your procedure code").append("\nend");
        return sqlBuilder.toString();
    }
}

