/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.util;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.text.StringSubstitutor;

public abstract class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final char MYSQL_IDENTIFIER_WRAP_CHAR = '`';
    private static final char ORACLE_IDENTIFIER_WRAP_CHAR = '\"';
    private static final String DEFAULT_VARIABLE_SUFFIX = "}";
    private static final String DEFAULT_VARIABLE_PREFIX = "${";

    public static String quoteMysqlIdentifier(String str) {
        return StringUtils.quoteSqlIdentifier(str, '`');
    }

    public static String quoteOracleIdentifier(String str) {
        return StringUtils.quoteSqlIdentifier(str, '\"');
    }

    static String quoteSqlIdentifier(String str, char wrapChar) {
        if (null == str) {
            return null;
        }
        String escaped = StringUtils.escapeUseDouble(str, new char[]{wrapChar});
        return wrapChar + escaped + wrapChar;
    }

    public static String unquoteMySqlIdentifier(String str) {
        return StringUtils.unquoteSqlIdentifier(str, '`');
    }

    public static String unquoteOracleIdentifier(String str) {
        return StringUtils.unquoteSqlIdentifier(str, '\"');
    }

    public static String unquoteSqlIdentifier(String str, char wrapChar) {
        String escaped = StringUtils.unwrap((String)str, (char)wrapChar);
        if (Objects.equals(escaped, str)) {
            return str;
        }
        return StringUtils.replace((String)escaped, (String)("" + wrapChar + wrapChar), (String)("" + wrapChar));
    }

    public static String quoteOracleValue(String str) {
        return StringUtils.quoteSqlValue(str, '\'');
    }

    public static String quoteMysqlValue(String str) {
        return StringUtils.quoteSqlValue(str, '\'', new char[]{'\'', '\\'});
    }

    public static String quoteSqlValue(String str, char wrapChar) {
        char[] escapeChars = new char[]{wrapChar};
        return StringUtils.quoteSqlValue(str, wrapChar, escapeChars);
    }

    public static String quoteSqlValue(String str, char wrapChar, char[] escapeChars) {
        if (null == str) {
            return null;
        }
        String escaped = StringUtils.escapeUseDouble(str, escapeChars);
        return wrapChar + escaped + wrapChar;
    }

    public static String escapeUseDouble(String name, char escapeChar) {
        return StringUtils.escapeUseDouble(name, new char[]{escapeChar});
    }

    public static String escapeUseDouble(String str, char[] escapeChars) {
        if (null == str || null == escapeChars) {
            return null;
        }
        char[] chars = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char char1 : chars) {
            sb.append(char1);
            if (!StringUtils.contains(escapeChars, char1)) continue;
            sb.append(char1);
        }
        return sb.toString();
    }

    public static String escapeLike(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        value = StringUtils.replace((String)value, (String)"%", (String)"\\%");
        return StringUtils.replace((String)value, (String)"_", (String)"\\_");
    }

    public static boolean contains(char[] array, char target) {
        for (char value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static String replaceVariables(String template, Map<String, String> valuesMap) {
        return StringUtils.replaceVariables(template, valuesMap, DEFAULT_VARIABLE_PREFIX, DEFAULT_VARIABLE_SUFFIX);
    }

    public static String replaceVariables(String template, Map<String, String> valuesMap, String prefix, String suffix) {
        if (StringUtils.isEmpty((CharSequence)template)) {
            return "";
        }
        if (valuesMap == null || valuesMap.isEmpty()) {
            return template;
        }
        StringSubstitutor sub = new StringSubstitutor(valuesMap, prefix, suffix).setDisableSubstitutionInValues(true);
        return sub.replace(template);
    }
}

