/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.connection;

import com.alibaba.druid.pool.DruidDataSource;
import com.alipay.oceanbase.rpc.table.ObDirectLoadParameter;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableDirectLoad;
import com.oceanbase.connector.flink.OceanBaseConnectorOptions;
import com.oceanbase.connector.flink.connection.ConnectionProvider;
import com.oceanbase.connector.flink.connection.OceanBaseUserInfo;
import com.oceanbase.connector.flink.connection.OceanBaseVersion;
import com.oceanbase.connector.flink.dialect.OceanBaseDialect;
import com.oceanbase.connector.flink.dialect.OceanBaseMySQLDialect;
import com.oceanbase.connector.flink.dialect.OceanBaseOracleDialect;
import com.oceanbase.connector.flink.table.TableId;
import com.oceanbase.connector.flink.utils.OceanBaseJdbcUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanBaseConnectionProvider
implements ConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OceanBaseConnectionProvider.class);
    private static final long serialVersionUID = 1L;
    private final OceanBaseConnectorOptions options;
    private final OceanBaseDialect dialect;
    private OceanBaseVersion version;
    private OceanBaseUserInfo userInfo;
    private volatile transient boolean inited = false;
    private transient DataSource dataSource;

    public OceanBaseConnectionProvider(OceanBaseConnectorOptions options) {
        this.options = options;
        this.dialect = "MySQL".equalsIgnoreCase(this.getCompatibleMode().trim()) ? new OceanBaseMySQLDialect() : new OceanBaseOracleDialect(options);
    }

    private String getCompatibleMode() {
        try {
            Class.forName(this.options.getDriverClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load driver class: " + this.options.getDriverClassName(), e);
        }
        String mode = OceanBaseJdbcUtils.getCompatibleMode((SupplierWithException<Connection, SQLException>)((SupplierWithException)() -> DriverManager.getConnection(this.options.getUrl(), this.options.getUsername(), this.options.getPassword())));
        if (StringUtils.isBlank((CharSequence)mode)) {
            throw new RuntimeException("Query found empty compatible mode");
        }
        LOG.info("Query found OceanBase compatible mode: {}", (Object)mode);
        return mode;
    }

    public OceanBaseDialect getDialect() {
        return this.dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (!this.inited) {
            OceanBaseConnectionProvider oceanBaseConnectionProvider = this;
            synchronized (oceanBaseConnectionProvider) {
                if (!this.inited) {
                    DruidDataSource druidDataSource = new DruidDataSource();
                    druidDataSource.setUrl(this.options.getUrl());
                    druidDataSource.setUsername(this.options.getUsername());
                    druidDataSource.setPassword(this.options.getPassword());
                    druidDataSource.setDriverClassName(this.options.getDriverClassName());
                    Properties properties = this.options.getDruidProperties();
                    if (properties != null) {
                        druidDataSource.configFromPropeties(properties);
                    }
                    this.dataSource = druidDataSource;
                    this.inited = true;
                }
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.init();
        return this.dataSource.getConnection();
    }

    public OceanBaseVersion getVersion() {
        if (this.version == null) {
            String versionComment = OceanBaseJdbcUtils.getVersionComment((SupplierWithException<Connection, SQLException>)((SupplierWithException)this::getConnection));
            LOG.info("Query found version comment: {}", (Object)versionComment);
            this.version = OceanBaseVersion.fromVersionComment((String)versionComment);
        }
        return this.version;
    }

    public OceanBaseUserInfo getUserInfo() {
        if (this.userInfo == null) {
            OceanBaseUserInfo user = OceanBaseUserInfo.parse((String)this.options.getUsername());
            if (user.getCluster() == null) {
                String cluster = OceanBaseJdbcUtils.getClusterName((SupplierWithException<Connection, SQLException>)((SupplierWithException)this::getConnection));
                if (StringUtils.isBlank((CharSequence)cluster)) {
                    throw new RuntimeException("Query found empty cluster name");
                }
                user.setCluster(cluster);
            }
            if (user.getTenant() == null) {
                String tenant = OceanBaseJdbcUtils.getTenantName((SupplierWithException<Connection, SQLException>)((SupplierWithException)this::getConnection), this.dialect);
                if (StringUtils.isBlank((CharSequence)tenant)) {
                    throw new RuntimeException("Query found empty tenant name");
                }
                user.setTenant(tenant);
            }
            this.userInfo = user;
        }
        return this.userInfo;
    }

    public ObTableDirectLoad getDirectLoad(TableId tableId) {
        int count = OceanBaseJdbcUtils.getTableRowsCount((SupplierWithException<Connection, SQLException>)((SupplierWithException)this::getConnection), tableId.identifier());
        if (count != 0) {
            throw new RuntimeException("Direct load can only work on empty table, while table " + tableId.identifier() + " has " + count + " rows");
        }
        ObTable table = this.getDirectLoadTable(tableId.getSchemaName());
        return new ObTableDirectLoad(table, tableId.getTableName(), this.getDirectLoadParameter(), true);
    }

    private ObTable getDirectLoadTable(String schemaName) {
        try {
            return new ObTable.Builder(this.options.getDirectLoadHost(), this.options.getDirectLoadPort()).setLoginInfo(this.getUserInfo().getTenant(), this.getUserInfo().getUser(), this.options.getPassword(), schemaName).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get ObTable", e);
        }
    }

    private ObDirectLoadParameter getDirectLoadParameter() {
        ObDirectLoadParameter parameter = new ObDirectLoadParameter();
        parameter.setParallel(this.options.getDirectLoadParallel());
        parameter.setMaxErrorRowCount(this.options.getDirectLoadMaxErrorRows());
        parameter.setDupAction(this.options.getDirectLoadDupAction());
        parameter.setTimeout(this.options.getDirectLoadTimeout());
        parameter.setHeartBeatTimeout(this.options.getDirectLoadHeartbeatTimeout());
        return parameter;
    }

    public void close() throws Exception {
        if (this.dataSource != null) {
            if (this.dataSource instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
            this.dataSource = null;
        }
        this.inited = false;
    }
}

