/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.connection;

import com.oceanbase.partition.calculator.ObPartIdCalculator;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

public class OceanBaseTablePartInfo {
    private final ObPartIdCalculator partIdCalculator;
    private final Map<String, Integer> partColumnIndexMap;

    public OceanBaseTablePartInfo(TableEntry tableEntry, boolean isV4) {
        this.partIdCalculator = new ObPartIdCalculator(false, tableEntry, isV4);
        this.partColumnIndexMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        ObTablePart tablePart = tableEntry.getTablePart();
        if (tablePart != null) {
            Stream.concat(tablePart.getPartColumns().stream(), tablePart.getSubPartColumns().stream()).forEach(obPartColumn -> this.partColumnIndexMap.put(obPartColumn.getColumnName(), obPartColumn.getColumnIndex()));
        }
    }

    public ObPartIdCalculator getPartIdCalculator() {
        return this.partIdCalculator;
    }

    public Map<String, Integer> getPartColumnIndexMap() {
        return this.partColumnIndexMap;
    }
}

