/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.connector.flink.dialect;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.util.function.SerializableFunction;

public interface OceanBaseDialect
extends Serializable {
    public String quoteIdentifier(@Nonnull String var1);

    default public String getFullTableName(@Nonnull String schemaName, @Nonnull String tableName) {
        return String.format("%s.%s", this.quoteIdentifier(schemaName), this.quoteIdentifier(tableName));
    }

    default public String getPlaceholder(@Nonnull String fieldName, @Nullable SerializableFunction<String, String> placeholderFunc) {
        return placeholderFunc != null ? (String)placeholderFunc.apply((Object)fieldName) : "?";
    }

    public String getUpsertStatement(@Nonnull String var1, @Nonnull String var2, @Nonnull List<String> var3, @Nonnull List<String> var4, @Nullable SerializableFunction<String, String> var5);

    default public String getInsertIntoStatement(@Nonnull String schemaName, @Nonnull String tableName, @Nonnull List<String> fieldNames, @Nullable SerializableFunction<String, String> placeholderFunc) {
        String columns = fieldNames.stream().map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String placeholders = fieldNames.stream().map(f -> this.getPlaceholder((String)f, placeholderFunc)).collect(Collectors.joining(", "));
        return "INSERT INTO " + this.getFullTableName(schemaName, tableName) + "(" + columns + ") VALUES (" + placeholders + ")";
    }

    default public String getDeleteStatement(@Nonnull String schemaName, @Nonnull String tableName, @Nonnull List<String> uniqueKeyFields) {
        String conditionClause = uniqueKeyFields.stream().map(f -> String.format("%s = ?", this.quoteIdentifier((String)f))).collect(Collectors.joining(" AND "));
        return "DELETE FROM " + this.getFullTableName(schemaName, tableName) + " WHERE " + conditionClause;
    }

    public String getSysDatabase();

    default public String getMemStoreExistStatement(double threshold) {
        return "SELECT 1 FROM " + this.getSysDatabase() + ".GV$OB_MEMSTORE WHERE MEMSTORE_USED > MEMSTORE_LIMIT * " + threshold;
    }

    default public String getLegacyMemStoreExistStatement(double threshold) {
        return "SELECT 1 FROM " + this.getSysDatabase() + ".GV$MEMSTORE WHERE TOTAL > MEM_LIMIT * " + threshold;
    }

    public String getQueryTenantNameStatement();
}

