/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker;

import com.oceanbase.tools.datamocker.core.Dispatcher;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.schedule.AbstractScheduler;
import com.oceanbase.tools.datamocker.schedule.MockContext;

public class ObDataMocker {
    private final Dispatcher<TableTaskInfo> dispatcher;
    private final AbstractScheduler scheduler;

    public ObDataMocker(Dispatcher<TableTaskInfo> dispatcher, AbstractScheduler scheduler) {
        this.dispatcher = dispatcher;
        this.scheduler = scheduler;
    }

    public MockContext start() {
        if (this.scheduler == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Scheduler for ob mocker can not be null");
        }
        if (this.dispatcher == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Mock task dispatcher can not be null");
        }
        return this.scheduler.execute(this.dispatcher);
    }

    public int size() {
        if (this.dispatcher == null) {
            return -1;
        }
        return this.dispatcher.getConcurrent();
    }

    public int size(int index) throws Exception {
        if (index < 0 || this.dispatcher == null) {
            return -1;
        }
        return this.dispatcher.getTaskSize(index);
    }
}

