/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker;

import com.oceanbase.tools.datamocker.constraint.AbstractConstraint;
import com.oceanbase.tools.datamocker.core.Dispatcher;
import com.oceanbase.tools.datamocker.core.read.ColumnReader;
import com.oceanbase.tools.datamocker.core.task.AbstractMockerFactory;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.core.write.AbstractMockWriter;
import com.oceanbase.tools.datamocker.core.write.output.MockerFile;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.config.AbstractTableConfig;
import com.oceanbase.tools.datamocker.model.config.AbstractTaskConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.util.MockerBuffer;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMockerFactory
extends AbstractMockerFactory {
    private static final Logger log = LoggerFactory.getLogger(ObMockerFactory.class);

    public ObMockerFactory(AbstractTaskConfig taskConfig) {
        super(taskConfig);
    }

    @Override
    protected Dispatcher<TableTaskInfo> generate(AbstractTaskConfig taskConfig, String taskId) throws Throwable {
        String taskName = taskConfig.taskName() == null ? this.getTaskName() : taskConfig.taskName();
        List<? extends AbstractTableConfig> tableConfigs = taskConfig.tasks();
        Validate.notEmpty(tableConfigs, (String)"TaskConfig can not be empty for ObMockerFactory");
        ObModeType obModeType = taskConfig.obDialectType();
        Dispatcher<TableTaskInfo> dispatcher = new Dispatcher<TableTaskInfo>(tableConfigs.size(), taskName, taskId);
        for (int i = 0; i < tableConfigs.size(); ++i) {
            AbstractTableConfig tableConfig = tableConfigs.get(i);
            List<AbstractConstraint> constraints = this.getConstraints(tableConfig, taskConfig.obDialectType());
            List<ColumnReader<?>> columnReaders = this.getColumnReader(tableConfig, constraints);
            Map<String, AbstractDataType<?, ? extends Comparable<?>>> tableSchema = this.getTableSchema(tableConfig);
            MockerBuffer buffer = new MockerBuffer(tableSchema, tableConfig.maxBatchSize());
            TableTaskMetaData metaData = new TableTaskMetaData(tableSchema, tableConfig, obModeType, taskId, 0, i);
            DataSource dataSource = this.getDataSource(metaData.getTableTaskId());
            List<MockerFile> managers = this.getFileManager(metaData.getTableTaskId(), tableConfig);
            List<AbstractMockWriter> dataWriter = this.getDataWriter(tableConfig, buffer, managers, dataSource);
            TableTaskInfo bean = new TableTaskInfo(columnReaders, dataWriter, constraints, buffer, dataSource, managers, metaData);
            dispatcher.setObj(i, bean);
        }
        return dispatcher;
    }
}

