/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public abstract class AbstractConstraint {
    private final String constraintName;
    private final String database;
    private final String tableName;
    private final Map<String, Map<String, Integer>> tableName2ConstrantColumns;

    protected AbstractConstraint(String constraintName, String database, String tableName, Map<String, Map<String, Integer>> tableName2ConstrantColumns) {
        this.constraintName = constraintName;
        this.database = database;
        Map<String, Integer> columns = this.validateConsColumns(tableName, tableName2ConstrantColumns);
        this.tableName = tableName;
        this.tableName2ConstrantColumns = tableName2ConstrantColumns;
        this.initWithRows(columns, null);
    }

    protected AbstractConstraint(String constraintName, String database, String tableName, Map<String, Map<String, Integer>> tableName2ConstrantColumns, List<MockRowData> rows) {
        this.constraintName = constraintName;
        this.database = database;
        Map<String, Integer> columns = this.validateConsColumns(tableName, tableName2ConstrantColumns);
        this.tableName = tableName;
        this.tableName2ConstrantColumns = tableName2ConstrantColumns;
        this.initWithRows(columns, rows);
    }

    private Map<String, Integer> validateConsColumns(String table, Map<String, Map<String, Integer>> consColumns) {
        Validate.notNull((Object)table, (String)"Table name for AbstractConstraint can not be null");
        Validate.notEmpty(consColumns, (String)"Constraint columns can not be null or empty");
        Map<String, Integer> columns = consColumns.get(table);
        if (columns == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, String.format("Constraint columns for table \"%s\" can not be null or empty", table));
        }
        return columns;
    }

    public boolean check(MockRowData mockRowData) {
        if (mockRowData == null || mockRowData.columnNum() == 0) {
            return false;
        }
        Map<String, Integer> columns = this.validateConsColumns(this.tableName, this.tableName2ConstrantColumns);
        this.validateInput(columns, mockRowData);
        return this.doCheck(columns, mockRowData, false);
    }

    public boolean mark(MockRowData value) {
        if (value == null || value.columnNum() == 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Value can not be null for mark method");
        }
        Map<String, Integer> columns = this.validateConsColumns(this.tableName, this.tableName2ConstrantColumns);
        return this.doCheck(columns, value, true);
    }

    private void validateInput(Map<String, Integer> columns, MockRowData mockRowData) {
        Set<String> initCons = columns.keySet();
        Set<String> valueCons = mockRowData.columnNames();
        for (String column : initCons) {
            if (valueCons.contains(column)) continue;
            throw new MockerException(MockerError.PARAMETER_ERROR, String.format("Input constraint's columns must contain init constraint's columns, [%s]!=[%s]", String.join((CharSequence)",", initCons), String.join((CharSequence)",", valueCons)));
        }
    }

    public Map<String, Map<String, Integer>> columns() {
        return this.tableName2ConstrantColumns;
    }

    public String name() {
        return this.constraintName;
    }

    protected abstract void initWithRows(Map<String, Integer> var1, List<MockRowData> var2);

    protected abstract boolean doCheck(Map<String, Integer> var1, MockRowData var2, Boolean var3);
}

