/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.oceanbase.tools.datamocker.constraint.AbstractConstraint;
import com.oceanbase.tools.datamocker.constraint.MysqlValidation;
import com.oceanbase.tools.datamocker.constraint.OracleValidation;
import com.oceanbase.tools.datamocker.constraint.Validation;
import com.oceanbase.tools.datamocker.constraint.impl.UniqueConstraint;
import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.dbobject.ConstraintColumn;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import com.oceanbase.tools.datamocker.util.DbObjectNameUtil;
import com.oceanbase.tools.datamocker.util.SerializeUtil;
import com.oceanbase.tools.datamocker.util.SqlUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;

public abstract class ConstraintFactory {
    private static final String ORACLE_UNIQUE_CONSTRAINT_SQL = "select o.* from (select * from all_constraints where constraint_type='U') s inner join all_cons_columns o on s.OWNER=o.OWNER and s.CONSTRAINT_NAME=o.CONSTRAINT_NAME and s.TABLE_NAME=o.TABLE_NAME where s.OWNER=? and s.TABLE_NAME=?;";
    private static final String MYSQL_UNIQUE_CONSTRAINT_SQL = "select CONSTRAINT_SCHEMA as OWNER, CONSTRAINT_NAME,TABLE_NAME,COLUMN_NAME,ORDINAL_POSITION as POSITION from information_schema.key_column_usage where CONSTRAINT_NAME<>'PRIMARY' and CONSTRAINT_SCHEMA=? and TABLE_NAME=?; ";
    private static final String ORACLE_PRIMARY_CONSTRAINT_SQL = "select o.* from (select * from all_constraints where constraint_type='P') s inner join all_cons_columns o on s.OWNER=o.OWNER and s.CONSTRAINT_NAME=o.CONSTRAINT_NAME and s.TABLE_NAME=o.TABLE_NAME where s.OWNER=? and s.TABLE_NAME=?;";
    private static final String MYSQL_PRIMARY_CONSTRAINT_SQL = "select CONSTRAINT_SCHEMA as OWNER, CONSTRAINT_NAME,TABLE_NAME,COLUMN_NAME,ORDINAL_POSITION as POSITION from information_schema.key_column_usage where CONSTRAINT_NAME='PRIMARY' and CONSTRAINT_SCHEMA=? and TABLE_NAME=?; ";
    private static final String ORACLE_CHECK_CONSTRAINT_SQL = "select s.search_condition as search_condition, o.* from (select * from all_constraints where constraint_type='C') s inner join all_cons_columns o on s.OWNER=o.OWNER and s.CONSTRAINT_NAME=o.CONSTRAINT_NAME and s.TABLE_NAME=o.TABLE_NAME where s.OWNER=? and s.TABLE_NAME=?;";
    private static final String ORACLE_FOREIGN_CONSTRAINT_SQL = "select o.* from (select * from all_constraints where constraint_type='R') s inner join all_cons_columns o on s.OWNER=o.OWNER and s.CONSTRAINT_NAME=o.CONSTRAINT_NAME and s.TABLE_NAME=o.TABLE_NAME where s.OWNER=? and s.TABLE_NAME=?;";
    private static final Pattern NOT_NULL_PATTERN = Pattern.compile(".+ is not null", 2);
    private static final Map<String, ConstraintFactory> FACTORYNAME_2_FACTORYINSTANCE = new HashMap<String, ConstraintFactory>();
    private static final ConstraintFactory UNIQUE_CONSTRAINT = new ConstraintFactory(){

        @Override
        public List<AbstractConstraint> make(DataSource dataSource, ObModeType dialectType, String database, String tableName, Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType, int totalCount) throws Throwable {
            List<AbstractConstraint> constraints;
            if (ObModeType.OB_ORACLE.equals((Object)dialectType)) {
                constraints = 1.getConstraints(dataSource, ConstraintFactory.ORACLE_UNIQUE_CONSTRAINT_SQL, database, tableName, columnName2DataType, totalCount, ObModeType.OB_ORACLE, new OracleValidation());
            } else if (ObModeType.OB_MYSQL.equals((Object)dialectType)) {
                constraints = 1.getConstraints(dataSource, ConstraintFactory.MYSQL_UNIQUE_CONSTRAINT_SQL, database, tableName, columnName2DataType, totalCount, ObModeType.OB_MYSQL, new MysqlValidation());
            } else {
                throw new MockerException(MockerError.INVALID_OB_MODE);
            }
            ConstraintFactory.validateConstraints(constraints, tableName, columnName2DataType, totalCount);
            return constraints;
        }
    };
    private static final ConstraintFactory PRIMARY_CONSTRAINT = new ConstraintFactory(){

        @Override
        public List<AbstractConstraint> make(DataSource dataSource, ObModeType dialectType, String database, String tableName, Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType, int totalCount) throws Throwable {
            List<AbstractConstraint> constraints;
            if (ObModeType.OB_ORACLE.equals((Object)dialectType)) {
                constraints = 2.getConstraints(dataSource, ConstraintFactory.ORACLE_PRIMARY_CONSTRAINT_SQL, database, tableName, columnName2DataType, totalCount, ObModeType.OB_ORACLE, null);
            } else if (ObModeType.OB_MYSQL.equals((Object)dialectType)) {
                constraints = 2.getConstraints(dataSource, ConstraintFactory.MYSQL_PRIMARY_CONSTRAINT_SQL, database, tableName, columnName2DataType, totalCount, ObModeType.OB_MYSQL, null);
            } else {
                throw new MockerException(MockerError.INVALID_OB_MODE);
            }
            ConstraintFactory.validateConstraints(constraints, tableName, columnName2DataType, totalCount);
            return constraints;
        }
    };
    private static final ConstraintFactory CHECK_CONSTRAINT = new ConstraintFactory(){

        @Override
        public List<AbstractConstraint> make(DataSource dataSource, ObModeType dialectType, String database, String tableName, Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType, int totalCount) throws Throwable {
            Object[] params = new String[]{database, tableName};
            if (!ObModeType.OB_ORACLE.equals((Object)dialectType)) {
                if (ObModeType.OB_MYSQL.equals((Object)dialectType)) {
                    return null;
                }
                throw new MockerException(MockerError.INVALID_OB_MODE);
            }
            SqlUtil.executeQuery(dataSource, ConstraintFactory.ORACLE_CHECK_CONSTRAINT_SQL, params, new AbstractCallBack<ResultSet>(){

                @Override
                public void doOnSuccess(ResultSet result) throws Throwable {
                    List<ConstraintColumn> cols = SerializeUtil.getList(result, ConstraintColumn.class);
                    for (ConstraintColumn column : cols) {
                        Matcher matcher = NOT_NULL_PATTERN.matcher(column.getSearchCondition());
                        if (matcher.matches()) continue;
                        throw new MockerException(MockerError.NOT_SUPPORT_FEATURE, "Check constraint is not support yet, " + column.getSearchCondition());
                    }
                }

                @Override
                public void doOnFailure(ResultSet result, Throwable e) {
                    throw new MockerException(e);
                }
            });
            return null;
        }
    };
    private static final ConstraintFactory FOREIGN_CONSTRAINT = new ConstraintFactory(){

        @Override
        public List<AbstractConstraint> make(DataSource dataSource, ObModeType dialectType, String database, String tableName, Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType, int totalCount) throws Throwable {
            if (!ObModeType.OB_ORACLE.equals((Object)dialectType)) {
                if (ObModeType.OB_MYSQL.equals((Object)dialectType)) {
                    return null;
                }
                throw new MockerException(MockerError.INVALID_OB_MODE);
            }
            Object[] params = new String[]{database, tableName};
            SqlUtil.executeQuery(dataSource, ConstraintFactory.ORACLE_FOREIGN_CONSTRAINT_SQL, params, new AbstractCallBack<ResultSet>(){

                @Override
                public void doOnSuccess(ResultSet result) throws Throwable {
                    List<ConstraintColumn> cols = SerializeUtil.getList(result, ConstraintColumn.class);
                    if (cols.size() != 0) {
                        throw new MockerException(MockerError.NOT_SUPPORT_FEATURE, "Foreign constraint is not support yet");
                    }
                }

                @Override
                public void doOnFailure(ResultSet result, Throwable e) {
                    throw new MockerException(e);
                }
            });
            return null;
        }
    };

    public abstract List<AbstractConstraint> make(DataSource var1, ObModeType var2, String var3, String var4, Map<String, AbstractDataType<?, ? extends Comparable<?>>> var5, int var6) throws Throwable;

    private static void validateConstraints(List<AbstractConstraint> constraints, String tableName, Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType, int totalCount) {
        for (AbstractConstraint constraint : constraints) {
            Map<String, Integer> cols = constraint.columns().get(tableName);
            Set<String> colSet = cols.keySet();
            Long limitCount = 1L;
            for (String col : colSet) {
                AbstractDataType<?, Comparable<?>> dataType = columnName2DataType.get(col);
                Long typeLimit = dataType.distinctLimit();
                if (typeLimit > (long)totalCount) {
                    limitCount = totalCount;
                    break;
                }
                if ((limitCount = Long.valueOf(limitCount * dataType.distinctLimit())) <= (long)totalCount) continue;
                break;
            }
            if (limitCount >= (long)totalCount) continue;
            throw new MockerException(MockerError.PARAMETER_ERROR, String.format("The given data generator can only generate %d unique data for cols {%s}, but the goal is %d", limitCount.intValue(), String.join((CharSequence)", ", colSet), totalCount));
        }
    }

    protected static List<AbstractConstraint> getConstraints(final DataSource dataSource, String sql, final String database, final String tableName, final Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType, final int totalCount, final ObModeType obModeType, final Validation validation) throws Throwable {
        final ArrayList<AbstractConstraint> constraints = new ArrayList<AbstractConstraint>();
        SqlUtil.executeQuery(dataSource, sql, (Object[])new String[]{database, tableName}, new AbstractCallBack<ResultSet>(){

            @Override
            public void doOnSuccess(ResultSet result) throws Throwable {
                List<ConstraintColumn> cols = SerializeUtil.getList(result, ConstraintColumn.class);
                Map returnVal = ConstraintFactory.reduce(cols);
                Set entrySet = returnVal.entrySet();
                for (Map.Entry entry : entrySet) {
                    List colsList = (List)entry.getValue();
                    HashMap<String, Map<String, Integer>> columnMap = new HashMap<String, Map<String, Integer>>();
                    for (ConstraintColumn item : colsList) {
                        Number position;
                        if (validation != null) {
                            validation.validate(dataSource, item);
                        }
                        Map map = columnMap.getOrDefault(item.getTableName(), new HashMap());
                        if (item.getPosition() instanceof BigDecimal) {
                            position = (BigDecimal)item.getPosition();
                            map.putIfAbsent(item.getColumnName(), ((BigDecimal)position).intValue());
                        } else if (item.getPosition() instanceof Long) {
                            position = (Long)item.getPosition();
                            map.putIfAbsent(item.getColumnName(), ((Long)position).intValue());
                        } else {
                            throw new MockerException(MockerError.ILLEGAL_RETURN_VALUE, "Position's type is not support");
                        }
                        columnMap.put(item.getTableName(), map);
                    }
                    Integer existCount = ConstraintFactory.getTableRowCount(dataSource, tableName, obModeType);
                    UniqueConstraint constraint = new UniqueConstraint((String)entry.getKey(), database, tableName, columnMap, totalCount + existCount);
                    ConstraintFactory.initConstraint(dataSource, colsList, tableName, columnName2DataType, constraint, obModeType);
                    constraints.add(constraint);
                }
            }

            @Override
            public void doOnFailure(ResultSet result, Throwable e) {
                throw new MockerException(e);
            }
        });
        return constraints;
    }

    private static Integer getTableRowCount(DataSource dataSource, String table, ObModeType modeType) throws Throwable {
        Validate.notNull((Object)((Object)modeType), (String)"ObModeType can not be null for ConstraintFactory#getTableRowCount");
        String sql = String.format("select count(*) from \"%s\"; ", DbObjectNameUtil.doubleCharToEscape(table, '\"'));
        if (ObModeType.OB_MYSQL.equals((Object)modeType)) {
            sql = String.format("select count(*) from `%s`; ", DbObjectNameUtil.doubleCharToEscape(table, '`'));
        }
        final ArrayList returnVal = new ArrayList();
        SqlUtil.executeQuery(dataSource, sql, null, new AbstractCallBack<ResultSet>(){

            @Override
            public void doOnSuccess(ResultSet result) throws Throwable {
                while (result.next()) {
                    returnVal.add(result.getInt(1));
                }
            }

            @Override
            public void doOnFailure(ResultSet result, Throwable e) {
                throw new MockerException(e);
            }
        });
        return (Integer)returnVal.get(0);
    }

    private static void initConstraint(DataSource dataSource, List<ConstraintColumn> colsList, final String table, final Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType, final AbstractConstraint constraint, ObModeType obModeType) throws Throwable {
        Validate.notNull((Object)((Object)obModeType), (String)"OBModeType can not be null for ConstraintFactory#initConstraint");
        String columnStr = colsList.stream().map(column -> {
            if (ObModeType.OB_ORACLE.equals((Object)obModeType)) {
                return "\"" + DbObjectNameUtil.doubleCharToEscape(column.getColumnName(), '\"') + "\"";
            }
            return "`" + DbObjectNameUtil.doubleCharToEscape(column.getColumnName(), '`') + "`";
        }).collect(Collectors.joining(","));
        String querySql = String.format("select %s from \"%s\"; ", columnStr, DbObjectNameUtil.doubleCharToEscape(table, '\"'));
        if (ObModeType.OB_MYSQL.equals((Object)obModeType)) {
            querySql = String.format("select %s from `%s`; ", columnStr, DbObjectNameUtil.doubleCharToEscape(table, '`'));
        }
        SqlUtil.executeQuery(dataSource, querySql, null, new AbstractCallBack<ResultSet>(){

            @Override
            public void doOnSuccess(ResultSet result) throws Throwable {
                ResultSetMetaData metaData = result.getMetaData();
                int count = metaData.getColumnCount();
                while (result.next()) {
                    MockRowData mockRowData = new MockRowData();
                    for (int i = 0; i < count; ++i) {
                        String columnName = metaData.getColumnLabel(i + 1);
                        AbstractDataType dataType = (AbstractDataType)columnName2DataType.get(columnName);
                        if (dataType == null) {
                            throw new MockerException(MockerError.ILLEGAL_RETURN_VALUE, String.format("Data type for column \"%s.%s\" can not be null", table, columnName));
                        }
                        Object value = result.getObject(i + 1);
                        mockRowData.addMockColumn(dataType.convertFromJdbcObjectToMockColumn(columnName, value));
                    }
                    constraint.check(mockRowData);
                    constraint.mark(mockRowData);
                }
            }

            @Override
            public void doOnFailure(ResultSet result, Throwable e) {
                throw new MockerException(e);
            }
        });
    }

    private static Map<String, List<ConstraintColumn>> reduce(List<ConstraintColumn> cols) {
        HashMap<String, List<ConstraintColumn>> returnVal = new HashMap<String, List<ConstraintColumn>>();
        for (ConstraintColumn col : cols) {
            List list = returnVal.getOrDefault(col.getConstraintName(), new ArrayList());
            list.add(col);
            returnVal.put(col.getConstraintName(), list);
        }
        return returnVal;
    }

    public static ConstraintFactory getInstance(String factoryName) {
        ConstraintFactory returnVal = FACTORYNAME_2_FACTORYINSTANCE.get(factoryName);
        if (returnVal == null) {
            throw new MockerException(MockerError.UNKNOWN_DATA_TYPE);
        }
        return returnVal;
    }

    public static List<ConstraintFactory> listInstances() {
        ArrayList<ConstraintFactory> returnVal = new ArrayList<ConstraintFactory>();
        Set<Map.Entry<String, ConstraintFactory>> entries = FACTORYNAME_2_FACTORYINSTANCE.entrySet();
        for (Map.Entry<String, ConstraintFactory> entry : entries) {
            returnVal.add(entry.getValue());
        }
        return returnVal;
    }

    static {
        try {
            Field[] fields;
            for (Field field : fields = ConstraintFactory.class.getDeclaredFields()) {
                Object instance = field.get(ConstraintFactory.class);
                if (!Modifier.isStatic(field.getModifiers()) || !(instance instanceof ConstraintFactory)) continue;
                FACTORYNAME_2_FACTORYINSTANCE.putIfAbsent(field.getName(), (ConstraintFactory)instance);
            }
        }
        catch (IllegalAccessException e) {
            throw new MockerException(MockerError.UNKNOWN_ERROR, e.getMessage());
        }
    }
}

