/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.oceanbase.tools.datamocker.constraint.Validation;
import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.model.dbobject.ConstraintColumn;
import com.oceanbase.tools.datamocker.model.dbobject.TableColumn;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.util.SerializeUtil;
import com.oceanbase.tools.datamocker.util.SqlUtil;
import java.sql.ResultSet;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;

class MysqlValidation
implements Validation {
    private static final String MYSQL_VALIDATE_SQL = "select TABLE_SCHEMA as OWNER,TABLE_NAME,COLUMN_NAME,DATA_TYPE,NUMERIC_PRECISION as DATA_PRECISION,NUMERIC_SCALE as DATA_SCALE,GENERATION_EXPRESSION from information_schema.columns where TABLE_SCHEMA=? and TABLE_NAME=? and COLUMN_NAME=?";

    MysqlValidation() {
    }

    @Override
    public void validate(DataSource dataSource, ConstraintColumn cols) throws Throwable {
        Object[] params = new String[]{cols.getOwner(), cols.getTableName(), cols.getColumnName()};
        SqlUtil.executeQuery(dataSource, MYSQL_VALIDATE_SQL, params, new AbstractCallBack<ResultSet>(){

            @Override
            public void doOnSuccess(ResultSet result) throws Throwable {
                TableColumn tableCol = SerializeUtil.getObject(result, TableColumn.class);
                if (StringUtils.isNotBlank((String)tableCol.getExpression())) {
                    throw new MockerException(MockerError.NOT_SUPPORT_FEATURE, String.format("Virtual column \"%s.%s\" for constraint is not support yet", tableCol.getTableName(), tableCol.getColumnName()));
                }
            }

            @Override
            public void doOnFailure(ResultSet result, Throwable e) {
                throw new MockerException(e);
            }
        });
    }
}

