/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.oceanbase.tools.datamocker.constraint.Validation;
import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.model.dbobject.ConstraintColumn;
import com.oceanbase.tools.datamocker.model.dbobject.TableColumn;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.util.SerializeUtil;
import com.oceanbase.tools.datamocker.util.SqlUtil;
import java.sql.ResultSet;
import javax.sql.DataSource;

class OracleValidation
implements Validation {
    private static final String ORACLE_VALIDATE_SQL = "select * from all_tab_cols where owner=? and table_name=? and column_name=?";

    OracleValidation() {
    }

    @Override
    public void validate(DataSource dataSource, ConstraintColumn cols) throws Throwable {
        Object[] params = new String[]{cols.getOwner(), cols.getTableName(), cols.getColumnName()};
        SqlUtil.executeQuery(dataSource, ORACLE_VALIDATE_SQL, params, new AbstractCallBack<ResultSet>(){

            @Override
            public void doOnSuccess(ResultSet result) throws Throwable {
                TableColumn tableCol = SerializeUtil.getObject(result, TableColumn.class);
                if ("YES".equals(tableCol.getVirtualColumn())) {
                    throw new MockerException(MockerError.NOT_SUPPORT_FEATURE, String.format("Virtual column \"%s.%s\" for constraint is not support yet", tableCol.getTableName(), tableCol.getColumnName()));
                }
            }

            @Override
            public void doOnFailure(ResultSet result, Throwable e) {
                throw new MockerException(e);
            }
        });
    }
}

