/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint.impl;

import com.oceanbase.tools.datamocker.constraint.AbstractConstraint;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import com.oceanbase.tools.datamocker.util.DuplicatedJudger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueConstraint
extends AbstractConstraint {
    private static final Logger log = LoggerFactory.getLogger(UniqueConstraint.class);
    private final DuplicatedJudger judger;
    private List<String> sortedList;

    public UniqueConstraint(String constraintName, String database, String tableName, Map<String, Map<String, Integer>> consColumns, int count) {
        super(constraintName, database, tableName, consColumns);
        Validate.isTrue((count > 0 ? 1 : 0) != 0, (String)"Count for UniqueConstraint can not be negative");
        this.judger = new DuplicatedJudger(count);
    }

    public UniqueConstraint(String constraintName, String database, String tableName, Map<String, Map<String, Integer>> consColumns, List<MockRowData> rows, int count) {
        super(constraintName, database, tableName, consColumns, rows);
        Validate.isTrue((count > 0 ? 1 : 0) != 0, (String)"Count for UniqueConstraint can not be negative");
        if (rows != null && rows.size() != 0) {
            this.judger = new DuplicatedJudger(rows.size() + count);
            for (MockRowData row : rows) {
                String result = this.convertFromRowDataToStringListData(row);
                this.judger.add(result);
            }
        } else {
            this.judger = new DuplicatedJudger(count);
        }
    }

    @Override
    protected void initWithRows(Map<String, Integer> columns, List<MockRowData> rows) {
        this.sortedList = UniqueConstraint.sortMapByValue(columns);
    }

    @Override
    protected boolean doCheck(Map<String, Integer> columns, MockRowData value, Boolean markable) {
        String checkValue = this.convertFromRowDataToStringListData(value);
        if (this.judger.contains(checkValue)) {
            return false;
        }
        if (markable.booleanValue() && !this.judger.add(checkValue)) {
            log.warn("Fail to add row to DuplicatedJudger, row={}", (Object)checkValue);
        }
        return true;
    }

    private String convertFromRowDataToStringListData(MockRowData mockRowData) {
        String columnList = String.join((CharSequence)",", this.sortedList);
        return this.sortedList.stream().map(s -> {
            MockColumnData<?> mockColumn = mockRowData.getMockColumn((String)s);
            if (mockColumn == null) {
                throw new MockerException(MockerError.OPERATION_FAILURE, String.format("Data for unique constraint have to have same column list \"%s\"", columnList));
            }
            return mockColumn.toDisgestString();
        }).collect(Collectors.joining(","));
    }

    private static List<String> sortMapByValue(Map<String, Integer> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Map.Entry<String, Integer>> entryList = new ArrayList<Map.Entry<String, Integer>>(map.entrySet());
        entryList.sort(Map.Entry.comparingByValue());
        return entryList.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

