/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.read;

import com.oceanbase.tools.datamocker.core.read.AbstractMockReader;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnReader<T>
extends AbstractMockReader<T> {
    private static final Logger log = LoggerFactory.getLogger(ColumnReader.class);
    private final AbstractDataType<T, ? extends Comparable<?>> dataType;
    private final String columnName;
    private final String groupId;

    public ColumnReader(AbstractDataType<T, ? extends Comparable<?>> dataType, String columnName, String groupId) {
        Validate.notNull(dataType, (String)"DataType can not be null for ColumnReader");
        Validate.notNull((Object)columnName, (String)"ColumnName can not be null for ColumnReader");
        this.dataType = dataType;
        this.columnName = columnName;
        this.groupId = groupId;
    }

    @Override
    public MockColumnData<T> read() {
        return new MockColumnData<T>(this.columnName, this.dataType, this.dataType.acquire());
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

