/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataPipe<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataPipe.class);
    private volatile boolean closed = false;
    private int maxRetained = Integer.MAX_VALUE;
    private final Lock writeLock = new ReentrantLock();
    private final Lock readLock = new ReentrantLock();
    private final Condition notFullCondition = this.writeLock.newCondition();
    private final Condition notEmptyCondition = this.readLock.newCondition();

    public AbstractDataPipe(int maxRetained) {
        if (maxRetained > 0) {
            this.maxRetained = maxRetained;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T element, long timeout, TimeUnit timeUnit) throws InterruptedException {
        long remainingTimeout;
        Validate.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout for pipeline write can not be negative");
        Validate.notNull((Object)((Object)timeUnit), (String)"Timeout can not be null");
        long methodStart = System.currentTimeMillis();
        long timeoutMillSecs = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        if (this.isClosed()) {
            throw new MockerException(MockerError.OPERATION_FAILURE, "Data pipe has been closed");
        }
        if (element == null) {
            throw new NullPointerException("Input element can not be null");
        }
        this.writeLock.lock();
        try {
            remainingTimeout = timeoutMillSecs - (System.currentTimeMillis() - methodStart);
            while (this.size() >= (long)this.maxRetained && remainingTimeout > 0L) {
                log.debug("Start write waiting, currentSize={}, maxRetained={}, threadName={}", new Object[]{this.size(), this.maxRetained, Thread.currentThread().getName()});
                this.notFullCondition.await(remainingTimeout, TimeUnit.MILLISECONDS);
                remainingTimeout = timeoutMillSecs - (System.currentTimeMillis() - methodStart);
                log.debug("End write waiting, currentSize={}, maxRetained={}, threadName={}", new Object[]{this.size(), this.maxRetained, Thread.currentThread().getName()});
            }
            if (remainingTimeout <= 0L) {
                log.warn("Data pipeline write operation timed out and will return, currentSize={}, maxRetained={}, threadName={}", new Object[]{this.size(), this.maxRetained, Thread.currentThread().getName()});
                return;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        remainingTimeout = timeoutMillSecs - (System.currentTimeMillis() - methodStart);
        this.doWrite(element, remainingTimeout, TimeUnit.MILLISECONDS);
        this.readLock.lock();
        try {
            if (this.size() > 0L) {
                this.notEmptyCondition.signalAll();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void write(T element) throws InterruptedException {
        this.write(element, Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    protected abstract void doWrite(T var1, long var2, TimeUnit var4) throws InterruptedException;

    public T read() throws InterruptedException {
        return this.read(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long remainingTimeout;
        Validate.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout for pipeline read can not be negative");
        Validate.notNull((Object)((Object)timeUnit), (String)"Timeout can not be null");
        long methodStart = System.currentTimeMillis();
        long timeoutMillSecs = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        this.readLock.lock();
        try {
            remainingTimeout = timeoutMillSecs - (System.currentTimeMillis() - methodStart);
            while (this.size() <= 0L && remainingTimeout > 0L) {
                log.debug("Start read waiting, currentSize={}, maxRetained={}, threadName={}", new Object[]{this.size(), this.maxRetained, Thread.currentThread().getName()});
                this.notEmptyCondition.await(remainingTimeout, TimeUnit.MILLISECONDS);
                remainingTimeout = timeoutMillSecs - (System.currentTimeMillis() - methodStart);
                log.debug("End read waiting, currentSize={}, maxRetained={}, threadName={}", new Object[]{this.size(), this.maxRetained, Thread.currentThread().getName()});
            }
            if (remainingTimeout <= 0L) {
                log.warn("Data pipeline read operation timed out and will return, currentSize={}, maxRetained={}, threadName={}", new Object[]{this.size(), this.maxRetained, Thread.currentThread().getName()});
                T t = null;
                return t;
            }
        }
        finally {
            this.readLock.unlock();
        }
        remainingTimeout = timeoutMillSecs - (System.currentTimeMillis() - methodStart);
        T returnVal = this.doRead(remainingTimeout, TimeUnit.MILLISECONDS);
        this.writeLock.lock();
        try {
            if (this.size() < (long)this.maxRetained) {
                this.notFullCondition.signalAll();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return returnVal;
    }

    protected abstract T doRead(long var1, TimeUnit var3) throws InterruptedException;

    public abstract long size();

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() {
        this.closed = true;
    }
}

