/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.ObDataMocker;
import com.oceanbase.tools.datamocker.constraint.AbstractConstraint;
import com.oceanbase.tools.datamocker.constraint.ConstraintFactory;
import com.oceanbase.tools.datamocker.core.Dispatcher;
import com.oceanbase.tools.datamocker.core.read.ColumnReader;
import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.core.task.AbstractDataPipe;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.core.write.AbstractMockWriter;
import com.oceanbase.tools.datamocker.core.write.JdbcWriter;
import com.oceanbase.tools.datamocker.core.write.SqlScriptWriter;
import com.oceanbase.tools.datamocker.core.write.output.MockerDataSource;
import com.oceanbase.tools.datamocker.core.write.output.MockerFile;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.config.AbstractColumnConfig;
import com.oceanbase.tools.datamocker.model.config.AbstractTableConfig;
import com.oceanbase.tools.datamocker.model.config.AbstractTaskConfig;
import com.oceanbase.tools.datamocker.model.config.model.DataBaseConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.enums.ScriptType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.schedule.AbstractScheduler;
import com.oceanbase.tools.datamocker.schedule.impl.DefaultScheduler;
import com.oceanbase.tools.datamocker.util.DbObjectNameUtil;
import com.oceanbase.tools.datamocker.util.MockDataPipe;
import com.oceanbase.tools.datamocker.util.MockerBuffer;
import com.oceanbase.tools.datamocker.util.SqlUtil;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractMockerFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractMockerFactory.class);
    private final AbstractTaskConfig taskConfig;
    private MockerDataSource innerDatasource = null;
    private final Map<String, DataSource> taskId2DataSource;
    private final Map<String, List<MockerFile>> taskId2MockerFiles;

    public AbstractMockerFactory(AbstractTaskConfig taskConfig) {
        Validate.notNull((Object)taskConfig, (String)"TaskConfig can not be null for AbstractMockerFactory");
        this.taskConfig = taskConfig;
        this.taskId2DataSource = new HashMap<String, DataSource>();
        this.taskId2MockerFiles = new HashMap<String, List<MockerFile>>();
    }

    private boolean validateDbConfig(DataBaseConfig dbConfig) {
        if (dbConfig == null) {
            return false;
        }
        return !StringUtils.isBlank((String)dbConfig.getUser()) && !StringUtils.isBlank((String)dbConfig.getHost());
    }

    public ObDataMocker create() {
        return this.create(new DefaultScheduler(this.taskConfig.maxConnection()));
    }

    public ObDataMocker create(AbstractScheduler scheduler) {
        Validate.notNull((Object)scheduler, (String)"Scheduler can not be null for AbstractMockerFactory#create");
        try {
            String taskId = UUID.randomUUID().toString().toUpperCase();
            MDC.put((String)"mocktask.workspace", (String)taskId);
            if (this.validateDbConfig(this.taskConfig.dbConfig()) && this.innerDatasource == null) {
                this.innerDatasource = new MockerDataSource(this.taskConfig.dbConfig(), 3, 5, 3, this.taskConfig.dbConfig().getConnectParam());
            }
            for (AbstractTableConfig abstractTableConfig : this.taskConfig.tasks()) {
                this.validateTableByJdbc(abstractTableConfig.schemaName(), abstractTableConfig.tableName());
            }
            Dispatcher<TableTaskInfo> dispatcher = this.generate(this.taskConfig, taskId);
            this.innerDatasource.clear();
            return new ObDataMocker(dispatcher, scheduler);
        }
        catch (Throwable e) {
            throw new MockerException(e);
        }
    }

    protected abstract Dispatcher<TableTaskInfo> generate(AbstractTaskConfig var1, String var2) throws Throwable;

    protected void validateTableByJdbc(final String schema, final String table) throws Throwable {
        String sql;
        if (this.innerDatasource == null) {
            return;
        }
        if (ObModeType.OB_ORACLE.equals((Object)this.taskConfig.obDialectType())) {
            sql = String.format("select count(*) from \"%s\".\"%s\"", DbObjectNameUtil.doubleCharToEscape(schema, '\"'), DbObjectNameUtil.doubleCharToEscape(table, '\"'));
        } else if (ObModeType.OB_MYSQL.equals((Object)this.taskConfig.obDialectType())) {
            sql = String.format("select count(*) from `%s`.`%s`", DbObjectNameUtil.doubleCharToEscape(schema, '`'), DbObjectNameUtil.doubleCharToEscape(table, '`'));
        } else {
            throw new MockerException(MockerError.INVALID_OB_MODE);
        }
        SqlUtil.executeQuery(this.innerDatasource, sql, null, new AbstractCallBack<ResultSet>(){

            @Override
            public void doOnSuccess(ResultSet result) {
                log.info("Verify the existence of the database table successfully, schema={}, table={}", (Object)schema, (Object)table);
            }

            @Override
            public void doOnFailure(ResultSet result, Throwable e) {
                log.error("Fail to verify the existence of database table, schema={}, table={}", new Object[]{schema, table, e});
                throw new MockerException(MockerError.OPERATION_FAILURE, e.getMessage());
            }
        });
    }

    protected Map<String, AbstractDataType<?, ? extends Comparable<?>>> getTableSchema(AbstractTableConfig tableConfig) {
        HashMap columnName2DataType = new HashMap();
        for (AbstractColumnConfig abstractColumnConfig : tableConfig.columns()) {
            columnName2DataType.putIfAbsent(abstractColumnConfig.columnName(), abstractColumnConfig.columnType());
        }
        return columnName2DataType;
    }

    protected List<AbstractConstraint> getConstraints(AbstractTableConfig tableConfig, ObModeType dialectType) throws Throwable {
        if (tableConfig.constraints() != null) {
            return tableConfig.constraints();
        }
        if (this.innerDatasource == null) {
            return Collections.emptyList();
        }
        Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType = this.getTableSchema(tableConfig);
        List<ConstraintFactory> factories = ConstraintFactory.listInstances();
        ArrayList<AbstractConstraint> returnVal = new ArrayList<AbstractConstraint>();
        for (ConstraintFactory factory : factories) {
            List<AbstractConstraint> customConstraint = factory.make(this.innerDatasource, dialectType, tableConfig.schemaName(), tableConfig.tableName(), columnName2DataType, tableConfig.maxCount().intValue());
            if (customConstraint == null) continue;
            returnVal.addAll(customConstraint);
        }
        return returnVal;
    }

    protected synchronized DataSource getDataSource(String tableTaskId) throws SQLException {
        if (tableTaskId == null) {
            return null;
        }
        DataSource dataSource = this.taskId2DataSource.get(tableTaskId);
        if (dataSource != null) {
            return dataSource;
        }
        if (!this.validateDbConfig(this.taskConfig.dbConfig())) {
            return null;
        }
        HashMap<String, String> realParam = new HashMap<String, String>();
        realParam.put("autoReconnect", "true");
        realParam.put("rewriteBatchedStatements", "true");
        realParam.put("emulateUnsupportedPstmts", "false");
        Map<String, String> param = this.taskConfig.dbConfig().getConnectParam();
        if (param != null) {
            Set<Map.Entry<String, String>> entries = param.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                realParam.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        dataSource = new MockerDataSource(this.taskConfig.dbConfig(), this.taskConfig.minConnection(), this.taskConfig.maxConnection(), this.taskConfig.connectionIncreasementStep(), realParam);
        this.taskId2DataSource.putIfAbsent(tableTaskId, dataSource);
        return dataSource;
    }

    protected synchronized List<MockerFile> getFileManager(String tableTaskId, AbstractTableConfig tableConfig) throws IOException {
        Validate.notEmpty((String)tableTaskId, (String)"Table task id can not be null");
        Validate.notNull((Object)tableConfig, (String)"Table config can not be null");
        List<MockerFile> returnVal = this.taskId2MockerFiles.get(tableTaskId);
        if (returnVal == null) {
            returnVal = new LinkedList<MockerFile>();
            this.taskId2MockerFiles.put(tableTaskId, returnVal);
            for (ScriptType scriptType : tableConfig.scriptType()) {
                String location = tableConfig.dataWriteLocation(scriptType);
                MockerFile fileManager = new MockerFile(location, scriptType, true);
                returnVal.add(fileManager);
            }
        }
        return returnVal;
    }

    protected List<AbstractMockWriter> getDataWriter(AbstractTableConfig tableConfig, MockerBuffer buffer, List<MockerFile> managers, DataSource dataSource) {
        Validate.notNull(managers, (String)"Mocker file manager list can not be null");
        LinkedList<AbstractMockWriter> dataWriters = new LinkedList<AbstractMockWriter>();
        for (MockerFile manager : managers) {
            SqlScriptWriter writer = new SqlScriptWriter(manager, this.taskConfig.obDialectType(), tableConfig.schemaName(), tableConfig.tableName());
            dataWriters.add(writer);
        }
        if (dataSource == null) {
            return dataWriters;
        }
        JdbcWriter writer = new JdbcWriter(dataSource, this.taskConfig.obDialectType(), tableConfig.schemaName(), tableConfig.tableName());
        dataWriters.add(writer);
        HashMap<String, AbstractDataPipe> groupId2DataPipe = new HashMap<String, AbstractDataPipe>();
        for (AbstractMockWriter item : dataWriters) {
            AbstractDataPipe dataPipe = groupId2DataPipe.computeIfAbsent(item.groupId(), s -> new MockDataPipe(tableConfig.maxRetainedCount()));
            item.register(dataPipe);
            buffer.register(dataPipe);
        }
        return dataWriters;
    }

    protected List<ColumnReader<?>> getColumnReader(AbstractTableConfig tableConfig, List<AbstractConstraint> constraints) {
        List<? extends AbstractColumnConfig> columnConfigs = tableConfig.columns();
        ArrayList<HashSet<String>> colGroupList = new ArrayList<HashSet<String>>();
        for (AbstractConstraint constraint : constraints) {
            Map<String, Integer> cols = constraint.columns().get(tableConfig.tableName());
            Set<String> set = cols.keySet();
            colGroupList.add(new HashSet<String>(set));
        }
        int length = colGroupList.size();
        for (int i = 0; i < length; ++i) {
            for (int j = i + 1; j < length; ++j) {
                HashSet hashSet = new HashSet((Collection)colGroupList.get(i));
                hashSet.retainAll((Collection)colGroupList.get(j));
                if (hashSet.size() == 0) continue;
                ((Set)colGroupList.get(i)).addAll((Collection)colGroupList.get(j));
                colGroupList.remove(j);
                --length;
                --j;
            }
        }
        HashMap<String, Set> groupMap = new HashMap<String, Set>();
        for (Set set : colGroupList) {
            groupMap.put(UUID.randomUUID().toString(), set);
        }
        LinkedList returnValue = new LinkedList();
        for (AbstractColumnConfig abstractColumnConfig : columnConfigs) {
            AbstractDataType<?, ? extends Comparable<?>> dataType = abstractColumnConfig.columnType();
            String columnName = abstractColumnConfig.columnName();
            Set entrySet = groupMap.entrySet();
            ColumnReader reader = null;
            for (Map.Entry item : entrySet) {
                String groupId = (String)item.getKey();
                if (!((Set)item.getValue()).contains(columnName)) continue;
                reader = new ColumnReader(dataType, columnName, groupId);
                break;
            }
            if (reader == null) {
                reader = new ColumnReader(dataType, columnName, UUID.randomUUID().toString());
            }
            returnValue.add(reader);
        }
        return returnValue;
    }

    protected String getTaskName() {
        TimeZone timeZone = TimeZone.getDefault();
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSS");
        dateFormat.setTimeZone(timeZone);
        return "datamock_" + dateFormat.format(date);
    }
}

