/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.core.read.ColumnReader;
import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.core.write.AbstractMockWriter;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.schedule.AbstractMockTask;
import com.oceanbase.tools.datamocker.schedule.MockExecutorService;
import com.oceanbase.tools.datamocker.schedule.impl.GenerateDataTask;
import com.oceanbase.tools.datamocker.schedule.impl.MockDataAfterTask;
import com.oceanbase.tools.datamocker.schedule.impl.MockDataBeforeTask;
import com.oceanbase.tools.datamocker.schedule.impl.OutputDataTask;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTask {
    private static final Logger log = LoggerFactory.getLogger(TableTask.class);
    private final AbstractMockTask beforeTask;
    private final AbstractMockTask afterTask;
    private final List<AbstractMockTask> businessTasks;
    private final String tableTaskId;
    private final TableTaskContext context;
    private final AtomicInteger counter = new AtomicInteger(0);

    public TableTask(TableTaskInfo taskBean, Set<Set<String>> columnGroups, Map<Set<String>, Integer> dataGroups, String taskName, int index) {
        this.tableTaskId = taskBean.getMetaData().getTableTaskId();
        this.context = new TableTaskContext(taskBean, taskName, index);
        this.businessTasks = new ArrayList<AbstractMockTask>();
        for (Set<String> groupSet : columnGroups) {
            LinkedList tmpList = new LinkedList();
            for (String item : groupSet) {
                for (ColumnReader<?> reader : taskBean.getColumnReaders()) {
                    if (!item.equals(reader.groupId())) continue;
                    tmpList.add(reader);
                }
            }
            GenerateDataTask genTask = new GenerateDataTask(taskBean.getMetaData(), this.context, taskBean.getBuffer(), tmpList, taskBean.getConstraints());
            this.businessTasks.add(genTask);
        }
        taskBean.getBuffer().setConcurrent(this.businessTasks.size());
        Set<Map.Entry<Set<String>, Integer>> entrySet = dataGroups.entrySet();
        for (Map.Entry<Set<String>, Integer> entry : entrySet) {
            Set<String> groupId = entry.getKey();
            LinkedList<AbstractMockWriter> writers = new LinkedList<AbstractMockWriter>();
            for (String id : groupId) {
                for (AbstractMockWriter item : taskBean.getDataWriters()) {
                    if (!item.groupId().equals(id)) continue;
                    writers.add(item);
                }
            }
            if (entry.getValue() <= 0) {
                throw new MockerException(MockerError.PARAMETER_ERROR, "Task size can not be equal to or smaller than zero");
            }
            for (int i = 0; i < entry.getValue(); ++i) {
                OutputDataTask outputTask = new OutputDataTask(taskBean.getMetaData(), this.context, writers);
                this.businessTasks.add(outputTask);
            }
        }
        this.beforeTask = new MockDataBeforeTask(taskBean.getMetaData(), this.context, taskBean.getDataSource());
        this.afterTask = new MockDataAfterTask(taskBean.getMetaData(), this.context, taskBean.getDataSource());
    }

    public void init(final MockExecutorService service, final AbstractCallBack<TableTaskContext> callBack) {
        Validate.notNull(callBack, (String)"CallBack can not be null for TableTask#init");
        Validate.notNull((Object)service, (String)"ExecutorService can not be null for TableTask#init");
        final TableTask thisTaskBean = this;
        this.beforeTask.bind(new AbstractCallBack<TableTaskContext>(){

            @Override
            public void doOnSuccess(TableTaskContext param) throws Throwable {
                log.info("The Mock data preparation task has been completed, and the business task has begun to run, taskStatus={}", (Object)MockTaskStatus.RUNNING);
                for (AbstractMockTask task : thisTaskBean.businessTasks) {
                    if (task instanceof GenerateDataTask) {
                        ((GenerateDataTask)task).reloadConstraints(param.getConstraints());
                    }
                    if (!service.isShutdown() && !TableTask.this.context.isShutdown()) {
                        service.submitCallable(task, param);
                        continue;
                    }
                    log.warn("The thread pool has been closed, and the mock data task will exit");
                    callBack.onFailure(param, new MockerException("Thread pool has been shutdown"));
                }
            }

            @Override
            public void doOnFailure(TableTaskContext param, Throwable e) throws Throwable {
                log.error("The mock data preparation task fails to execute, and the business task will not be executed, taskStatus={}", (Object)param.getStatus(), (Object)e);
                callBack.onFailure(param, e);
            }
        });
        for (AbstractMockTask businessTask : this.businessTasks) {
            if (businessTask instanceof GenerateDataTask) {
                businessTask.bind(new AbstractCallBack<TableTaskContext>(){

                    @Override
                    public void doOnSuccess(TableTaskContext param) throws Throwable {
                        log.info("Data generation task completed, numberOfDataGeneration={}, taskStatus={}", (Object)param.getTotalDataGenerateCount(), (Object)param.getStatus());
                        TableTask.this.startAfterTask(service, callBack);
                    }

                    @Override
                    public void doOnFailure(TableTaskContext param, Throwable e) throws Throwable {
                        log.error("Data generation task execution failed, taskStatus={}", (Object)param.getStatus(), (Object)e);
                        TableTask.this.startAfterTask(service, callBack);
                    }
                });
                continue;
            }
            if (businessTask instanceof OutputDataTask) {
                businessTask.bind(new AbstractCallBack<TableTaskContext>(){

                    @Override
                    public void doOnSuccess(TableTaskContext param) throws Throwable {
                        StringBuilder builder = new StringBuilder();
                        for (Map.Entry<String, Long> item : param.getWriterName2writeCount().entrySet()) {
                            builder.append("{\"").append(item.getKey()).append("\" : ").append(item.getValue()).append("} ");
                        }
                        log.info("Data writing task is completed, taskStatus={}, writingInfo={}", (Object)param.getStatus(), (Object)builder.toString());
                        TableTask.this.startAfterTask(service, callBack);
                    }

                    @Override
                    public void doOnFailure(TableTaskContext param, Throwable e) throws Throwable {
                        log.error("Fail to execute data writing task, taskStatus={}", (Object)param.getStatus(), (Object)e);
                        TableTask.this.startAfterTask(service, callBack);
                    }
                });
                continue;
            }
            throw new MockerException(MockerError.PARAMETER_ERROR, "Unknown business task type");
        }
        this.afterTask.bind(new AbstractCallBack<TableTaskContext>(){

            @Override
            public void doOnSuccess(TableTaskContext param) throws Throwable {
                if (!MockTaskStatus.FAILED.equals((Object)thisTaskBean.getStatus()) && !MockTaskStatus.CANCELED.equals((Object)thisTaskBean.getStatus())) {
                    param.setStatus(MockTaskStatus.SUCCESS);
                }
                log.info("The mock data destruction task is executed successfully, currentRecordNum={}, taskStatus={}", (Object)param.getCurrentRecordNum(), (Object)param.getStatus());
                callBack.onSuccess(param);
            }

            @Override
            public void doOnFailure(TableTaskContext param, Throwable e) throws Throwable {
                log.error("Failed to execute simulation data destruction task, taskStatus={}", (Object)param.getStatus(), (Object)e);
                callBack.onFailure(param, e);
            }
        });
    }

    private void startAfterTask(MockExecutorService service, AbstractCallBack<TableTaskContext> callBack) throws Throwable {
        if (this.counter.incrementAndGet() == this.businessTasks.size()) {
            log.info("All mock data business tasks are completed, and the destructuring task is started");
            if (!service.isShutdown() && !this.context.isShutdown()) {
                service.submitCallable(this.afterTask, this.context);
            } else {
                log.warn("The thread pool has been closed, and the mock data task will exit");
                callBack.onFailure(this.context, new MockerException("Thread pool has been shutdown"));
            }
        }
    }

    public MockTaskStatus getStatus() {
        return this.context.getStatus();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableTask that = (TableTask)o;
        return this.tableTaskId.equals(that.tableTaskId);
    }

    public int hashCode() {
        return this.tableTaskId.hashCode();
    }

    public AbstractMockTask getBeforeTask() {
        return this.beforeTask;
    }

    public String getTableTaskId() {
        return this.tableTaskId;
    }

    public TableTaskContext getContext() {
        return this.context;
    }
}

