/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.constraint.AbstractConstraint;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.core.write.output.MockerFile;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;

public class TableTaskContext {
    private final String taskName;
    private final String tableTaskId;
    private final Long batchSize;
    private volatile MockTaskStatus status;
    private final Long totalCount;
    private final Map<String, AbstractDataType<?, ? extends Comparable<?>>> tableSchema;
    private final String tableName;
    private final String schema;
    private final Boolean truncate;
    private final Long timeoutMilliseconds;
    private final List<Future<?>> handlers;
    private final Map<String, Long> writerName2writeCount;
    private Long totalDataGenerateCount = null;
    private Long currentRecordNum;
    private final DataSource dataSource;
    private final List<MockerFile> fileManagers;
    private final ObModeType dialectType;
    private final int topIndex;
    private volatile boolean shutdown;
    private final List<AbstractConstraint> constraints = new LinkedList<AbstractConstraint>();

    public TableTaskContext(TableTaskInfo taskInfo, String taskName, int index) {
        Validate.notNull((Object)taskInfo, (String)"TaskInfo can not be null for TableTaskContext");
        TableTaskMetaData metaData = taskInfo.getMetaData();
        this.tableTaskId = metaData.getTableTaskId();
        this.taskName = taskName;
        this.batchSize = metaData.getBatchSize();
        this.totalCount = metaData.getTotalCount();
        this.tableSchema = metaData.getTableSchema();
        this.tableName = metaData.getTableName();
        this.schema = metaData.getSchema();
        this.truncate = metaData.getShouldTruncate();
        this.timeoutMilliseconds = metaData.getTimeoutMilliseconds();
        this.status = MockTaskStatus.CREATED;
        this.handlers = new LinkedList();
        this.writerName2writeCount = new HashMap<String, Long>();
        this.dataSource = taskInfo.getDataSource();
        this.fileManagers = taskInfo.getFileManagers();
        this.dialectType = metaData.getDialectType();
        this.topIndex = index;
    }

    public void appendHandle(Future<?> handle) {
        if (handle == null) {
            return;
        }
        if (MockTaskStatus.RUNNING.equals((Object)this.status)) {
            this.handlers.add(handle);
        }
    }

    public boolean shutdown() {
        this.status = MockTaskStatus.CANCELED;
        return this.terminate();
    }

    public synchronized boolean terminate() {
        this.shutdown = true;
        boolean returnVal = Boolean.TRUE;
        for (Future<?> task : this.handlers) {
            if (task.isCancelled() || task.isDone()) continue;
            returnVal &= task.cancel(true);
        }
        return returnVal;
    }

    public synchronized void appendWriteInfo(Pair<String, Long> result) {
        if (result == null || result.getKey() == null || result.getValue() == null) {
            return;
        }
        Long value = this.writerName2writeCount.getOrDefault(result.getKey(), 0L);
        this.writerName2writeCount.put(result.getKey(), value + result.getValue());
    }

    public synchronized void appendDataGenInfo(Long result) {
        if (result == null) {
            return;
        }
        if (this.totalDataGenerateCount == null) {
            this.totalDataGenerateCount = result;
        } else if (!this.totalDataGenerateCount.equals(result)) {
            throw new MockerException(MockerError.OPERATION_FAILURE, "All column readers have to generate same number of data");
        }
    }

    public synchronized void setStatus(MockTaskStatus status) {
        this.status = status;
    }

    public double getProgress() {
        if (this.totalCount != 0L && this.writerName2writeCount.size() != 0) {
            Collection<Long> values = this.writerName2writeCount.values();
            Iterator<Long> iter = values.iterator();
            double totalProgress = 0.0;
            while (iter.hasNext()) {
                Long value = iter.next();
                totalProgress += value.doubleValue() / (double)this.totalCount.longValue();
            }
            return totalProgress / (double)this.writerName2writeCount.size();
        }
        return 0.0;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTableTaskId() {
        return this.tableTaskId;
    }

    public Long getBatchSize() {
        return this.batchSize;
    }

    public MockTaskStatus getStatus() {
        return this.status;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public Map<String, AbstractDataType<?, ? extends Comparable<?>>> getTableSchema() {
        return this.tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public Boolean getTruncate() {
        return this.truncate;
    }

    public Long getTimeoutMilliseconds() {
        return this.timeoutMilliseconds;
    }

    public Map<String, Long> getWriterName2writeCount() {
        return this.writerName2writeCount;
    }

    public Long getTotalDataGenerateCount() {
        return this.totalDataGenerateCount;
    }

    public Long getCurrentRecordNum() {
        return this.currentRecordNum;
    }

    public void setCurrentRecordNum(Long currentRecordNum) {
        this.currentRecordNum = currentRecordNum;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<MockerFile> getFileManagers() {
        return this.fileManagers;
    }

    public ObModeType getDialectType() {
        return this.dialectType;
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public List<AbstractConstraint> getConstraints() {
        return this.constraints;
    }
}

