/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.constraint.AbstractConstraint;
import com.oceanbase.tools.datamocker.core.read.ColumnReader;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.core.write.AbstractMockWriter;
import com.oceanbase.tools.datamocker.core.write.output.MockerFile;
import com.oceanbase.tools.datamocker.util.MockerBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;

public class TableTaskInfo {
    private final TableTaskMetaData metaData;
    private final MockerBuffer buffer;
    private final List<ColumnReader<?>> columnReaders;
    private final List<AbstractMockWriter> dataWriters;
    private final List<AbstractConstraint> constraints;
    private final DataSource dataSource;
    private final List<MockerFile> fileManagers;

    public TableTaskInfo(List<ColumnReader<?>> columnReaders, List<AbstractMockWriter> dataWriters, List<AbstractConstraint> constraints, MockerBuffer buffer, DataSource dataSource, List<MockerFile> fileManagers, TableTaskMetaData metaData) {
        Validate.notNull(columnReaders, (String)"ColumnReaders can not be null for TableTaskInfo");
        Validate.notNull(dataWriters, (String)"DataWriters can not be null for TableTaskInfo");
        Validate.notNull(constraints, (String)"Constraints can not be null for TableTaskInfo");
        Validate.notNull((Object)metaData, (String)"TaskMetaData can not be null for TableTaskInfo");
        Validate.notNull((Object)buffer, (String)"MockBuffer can not be null for TableTaskInfo");
        Validate.notNull((Object)dataSource, (String)"DataSource can not be null for TableTaskInfo");
        Validate.notNull(fileManagers, (String)"FileManagers can not be null for TableTaskInfo");
        this.columnReaders = columnReaders;
        this.dataWriters = dataWriters;
        this.constraints = constraints;
        this.metaData = metaData;
        this.buffer = buffer;
        this.dataSource = dataSource;
        this.fileManagers = fileManagers;
    }

    public Set<String> columnGroups() {
        HashSet<String> returnVal = new HashSet<String>();
        for (ColumnReader<?> reader : this.columnReaders) {
            returnVal.add(reader.groupId());
        }
        return returnVal;
    }

    public Set<String> dataWriteGroups() {
        HashSet<String> returnVal = new HashSet<String>();
        for (AbstractMockWriter writer : this.dataWriters) {
            returnVal.add(writer.groupId());
        }
        return returnVal;
    }

    public TableTaskMetaData getMetaData() {
        return this.metaData;
    }

    public MockerBuffer getBuffer() {
        return this.buffer;
    }

    public List<ColumnReader<?>> getColumnReaders() {
        return this.columnReaders;
    }

    public List<AbstractMockWriter> getDataWriters() {
        return this.dataWriters;
    }

    public List<AbstractConstraint> getConstraints() {
        return this.constraints;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<MockerFile> getFileManagers() {
        return this.fileManagers;
    }
}

