/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.config.AbstractTableConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class TableTaskMetaData {
    private final String tableTaskId;
    private final Long totalCount;
    private final Map<String, AbstractDataType<?, ? extends Comparable<?>>> tableSchema;
    private final String tableName;
    private final String schema;
    private final Boolean shouldTruncate;
    private final Long timeoutMilliseconds;
    private final Long batchSize;
    private final ObModeType dialectType;
    private final String taskId;

    public TableTaskMetaData(Map<String, AbstractDataType<?, ? extends Comparable<?>>> tableSchema, AbstractTableConfig tableConfig, ObModeType obModeType, String taskId, int columnIndex, int rowIndex) {
        Validate.notNull(tableSchema, (String)"TableSchema can not be null for TableTaskMetaData");
        Validate.notNull((Object)tableConfig, (String)"TableConfig can not be null for TableTaskMetaData");
        Validate.notNull((Object)((Object)obModeType), (String)"ObModeType can not be null for TableTaskMetaData");
        Validate.notNull((Object)taskId, (String)"TaskId can not be null for TableTaskMetaData");
        this.tableSchema = tableSchema;
        this.tableName = tableConfig.tableName();
        this.schema = tableConfig.schemaName();
        this.shouldTruncate = tableConfig.truncated();
        this.timeoutMilliseconds = tableConfig.timeoutMilliseconds();
        this.batchSize = tableConfig.maxBatchSize();
        this.totalCount = tableConfig.maxCount();
        this.tableTaskId = taskId + "-[" + columnIndex + "," + rowIndex + "]";
        this.dialectType = obModeType;
        this.taskId = taskId;
    }

    public String getTableTaskId() {
        return this.tableTaskId;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public Map<String, AbstractDataType<?, ? extends Comparable<?>>> getTableSchema() {
        return this.tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public Boolean getShouldTruncate() {
        return this.shouldTruncate;
    }

    public Long getTimeoutMilliseconds() {
        return this.timeoutMilliseconds;
    }

    public Long getBatchSize() {
        return this.batchSize;
    }

    public ObModeType getDialectType() {
        return this.dialectType;
    }

    public String getTaskId() {
        return this.taskId;
    }
}

