/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.write;

import com.oceanbase.tools.datamocker.core.task.AbstractDataPipe;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMockWriter {
    private static final Logger log = LoggerFactory.getLogger(AbstractMockWriter.class);
    private AbstractDataPipe<List<MockRowData>> dataPipe;

    public void register(AbstractDataPipe<List<MockRowData>> dataPipe) {
        Validate.notNull(dataPipe, (String)"DataPipe can not be null for AbstractMockWriter#register");
        this.dataPipe = dataPipe;
    }

    public long write() throws Throwable {
        if (this.dataPipe == null) {
            log.error("Fail to read any data from the data pipe because the data pipe is null");
            throw new MockerException(MockerError.PARAMETER_ERROR, "Data pipe can not be null");
        }
        if (this.dataPipe.isClosed() && this.dataPipe.size() == 0L) {
            return Long.MIN_VALUE;
        }
        List<MockRowData> rowData = this.dataPipe.read(10L, TimeUnit.SECONDS);
        if (rowData == null || rowData.isEmpty()) {
            return 0L;
        }
        long writeCount = this.doWrite(rowData);
        Validate.isTrue((writeCount >= 0L ? 1 : 0) != 0, (String)"Write count can not be negative for AbstractMockWriter#write");
        return writeCount;
    }

    protected abstract long doWrite(List<MockRowData> var1) throws Throwable;

    public abstract String groupId();
}

