/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.write;

import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.core.write.AbstractMockWriter;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import com.oceanbase.tools.datamocker.util.DbObjectNameUtil;
import com.oceanbase.tools.datamocker.util.DigestUtil;
import com.oceanbase.tools.datamocker.util.PrintUtil;
import com.oceanbase.tools.datamocker.util.SqlUtil;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcWriter
extends AbstractMockWriter {
    private static final Logger log = LoggerFactory.getLogger(JdbcWriter.class);
    private final DataSource dataSource;
    private final String database;
    private final String tableName;
    private ObModeType dialectType = ObModeType.OB_ORACLE;
    private final String groupId;
    private volatile boolean ifCheck = false;

    public JdbcWriter(DataSource dataSource, ObModeType dialectType, String database, String tableName) {
        this.validate(dataSource, dialectType, database, tableName);
        this.dataSource = dataSource;
        this.database = database;
        this.tableName = tableName;
        this.dialectType = dialectType;
        try {
            this.groupId = DigestUtil.getToken(this.dialectType.name() + this.database + this.tableName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MockerException(MockerError.UNKNOWN_ERROR, e.getMessage());
        }
    }

    public JdbcWriter(DataSource dataSource, ObModeType dialectType, String database, String tableName, String groupId) {
        this.validate(dataSource, dialectType, database, tableName);
        this.dataSource = dataSource;
        this.database = database;
        this.tableName = tableName;
        this.dialectType = dialectType;
        Validate.notNull((Object)groupId, (String)"Group id can not be null for JdbcWriter");
        this.groupId = groupId;
    }

    private void validate(DataSource dataSource, ObModeType dialectType, String database, String tableName) {
        Validate.notNull((Object)dataSource, (String)"DataSource can not be null for JdbcWriter#validate");
        Validate.notNull((Object)database, (String)"Database can not be null for JdbcWriter#validate");
        Validate.notNull((Object)tableName, (String)"TableName can not be null for JdbcWriter#validate");
        if (!ObModeType.OB_ORACLE.equals((Object)dialectType) && !ObModeType.OB_MYSQL.equals((Object)dialectType)) {
            throw new MockerException(MockerError.INVALID_OB_MODE);
        }
    }

    private void detectExistenceOfTables() throws Throwable {
        String descSql;
        if (ObModeType.OB_ORACLE.equals((Object)this.dialectType)) {
            descSql = String.format("select count(*) from \"%s\".\"%s\"", DbObjectNameUtil.doubleCharToEscape(this.database, '\"'), DbObjectNameUtil.doubleCharToEscape(this.tableName, '\"'));
        } else if (ObModeType.OB_MYSQL.equals((Object)this.dialectType)) {
            descSql = String.format("select count(*) from `%s`.`%s`", DbObjectNameUtil.doubleCharToEscape(this.database, '`'), DbObjectNameUtil.doubleCharToEscape(this.tableName, '`'));
        } else {
            throw new MockerException(MockerError.INVALID_OB_MODE);
        }
        SqlUtil.executeQuery(this.dataSource, descSql, null, new AbstractCallBack<ResultSet>(){

            @Override
            public void doOnSuccess(ResultSet result) {
                JdbcWriter.this.ifCheck = true;
            }

            @Override
            public void doOnFailure(ResultSet result, Throwable e) {
                throw new MockerException(e);
            }
        });
    }

    @Override
    protected long doWrite(List<MockRowData> rows) throws Throwable {
        int j;
        StringBuffer sqlBuffer;
        if (!this.ifCheck) {
            this.detectExistenceOfTables();
        }
        MockRowData firstRow = rows.get(0);
        Set<String> columnSet = firstRow.columnNames();
        ArrayList<String> columnList = new ArrayList<String>(columnSet);
        if (ObModeType.OB_ORACLE.equals((Object)this.dialectType)) {
            sqlBuffer = new StringBuffer(String.format("insert into \"%s\".\"%s\"(", DbObjectNameUtil.doubleCharToEscape(this.database, '\"'), DbObjectNameUtil.doubleCharToEscape(this.tableName, '\"')));
        } else if (ObModeType.OB_MYSQL.equals((Object)this.dialectType)) {
            sqlBuffer = new StringBuffer(String.format("insert into `%s`.`%s`(", DbObjectNameUtil.doubleCharToEscape(this.database, '`'), DbObjectNameUtil.doubleCharToEscape(this.tableName, '`')));
        } else {
            throw new MockerException(MockerError.INVALID_OB_MODE);
        }
        int columnLength = columnList.size();
        for (int i = 0; i < columnLength; ++i) {
            String columnName = (String)columnList.get(i);
            if (i == columnLength - 1) {
                if (ObModeType.OB_ORACLE.equals((Object)this.dialectType)) {
                    sqlBuffer.append(String.format("\"%s\") values (", DbObjectNameUtil.doubleCharToEscape(columnName, '\"')));
                } else if (ObModeType.OB_MYSQL.equals((Object)this.dialectType)) {
                    sqlBuffer.append(String.format("`%s`) values (", DbObjectNameUtil.doubleCharToEscape(columnName, '`')));
                }
                for (j = 0; j < columnLength; ++j) {
                    if (j == columnLength - 1) {
                        sqlBuffer.append("?) ");
                        continue;
                    }
                    sqlBuffer.append("?,");
                }
                continue;
            }
            if (ObModeType.OB_ORACLE.equals((Object)this.dialectType)) {
                sqlBuffer.append(String.format("\"%s\", ", DbObjectNameUtil.doubleCharToEscape(columnName, '\"')));
                continue;
            }
            if (!ObModeType.OB_MYSQL.equals((Object)this.dialectType)) continue;
            sqlBuffer.append(String.format("`%s`, ", DbObjectNameUtil.doubleCharToEscape(columnName, '`')));
        }
        int rowLength = rows.size();
        Object[][] params = new Object[rows.size()][];
        for (j = 0; j < rowLength; ++j) {
            MockRowData row = rows.get(j);
            Object[] innerParam = new Object[columnLength];
            for (int i = 0; i < columnLength; ++i) {
                String columnName = (String)columnList.get(i);
                innerParam[i] = row.getMockColumn(columnName).getJdbcColumnValue();
            }
            params[j] = innerParam;
        }
        final ArrayList returnVal = new ArrayList();
        final long startTimestamp = System.currentTimeMillis();
        SqlUtil.executeBatch(this.dataSource, sqlBuffer.toString(), params, new AbstractCallBack<int[]>(){

            @Override
            public void doOnSuccess(int[] result) {
                String elapsedTime = PrintUtil.convertToReadableTimeString(System.currentTimeMillis() - startTimestamp, TimeUnit.MILLISECONDS, TimeUnit.MINUTES, TimeUnit.MILLISECONDS);
                if (result != null) {
                    log.info("JDBC writer writes a batch successfully, effectRow={}, elapsedTime={}", (Object)result.length, (Object)elapsedTime);
                    returnVal.add(Long.valueOf(result.length));
                } else {
                    log.warn("JDBC writer has finished writing, but no data has been written, elapsedTime={}", (Object)elapsedTime);
                }
            }

            @Override
            public void doOnFailure(int[] result, Throwable e) throws Throwable {
                log.error("JDBC writer failed to write", e);
                throw e;
            }
        });
        return (Long)returnVal.get(0);
    }

    @Override
    public String groupId() {
        return this.groupId;
    }
}

