/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.write;

import com.oceanbase.tools.datamocker.core.write.AbstractMockWriter;
import com.oceanbase.tools.datamocker.core.write.output.MockerFile;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import com.oceanbase.tools.datamocker.util.DbObjectNameUtil;
import com.oceanbase.tools.datamocker.util.DigestUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScriptWriter
extends AbstractMockWriter {
    private static final Logger log = LoggerFactory.getLogger(SqlScriptWriter.class);
    private final String database;
    private final String tableName;
    private final ObModeType dialectType;
    private final MockerFile manager;
    private final String groupId;

    public SqlScriptWriter(MockerFile manager, ObModeType dialectType, String database, String tableName) {
        this.validateParam(manager, dialectType, database, tableName);
        this.database = database;
        this.tableName = tableName;
        this.manager = manager;
        this.dialectType = dialectType;
        try {
            this.groupId = DigestUtil.getToken(manager.getFile().getAbsolutePath());
        }
        catch (NoSuchAlgorithmException e) {
            throw new MockerException(MockerError.UNKNOWN_ERROR, e.getMessage());
        }
    }

    public SqlScriptWriter(MockerFile manager, ObModeType dialectType, String database, String tableName, String groupId) {
        this.validateParam(manager, dialectType, database, tableName);
        this.database = database;
        this.tableName = tableName;
        this.manager = manager;
        this.dialectType = dialectType;
        if (groupId == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Group id can not be null");
        }
        this.groupId = groupId;
    }

    private void validateParam(MockerFile manager, ObModeType dialectType, String database, String tableName) {
        Validate.notNull((Object)manager, (String)"File manager can not be null for SqlScriptWriter#validateParam");
        Validate.notNull((Object)database, (String)"DataBase can not be null for SqlScriptWriter#validateParam");
        Validate.notNull((Object)tableName, (String)"TableName can not be null for SqlScriptWriter#validateParam");
        if (!ObModeType.OB_ORACLE.equals((Object)dialectType) && !ObModeType.OB_MYSQL.equals((Object)dialectType)) {
            throw new MockerException(MockerError.INVALID_OB_MODE);
        }
    }

    @Override
    protected long doWrite(List<MockRowData> rows) throws IOException {
        StringBuffer sqlBuffer;
        MockRowData firstRow = rows.get(0);
        Set<String> columnSet = firstRow.columnNames();
        ArrayList<String> columnList = new ArrayList<String>(columnSet);
        if (ObModeType.OB_ORACLE.equals((Object)this.dialectType)) {
            sqlBuffer = new StringBuffer(String.format("insert into \"%s\".\"%s\"(", DbObjectNameUtil.doubleCharToEscape(this.database, '\"'), DbObjectNameUtil.doubleCharToEscape(this.tableName, '\"')));
        } else if (ObModeType.OB_MYSQL.equals((Object)this.dialectType)) {
            sqlBuffer = new StringBuffer(String.format("insert into `%s`.`%s`(", DbObjectNameUtil.doubleCharToEscape(this.database, '`'), DbObjectNameUtil.doubleCharToEscape(this.tableName, '`')));
        } else {
            throw new MockerException(MockerError.INVALID_OB_MODE);
        }
        int columnLength = columnList.size();
        for (int i = 0; i < columnLength; ++i) {
            String columnName = (String)columnList.get(i);
            if (i == columnLength - 1) {
                if (ObModeType.OB_ORACLE.equals((Object)this.dialectType)) {
                    sqlBuffer.append(String.format("\"%s\") values (", DbObjectNameUtil.doubleCharToEscape(columnName, '\"')));
                    continue;
                }
                sqlBuffer.append(String.format("`%s`) values (", DbObjectNameUtil.doubleCharToEscape(columnName, '`')));
                continue;
            }
            if (ObModeType.OB_ORACLE.equals((Object)this.dialectType)) {
                sqlBuffer.append(String.format("\"%s\", ", DbObjectNameUtil.doubleCharToEscape(columnName, '\"')));
                continue;
            }
            sqlBuffer.append(String.format("`%s`, ", DbObjectNameUtil.doubleCharToEscape(columnName, '`')));
        }
        String prefix = sqlBuffer.toString();
        ArrayList<String> sqlList = new ArrayList<String>();
        for (MockRowData row : rows) {
            StringBuilder buffer = new StringBuilder(prefix);
            for (int i = 0; i < columnLength; ++i) {
                String columnName = (String)columnList.get(i);
                MockColumnData<?> mockColumn = row.getMockColumn(columnName);
                String value = mockColumn.getColumnValueString();
                if (value == null) {
                    throw new MockerException(MockerError.ILLEGAL_RETURN_VALUE, String.format("Value for column \"%s\" is null", columnName));
                }
                if (i == columnLength - 1) {
                    buffer.append(String.format("%s); ", value));
                    continue;
                }
                buffer.append(String.format("%s,", value));
            }
            sqlList.add(buffer.append("\n").toString());
        }
        String result = String.join((CharSequence)"", sqlList);
        this.manager.write(result.getBytes(), 0, result.getBytes().length, true);
        return rows.size();
    }

    @Override
    public String groupId() {
        return this.groupId;
    }
}

