/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.write.output;

import com.oceanbase.tools.datamocker.model.enums.ScriptType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockerFile {
    private static final Logger log = LoggerFactory.getLogger(MockerFile.class);
    private final File file;
    private final FileOutputStream output;
    private final ScriptType scriptType;

    public MockerFile(String fileName, ScriptType scriptType) throws IOException {
        this.file = new File(fileName);
        if (this.file.exists() && !this.file.delete()) {
            throw new MockerException(MockerError.OPERATION_FAILURE, "Fail to delete a file \"%s\"");
        }
        this.create(this.file);
        this.output = new FileOutputStream(this.file);
        this.scriptType = scriptType;
    }

    public MockerFile(String fileName, ScriptType scriptType, Boolean truncate) throws IOException {
        this.file = new File(fileName);
        if (this.file.exists()) {
            if (truncate.booleanValue()) {
                if (!this.file.delete()) {
                    throw new IOException(String.format("fail to truncate file \"%s\"", fileName));
                }
                this.create(this.file);
            }
        } else {
            this.create(this.file);
        }
        this.output = new FileOutputStream(this.file, true);
        this.scriptType = scriptType;
    }

    public void close() {
        try {
            this.output.close();
            log.info("File manager has been successfully closed");
        }
        catch (IOException e) {
            log.error("File manager has been closed failed", (Throwable)e);
        }
    }

    private void create(File file) throws IOException {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new MockerException(MockerError.OPERATION_FAILURE, String.format("Fail to create dir \"%s\"", file.getParent()));
        }
        if (!file.createNewFile()) {
            throw new MockerException(MockerError.OPERATION_FAILURE, String.format("Fail to create file \"%s\"", file.getName()));
        }
    }

    public synchronized long write(byte[] bytes, int offset, int length, boolean immediateFlush) throws IOException {
        if (this.output == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "File output stream can not be null");
        }
        this.output.write(bytes, offset, length);
        if (immediateFlush) {
            this.output.flush();
        }
        return length;
    }

    public File getFile() {
        return this.file;
    }

    public synchronized boolean clear() throws IOException {
        this.output.close();
        if (this.file.exists()) {
            return this.file.delete();
        }
        return true;
    }

    public ScriptType getScriptType() {
        return this.scriptType;
    }
}

