/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype;

import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.generator.BaseByteGenerator;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.util.DigestUtil;
import java.security.NoSuchAlgorithmException;

public abstract class AbstractByteDataType
extends AbstractDataType<byte[], Integer> {
    public AbstractByteDataType(BaseByteGenerator generator, ObModeType dialectType, byte[] defaultValue, Boolean allowNull) {
        super(generator, dialectType, defaultValue, allowNull);
    }

    protected AbstractByteDataType(ObModeType dialectType, byte[] defaultValue, Boolean allowNull) {
        super(dialectType, defaultValue, allowNull);
    }

    @Override
    protected Integer minValueForType() {
        return 1;
    }

    @Override
    public Long distinctLimit() {
        if (this.generator == null || this.generator.count(this.lowValue(), this.highValue()) == null) {
            return Long.MAX_VALUE;
        }
        return this.generator.count(this.lowValue(), this.highValue());
    }

    @Override
    protected byte[] preProcessingBeforeOutput(byte[] value) {
        if (value == null) {
            return null;
        }
        Integer maxLength = (Integer)this.highValue();
        if (value.length > maxLength) {
            throw new MockerException(MockerError.VALUE_OUT_OFRANGE, String.format("The length of then generator's value is bigger than bound [0,%d]", maxLength));
        }
        return value;
    }

    @Override
    public byte[] toDigest(byte[] value) {
        try {
            return DigestUtil.getToken(value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MockerException(MockerError.UNKNOWN_ERROR, e.getMessage());
        }
    }
}

