/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype;

import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.generator.BaseCharGenerator;
import com.oceanbase.tools.datamocker.generator.BaseGenerator;
import com.oceanbase.tools.datamocker.model.enums.CharsetType;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.io.UnsupportedEncodingException;

public abstract class AbstractCharDataType
extends AbstractDataType<String, Integer> {
    private final boolean isUnicode;
    private final CharsetType charsetType;
    private final Integer length;

    public AbstractCharDataType(BaseCharGenerator generator, ObModeType dialectType, CharsetType charsetType, Integer length, String defaultValue, Boolean allowNull, Boolean isUnicode) {
        super(generator, dialectType, defaultValue, allowNull);
        this.validateParam(charsetType, length);
        generator.setCharsetType(charsetType);
        generator.setUnicode(isUnicode);
        this.charsetType = charsetType;
        this.length = length;
        this.isUnicode = isUnicode;
    }

    protected AbstractCharDataType(ObModeType dialectType, CharsetType charsetType, Integer length, String defaultValue, Boolean allowNull, Boolean isUnicode) {
        super(dialectType, defaultValue, allowNull);
        this.validateParam(charsetType, length);
        this.charsetType = charsetType;
        this.length = length;
        this.isUnicode = isUnicode;
    }

    public void validateParam(CharsetType charsetType, Integer length) {
        if (charsetType == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Char set for data type can not be null");
        }
        if (length == null || length <= 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Datatype length can not be null or smaller than zero");
        }
    }

    @Override
    protected Integer minValueForType() {
        return 1;
    }

    @Override
    protected Integer maxValueForType() {
        return this.length;
    }

    @Override
    public void bind(BaseGenerator<Integer, String> generator) {
        super.bind(generator);
        ((BaseCharGenerator)generator).setCharsetType(this.getCharsetType());
        ((BaseCharGenerator)generator).setUnicode(this.isUnicode());
    }

    @Override
    public Long distinctLimit() {
        if (this.generator == null || this.generator.count(this.lowValue(), this.highValue()) == null) {
            return Long.MAX_VALUE;
        }
        return this.generator.count(this.lowValue(), this.highValue());
    }

    @Override
    protected String preProcessingBeforeOutput(String value) {
        int realLength;
        if (value == null) {
            return null;
        }
        Integer maxLength = (Integer)this.highValue();
        try {
            realLength = this.isUnicode() ? value.length() : value.getBytes(this.getCharsetType().getCharSet()).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new MockerException(MockerError.UNKNOWN_ERROR, e.getMessage());
        }
        if (realLength > maxLength) {
            throw new MockerException(MockerError.VALUE_OUT_OFRANGE, String.format("The length of then generator's value is bigger than bound [0,%d]", maxLength));
        }
        return value;
    }

    @Override
    public String convertToSqlString(String value) {
        if (value == null) {
            return "NULL";
        }
        return String.format("'%s'", value);
    }

    @Override
    public String toDigest(String value) {
        return value;
    }

    public boolean isUnicode() {
        return this.isUnicode;
    }

    public CharsetType getCharsetType() {
        return this.charsetType;
    }
}

