/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype;

import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseGenerator;
import com.oceanbase.tools.datamocker.model.config.model.DataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import org.apache.commons.lang.Validate;

public abstract class AbstractDataType<T, V extends Comparable<? super V>> {
    private Boolean preCheck = null;
    private final T defaultValue;
    private final Boolean allowNull;
    protected V lowValue = null;
    protected V highValue = null;
    protected BaseGenerator<V, T> generator;
    private final ObModeType dialectType;

    protected AbstractDataType(ObModeType obModeType, T defaultValue, Boolean allowNull) {
        Validate.notNull((Object)((Object)obModeType), (String)"ObModeType can not be null for AbstractDataType");
        Validate.notNull((Object)allowNull, (String)"AllowNull config can not be null for AbstractDataType");
        this.dialectType = obModeType;
        this.allowNull = allowNull;
        this.defaultValue = defaultValue;
    }

    protected AbstractDataType(BaseGenerator<V, T> generator, ObModeType obModeType, T defaultValue, Boolean allowNull) {
        Validate.notNull((Object)((Object)obModeType), (String)"ObModeType can not be null for AbstractDataType");
        this.dialectType = obModeType;
        this.allowNull = allowNull;
        this.defaultValue = defaultValue;
        this.bind(generator);
    }

    public abstract DataTypeFactory<? extends AbstractDataType<T, V>, ? extends DataTypeConfig, ? extends BaseGenerator<V, T>> getFactory();

    protected abstract V minValueForType();

    protected abstract V maxValueForType();

    public abstract Long distinctLimit();

    protected abstract T preProcessingBeforeOutput(T var1);

    public abstract String convertToSqlString(T var1);

    public abstract T toDigest(T var1);

    public T convertFromJdbcObjectToJavaObject(Object resultSetObject) {
        return (T)resultSetObject;
    }

    public Object convertFromJavaObjectToJdbcObject(T javaObject) {
        return javaObject;
    }

    public void bind(BaseGenerator<V, T> generator) {
        Validate.notNull(generator, (String)"DataGenerator can not be null for AbstractDataType#bind");
        this.generator = generator;
        this.generator.setAllowNull(this.getAllowNull());
        this.generator.setDefaultValue(this.getDefaultValue());
        this.preCheck = null;
    }

    protected void validateValue(V value) {
        if (value == null) {
            return;
        }
        V lowValue = this.minValueForType();
        V highValue = this.maxValueForType();
        if (lowValue == null || highValue == null) {
            throw new MockerException(MockerError.ILLEGAL_RETURN_VALUE, "Lowest or highest value can not be null for data type " + this.toString());
        }
        if (value.compareTo(lowValue) < 0 || value.compareTo(highValue) > 0) {
            throw new MockerException(MockerError.VALUE_OUT_OFRANGE, String.format("Max or min value %s for data type %s is out of range [%s,%s]", value.toString(), this.toString(), lowValue.toString(), highValue.toString()));
        }
    }

    public void setLowValue(V value) {
        this.validateValue(value);
        if (value.compareTo(this.highValue()) > 0) {
            throw new MockerException(MockerError.VALUE_OUT_OFRANGE, String.format("Min value can not be bigger than max value \"%s\" for data type %s", this.highValue().toString(), this.toString()));
        }
        this.lowValue = value;
    }

    public void setHighValue(V value) {
        this.validateValue(value);
        if (value.compareTo(this.lowValue()) < 0) {
            throw new MockerException(MockerError.VALUE_OUT_OFRANGE, String.format("Max value can not be smaller than min value \"%s\" for data type %s", this.lowValue().toString(), this.toString()));
        }
        this.highValue = value;
    }

    public T acquire() {
        if (this.generator == null) {
            throw new MockerException(MockerError.OPERATION_FAILURE, "Generator can not be null");
        }
        if (this.preCheck == null) {
            this.preCheck = this.generator.preCheck(this.lowValue(), this.highValue());
        }
        if (this.preCheck == null || !this.preCheck.booleanValue()) {
            throw new MockerException(MockerError.PARAMETER_ERROR, String.format("Data check of column \"%s\" for generator is not passed", this));
        }
        return this.preProcessingBeforeOutput(this.generator.next(this.lowValue(), this.highValue()));
    }

    public V lowValue() {
        if (this.lowValue == null) {
            this.lowValue = this.minValueForType();
        }
        return this.lowValue;
    }

    public V highValue() {
        if (this.highValue == null) {
            this.highValue = this.maxValueForType();
        }
        return this.highValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDataType that = (AbstractDataType)o;
        return this.dialectType == that.dialectType && this.getFactory() == that.getFactory();
    }

    public int hashCode() {
        return (this.getFactory().toString() + this.dialectType.name()).hashCode();
    }

    public MockColumnData<T> convertFromJdbcObjectToMockColumn(String columnName, Object jdbcObject) {
        Validate.notEmpty((String)columnName, (String)"ColumnName can not be null for AbstractDataType#toMockColumn");
        return new MockColumnData<T>(columnName, this, this.convertFromJdbcObjectToJavaObject(jdbcObject));
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean getAllowNull() {
        return this.allowNull;
    }

    public ObModeType getDialectType() {
        return this.dialectType;
    }
}

