/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.mysql;

import com.oceanbase.tools.datamocker.datatype.AbstractCharDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseCharGenerator;
import com.oceanbase.tools.datamocker.model.config.model.CharDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.CharsetType;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;

public class MysqlCharType
extends AbstractCharDataType {
    public MysqlCharType(Integer length, String defaultValue, Boolean allowNull, CharsetType charsetType, BaseCharGenerator generator, Boolean isUnicode) {
        super(generator, ObModeType.OB_MYSQL, charsetType, length, defaultValue, allowNull, isUnicode);
        if (length > 256 || length <= 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Length for char type of mysql can not be larger than 256 or smaller than 0");
        }
    }

    public MysqlCharType(Integer length, String defaultValue, Boolean allowNull, CharsetType charsetType, Boolean isUnicode) {
        super(ObModeType.OB_MYSQL, charsetType, length, defaultValue, allowNull, isUnicode);
        if (length > 256 || length <= 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Length for char type of mysql can not be larger than 256 or smaller than 0");
        }
    }

    @Override
    public DataTypeFactory<MysqlCharType, CharDataTypeConfig, BaseCharGenerator> getFactory() {
        return DataTypeFactory.getInstance("OB_MYSQL_CHAR");
    }

    public String toString() {
        return String.format("CHAR(%d)", this.maxValueForType());
    }
}

