/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.mysql;

import com.oceanbase.tools.datamocker.datatype.AbstractDigitDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.config.model.DigitDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.math.BigDecimal;

public class MysqlFloatType
extends AbstractDigitDataType<BigDecimal> {
    private final int precision;
    private final int scale;

    public MysqlFloatType(int precision, int scale, BaseDigitalGenerator<BigDecimal> generator, BigDecimal defaultValue, Boolean allowNull, Boolean signed) {
        super(generator, ObModeType.OB_MYSQL, defaultValue, allowNull, signed);
        this.validate(precision, scale);
        this.precision = precision;
        this.scale = scale;
    }

    public MysqlFloatType(BaseDigitalGenerator<BigDecimal> generator, BigDecimal defaultValue, Boolean allowNull, Boolean signed) {
        super(generator, ObModeType.OB_MYSQL, defaultValue, allowNull, signed);
        this.precision = -1;
        this.scale = -1;
    }

    private void validate(int precision, int scale) {
        if (precision < -1 || precision > 53) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Precision for float can not larger than 53 or smaller than 0");
        }
        if (scale < -1 || scale > 30) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Scale for float can not larger than 30 or smaller than 0");
        }
        if (precision < scale) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Scale can not be bigger than precision");
        }
    }

    @Override
    public BigDecimal convertFromJdbcObjectToJavaObject(Object value) {
        if (value == null) {
            return null;
        }
        return new BigDecimal(value.toString());
    }

    @Override
    protected BigDecimal maxValueForType() {
        if (this.precision == -1 && this.scale == -1) {
            if (this.signed().booleanValue()) {
                return new BigDecimal("3.402823466351E+38");
            }
            return new BigDecimal("3.402823466E+38");
        }
        return this.maxOrMinForNumber();
    }

    @Override
    protected BigDecimal minValueForType() {
        if (this.precision == -1 && this.scale == -1) {
            if (this.signed().booleanValue()) {
                return new BigDecimal("-3.402823466E+38");
            }
            return new BigDecimal("0");
        }
        if (this.precision >= 0 && this.scale >= 0) {
            if (this.signed().booleanValue()) {
                return this.maxOrMinForNumber().multiply(new BigDecimal(-1));
            }
            return new BigDecimal("0");
        }
        throw new MockerException(MockerError.PARAMETER_ERROR, "Wrong precision or scale for float");
    }

    @Override
    protected Long limitForType(BigDecimal lowValue, BigDecimal highValue) {
        if (this.precision == -1 && this.scale == -1) {
            return Long.MAX_VALUE;
        }
        if (this.precision >= 0 && this.scale >= 0) {
            BigDecimal interval = highValue.subtract(lowValue);
            BigDecimal result = interval.multiply(new BigDecimal(Double.toString(Math.pow(10.0, this.scale)))).setScale(0, 1);
            return Long.valueOf(result.toPlainString());
        }
        throw new MockerException(MockerError.PARAMETER_ERROR, "Wrong precision or scale for float");
    }

    @Override
    protected BigDecimal preProcessingBeforeOutput(BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (this.precision == -1 && this.scale == -1) {
            return value;
        }
        if (this.precision >= 0 && this.scale >= 0) {
            return value.setScale(this.scale, 5);
        }
        throw new MockerException(MockerError.PARAMETER_ERROR, "Wrong precision or scale for float");
    }

    @Override
    public String convertToSqlString(BigDecimal value) {
        if (value == null) {
            return "NULL";
        }
        if (this.precision == -1 && this.scale == -1) {
            return value.toPlainString();
        }
        if (this.precision >= 0 && this.scale >= 0) {
            return value.setScale(this.scale, 5).toPlainString();
        }
        throw new MockerException(MockerError.PARAMETER_ERROR, "Wrong precision or scale for float");
    }

    public String toString() {
        if (this.precision == -1 && this.scale == -1) {
            return "float";
        }
        if (this.precision >= 0 && this.scale >= 0) {
            return String.format("decimal(%d, %d)", this.precision, this.scale);
        }
        throw new MockerException(MockerError.PARAMETER_ERROR, "Wrong precision or scale for float");
    }

    private BigDecimal maxOrMinForNumber() {
        BigDecimal secondPartMaxValue;
        this.validate(this.precision, this.scale);
        int interval = this.precision - this.scale;
        int firstPartWidth = Math.max(interval, 0);
        BigDecimal firstPartMaxValue = new BigDecimal(Double.toString(Math.pow(10.0, firstPartWidth))).subtract(BigDecimal.ONE);
        BigDecimal factor = new BigDecimal(Double.toString(Math.pow(10.0, -this.scale - 1)));
        if (this.scale >= 0) {
            if (firstPartWidth > 0) {
                factor = factor.multiply(new BigDecimal(5));
                secondPartMaxValue = BigDecimal.ONE.subtract(new BigDecimal(Double.toString(Math.pow(10.0, -this.scale)))).add(factor);
            } else {
                factor = factor.multiply(new BigDecimal(4));
                secondPartMaxValue = new BigDecimal(Double.toString(Math.pow(10.0, interval))).subtract(new BigDecimal(Double.toString(Math.pow(10.0, -this.scale)))).add(factor);
            }
        } else {
            factor = factor.multiply(new BigDecimal(5));
            firstPartMaxValue = firstPartMaxValue.subtract(factor);
            secondPartMaxValue = BigDecimal.ZERO;
        }
        return firstPartMaxValue.add(secondPartMaxValue);
    }

    @Override
    public DataTypeFactory<MysqlFloatType, DigitDataTypeConfig, BaseDigitalGenerator<BigDecimal>> getFactory() {
        if (this.signed().booleanValue()) {
            return DataTypeFactory.getInstance("OB_MYSQL_FLOAT");
        }
        return DataTypeFactory.getInstance("OB_MYSQL_FLOAT_UNSIGNED");
    }
}

