/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.mysql;

import com.oceanbase.tools.datamocker.datatype.AbstractDateDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseDateGenerator;
import com.oceanbase.tools.datamocker.generator.BaseGenerator;
import com.oceanbase.tools.datamocker.model.config.model.DateDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class MysqlYearType
extends AbstractDateDataType<Date> {
    private final int scale;
    private static final String JAVA_DATE_FORMAT = "yyyy";

    public MysqlYearType(BaseDateGenerator<Date> generator, int scale, Date defaultValue, Boolean allowNull) {
        super(generator, ObModeType.OB_MYSQL, defaultValue, allowNull);
        generator.setScale(scale);
        generator.setMinTimeUnit(TimeUnit.DAYS);
        this.scale = scale;
    }

    @Override
    public void bind(BaseGenerator<Date, Date> generator) {
        super.bind(generator);
        ((BaseDateGenerator)generator).setScale(this.scale);
        ((BaseDateGenerator)generator).setMinTimeUnit(TimeUnit.DAYS);
    }

    @Override
    protected Long limitForType(Date minDate, Date maxDate) {
        long interval = maxDate.getTime() - minDate.getTime();
        return interval / 31536000000L - 1L;
    }

    @Override
    public DataTypeFactory<MysqlYearType, DateDataTypeConfig, BaseDateGenerator<Date>> getFactory() {
        return DataTypeFactory.getInstance("OB_MYSQL_YEAR");
    }

    @Override
    protected Date minValueForType() {
        return new Date(-2177481600000L);
    }

    @Override
    protected Date maxValueForType() {
        return new Date(5838019200000L);
    }

    @Override
    public Object convertFromJavaObjectToJdbcObject(Date javaObject) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(JAVA_DATE_FORMAT);
        return dateFormat.format(javaObject);
    }

    public String toString() {
        return String.format("year(%d)", this.scale);
    }

    @Override
    public synchronized String convertToSqlString(Date value, TimeZone timeZone) {
        if (value == null) {
            return "NULL";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(JAVA_DATE_FORMAT);
        return dateFormat.format(value);
    }
}

