/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.chartype;

import com.oceanbase.tools.datamocker.generator.BaseCharGenerator;
import com.oceanbase.tools.datamocker.model.enums.CharCaseOption;
import com.oceanbase.tools.datamocker.model.enums.CharsetType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class FixDateCharGenerator
extends BaseCharGenerator {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final long timestamp;

    public FixDateCharGenerator(CharCaseOption caseOption, long timestamp, String timezone) {
        super(caseOption);
        if (timestamp < 0L) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Timestamp can not be smaller than zero");
        }
        this.timestamp = timestamp;
        if (StringUtils.isNotBlank((String)timezone)) {
            TimeZone zone = TimeZone.getTimeZone(timezone);
            SimpleDateFormat formater = new SimpleDateFormat(DATE_FORMAT);
            formater.setTimeZone(zone);
        }
    }

    @Override
    protected Boolean doPreCheck(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        int realLength = DATE_FORMAT.length();
        if (realLength >= minLength) {
            return realLength <= maxLength;
        }
        return false;
    }

    @Override
    protected String doGenerate(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        SimpleDateFormat formater = new SimpleDateFormat(DATE_FORMAT);
        return formater.format(new Date(this.timestamp));
    }

    @Override
    protected Long doCount(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        return 1L;
    }
}

