/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.chartype;

import com.oceanbase.tools.datamocker.generator.BaseCharGenerator;
import com.oceanbase.tools.datamocker.model.enums.CharCaseOption;
import com.oceanbase.tools.datamocker.model.enums.CharsetType;
import java.util.Random;

public class RandomGenerator
extends BaseCharGenerator {
    private static final char[] PRINT_CHAR = new char[]{'!', '\"', '#', '$', '%', '&', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}'};
    private final Random randomObject = new Random();

    public RandomGenerator(CharCaseOption caseType) {
        super(caseType);
    }

    @Override
    protected Boolean doPreCheck(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        return true;
    }

    @Override
    protected String doGenerate(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        int actualLength = minLength + this.randomObject.nextInt(maxLength - minLength + 1);
        char[] returnVal = new char[actualLength];
        for (int i = 0; i < actualLength; ++i) {
            int index = this.randomObject.nextInt(PRINT_CHAR.length);
            returnVal[i] = PRINT_CHAR[index];
        }
        return caseOption.convert(new String(returnVal));
    }

    @Override
    protected Long doCount(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        if (maxLength >= 4) {
            return Long.MAX_VALUE;
        }
        int interval = maxLength - minLength;
        double returnVal = 0.0;
        for (int i = 0; i < interval; ++i) {
            returnVal += Math.pow(PRINT_CHAR.length, i + 1);
        }
        return (long)(returnVal *= Math.pow(PRINT_CHAR.length, minLength.intValue()));
    }
}

