/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.chartype;

import com.oceanbase.tools.datamocker.generator.BaseCharGenerator;
import com.oceanbase.tools.datamocker.model.enums.CharCaseOption;
import com.oceanbase.tools.datamocker.model.enums.CharsetType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class StepDateCharGenerator
extends BaseCharGenerator {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final long startTime;
    private final long endTime;
    private final long step;
    private final Boolean cycle;
    private Long timestamp = null;

    public StepDateCharGenerator(CharCaseOption caseOption, long startTime, long endTime, long step, TimeUnit timeUnit, Boolean cycle, String timezone) {
        super(caseOption);
        if (startTime >= endTime) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Start time stamp can not be later than end time stamp");
        }
        if (startTime < 0L) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Time stamp can not be smaller than zero");
        }
        this.startTime = startTime;
        this.endTime = endTime;
        this.cycle = cycle;
        this.step = timeUnit != null ? TimeUnit.MILLISECONDS.convert(step, timeUnit) : step;
        if (StringUtils.isNotBlank((String)timezone)) {
            TimeZone zone = TimeZone.getTimeZone(timezone);
            SimpleDateFormat formater = new SimpleDateFormat(DATE_FORMAT);
            formater.setTimeZone(zone);
        }
    }

    @Override
    protected Boolean doPreCheck(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        int realLength = DATE_FORMAT.length();
        if (realLength >= minLength) {
            return realLength <= maxLength;
        }
        return false;
    }

    @Override
    protected String doGenerate(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        SimpleDateFormat formater = new SimpleDateFormat(DATE_FORMAT);
        if (this.step < 0L) {
            return formater.format(new Date(this.minus()));
        }
        return formater.format(new Date(this.positive()));
    }

    @Override
    protected Long doCount(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        long interval = this.endTime - this.startTime;
        return interval / Math.abs(this.step);
    }

    private long minus() {
        if (this.timestamp == null) {
            this.timestamp = this.endTime;
            return this.timestamp;
        }
        this.timestamp = this.timestamp + this.step;
        if (this.timestamp < this.startTime) {
            if (this.cycle.booleanValue()) {
                this.timestamp = this.endTime;
            } else {
                throw new MockerException(MockerError.OPERATION_FAILURE, "Can not generate more unique date");
            }
        }
        return this.timestamp;
    }

    private long positive() {
        if (this.timestamp == null) {
            this.timestamp = this.startTime;
            return this.timestamp;
        }
        this.timestamp = this.timestamp + this.step;
        if (this.timestamp > this.endTime) {
            if (this.cycle.booleanValue()) {
                this.timestamp = this.startTime;
            } else {
                throw new MockerException(MockerError.OPERATION_FAILURE, "Can not generate more unique date");
            }
        }
        return this.timestamp;
    }
}

