/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.date;

import com.oceanbase.tools.datamocker.generator.BaseDateGenerator;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

public class FixTimestampGenerator
extends BaseDateGenerator<Timestamp> {
    private final long timestamp;

    public FixTimestampGenerator(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    protected Boolean doPreCheck(Timestamp startTime, Timestamp endTime, int scale, TimeUnit minTimeUnit) {
        return this.timestamp >= startTime.getTime() && this.timestamp <= endTime.getTime();
    }

    @Override
    protected Timestamp doGenerate(Timestamp startTime, Timestamp endTime, int scale, TimeUnit minTimeUnit) {
        Timestamp timestamp = new Timestamp(this.timestamp);
        timestamp.setNanos(0);
        return timestamp;
    }

    @Override
    protected Long doCount(Timestamp startTime, Timestamp endTime, int scale, TimeUnit minTimeUnit) {
        return 1L;
    }
}

