/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.date;

import com.oceanbase.tools.datamocker.generator.BaseDateGenerator;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.sql.Date;
import java.util.concurrent.TimeUnit;

public class StepDateGenerator
extends BaseDateGenerator<Date> {
    private final long step;
    private final Boolean cycle;
    private Long timestamp = null;

    public StepDateGenerator(long step, TimeUnit timeUnit, Boolean cycle) {
        this.cycle = cycle;
        this.step = timeUnit != null ? TimeUnit.MILLISECONDS.convert(step, timeUnit) : step;
    }

    @Override
    protected Boolean doPreCheck(Date startTime, Date endTime, int scale, TimeUnit minTimeUnit) {
        return true;
    }

    @Override
    protected Date doGenerate(Date startTime, Date endTime, int scale, TimeUnit minTimeUnit) {
        if (this.step < 0L) {
            return new Date(this.minus(startTime.getTime(), endTime.getTime()));
        }
        return new Date(this.positive(startTime.getTime(), endTime.getTime()));
    }

    @Override
    protected Long doCount(Date startTime, Date endTime, int scale, TimeUnit minTimeUnit) {
        long interval = endTime.getTime() - startTime.getTime();
        return interval / Math.abs(this.step);
    }

    private long minus(long startTime, long endTime) {
        if (this.timestamp == null) {
            this.timestamp = endTime;
            return this.timestamp;
        }
        this.timestamp = this.timestamp + this.step;
        if (this.timestamp < startTime) {
            if (this.cycle.booleanValue()) {
                this.timestamp = endTime;
            } else {
                throw new MockerException(MockerError.OPERATION_FAILURE, "Can not generate more unique date");
            }
        }
        return this.timestamp;
    }

    private long positive(long startTime, long endTime) {
        if (this.timestamp == null) {
            this.timestamp = startTime;
            return this.timestamp;
        }
        this.timestamp = this.timestamp + this.step;
        if (this.timestamp > endTime) {
            if (this.cycle.booleanValue()) {
                this.timestamp = startTime;
            } else {
                throw new MockerException(MockerError.OPERATION_FAILURE, "Can not generate more unique date");
            }
        }
        return this.timestamp;
    }
}

