/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.digit;

import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.math.BigDecimal;

public class FixNumGenerator
extends BaseDigitalGenerator<BigDecimal> {
    private final BigDecimal fixNum;

    public FixNumGenerator(BigDecimal fixNum) {
        if (fixNum == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Fix number for FixNumGenerator can not be null");
        }
        this.fixNum = fixNum;
    }

    @Override
    public Boolean preCheck(BigDecimal minValue, BigDecimal maxValue) {
        return this.fixNum.compareTo(minValue) >= 0 && this.fixNum.compareTo(maxValue) <= 0;
    }

    @Override
    public BigDecimal generate(BigDecimal minValue, BigDecimal maxValue) {
        return this.fixNum;
    }

    @Override
    public Long count(BigDecimal minValue, BigDecimal maxValue) {
        return 1L;
    }
}

