/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.digit;

import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.math.BigDecimal;
import java.util.Random;

public class NormalGenerator
extends BaseDigitalGenerator<BigDecimal> {
    private final double variance;
    private final double average;

    public NormalGenerator(double average, double variance) {
        this.variance = variance;
        this.average = average;
    }

    public NormalGenerator() {
        this.average = 0.0;
        this.variance = 1.0;
    }

    @Override
    public Boolean preCheck(BigDecimal minValue, BigDecimal maxValue) {
        BigDecimal avg = new BigDecimal(Double.toString(this.average));
        if (avg.compareTo(minValue) < 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Avg value is illegal for min value");
        }
        if (avg.compareTo(maxValue) >= 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Avg value is illegal for max value");
        }
        return true;
    }

    @Override
    public BigDecimal generate(BigDecimal minValue, BigDecimal maxValue) {
        Random random = new Random();
        BigDecimal value = new BigDecimal(Double.toString(Math.sqrt(this.variance) * random.nextGaussian() + this.average));
        if (value.compareTo(minValue) < 0) {
            return minValue;
        }
        if (value.compareTo(maxValue) > 0) {
            return maxValue;
        }
        return value;
    }

    @Override
    public Long count(BigDecimal minValue, BigDecimal maxValue) {
        return null;
    }
}

